/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomEngineVersionStatus {
    AVAILABLE("available"),
    INACTIVE("inactive"),
    INACTIVE_EXCEPT_RESTORE("inactive-except-restore"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomEngineVersionStatus> VALUE_MAP;
    private final String value;

    private CustomEngineVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomEngineVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomEngineVersionStatus> knownValues() {
        EnumSet<CustomEngineVersionStatus> knownValues = EnumSet.allOf(CustomEngineVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomEngineVersionStatus.class, CustomEngineVersionStatus::toString);
    }
}

