/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyDbSnapshotResponse extends RdsResponse implements
        ToCopyableBuilder<CopyDbSnapshotResponse.Builder, CopyDbSnapshotResponse> {
    private static final SdkField<DBSnapshot> DB_SNAPSHOT_FIELD = SdkField.<DBSnapshot> builder(MarshallingType.SDK_POJO)
            .memberName("DBSnapshot").getter(getter(CopyDbSnapshotResponse::dbSnapshot)).setter(setter(Builder::dbSnapshot))
            .constructor(DBSnapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_FIELD));

    private final DBSnapshot dbSnapshot;

    private CopyDbSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.dbSnapshot = builder.dbSnapshot;
    }

    /**
     * Returns the value of the DBSnapshot property for this object.
     * 
     * @return The value of the DBSnapshot property for this object.
     */
    public final DBSnapshot dbSnapshot() {
        return dbSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbSnapshotResponse)) {
            return false;
        }
        CopyDbSnapshotResponse other = (CopyDbSnapshotResponse) obj;
        return Objects.equals(dbSnapshot(), other.dbSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyDbSnapshotResponse").add("DBSnapshot", dbSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSnapshot":
            return Optional.ofNullable(clazz.cast(dbSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyDbSnapshotResponse, T> g) {
        return obj -> g.apply((CopyDbSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CopyDbSnapshotResponse> {
        /**
         * Sets the value of the DBSnapshot property for this object.
         *
         * @param dbSnapshot
         *        The new value for the DBSnapshot property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshot(DBSnapshot dbSnapshot);

        /**
         * Sets the value of the DBSnapshot property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DBSnapshot.Builder} avoiding the need to
         * create one manually via {@link DBSnapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DBSnapshot.Builder#build()} is called immediately and its result
         * is passed to {@link #dbSnapshot(DBSnapshot)}.
         * 
         * @param dbSnapshot
         *        a consumer that will call methods on {@link DBSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSnapshot(DBSnapshot)
         */
        default Builder dbSnapshot(Consumer<DBSnapshot.Builder> dbSnapshot) {
            return dbSnapshot(DBSnapshot.builder().applyMutation(dbSnapshot).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBSnapshot dbSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbSnapshotResponse model) {
            super(model);
            dbSnapshot(model.dbSnapshot);
        }

        public final DBSnapshot.Builder getDbSnapshot() {
            return dbSnapshot != null ? dbSnapshot.toBuilder() : null;
        }

        public final void setDbSnapshot(DBSnapshot.BuilderImpl dbSnapshot) {
            this.dbSnapshot = dbSnapshot != null ? dbSnapshot.build() : null;
        }

        @Override
        public final Builder dbSnapshot(DBSnapshot dbSnapshot) {
            this.dbSnapshot = dbSnapshot;
            return this;
        }

        @Override
        public CopyDbSnapshotResponse build() {
            return new CopyDbSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
