/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus;
import software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBProxyEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBProxyEndpoint> {
    private static final SdkField<String> DB_PROXY_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyEndpointName").getter(DBProxyEndpoint.getter(DBProxyEndpoint::dbProxyEndpointName)).setter(DBProxyEndpoint.setter(Builder::dbProxyEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpointName").build()}).build();
    private static final SdkField<String> DB_PROXY_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyEndpointArn").getter(DBProxyEndpoint.getter(DBProxyEndpoint::dbProxyEndpointArn)).setter(DBProxyEndpoint.setter(Builder::dbProxyEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpointArn").build()}).build();
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(DBProxyEndpoint.getter(DBProxyEndpoint::dbProxyName)).setter(DBProxyEndpoint.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBProxyEndpoint.getter(DBProxyEndpoint::statusAsString)).setter(DBProxyEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DBProxyEndpoint.getter(DBProxyEndpoint::vpcId)).setter(DBProxyEndpoint.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(DBProxyEndpoint.getter(DBProxyEndpoint::vpcSecurityGroupIds)).setter(DBProxyEndpoint.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSubnetIds").getter(DBProxyEndpoint.getter(DBProxyEndpoint::vpcSubnetIds)).setter(DBProxyEndpoint.setter(Builder::vpcSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(DBProxyEndpoint.getter(DBProxyEndpoint::endpoint)).setter(DBProxyEndpoint.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(DBProxyEndpoint.getter(DBProxyEndpoint::createdDate)).setter(DBProxyEndpoint.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> TARGET_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetRole").getter(DBProxyEndpoint.getter(DBProxyEndpoint::targetRoleAsString)).setter(DBProxyEndpoint.setter(Builder::targetRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRole").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(DBProxyEndpoint.getter(DBProxyEndpoint::isDefault)).setter(DBProxyEndpoint.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_ENDPOINT_NAME_FIELD, DB_PROXY_ENDPOINT_ARN_FIELD, DB_PROXY_NAME_FIELD, STATUS_FIELD, VPC_ID_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, VPC_SUBNET_IDS_FIELD, ENDPOINT_FIELD, CREATED_DATE_FIELD, TARGET_ROLE_FIELD, IS_DEFAULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbProxyEndpointName;
    private final String dbProxyEndpointArn;
    private final String dbProxyName;
    private final String status;
    private final String vpcId;
    private final List<String> vpcSecurityGroupIds;
    private final List<String> vpcSubnetIds;
    private final String endpoint;
    private final Instant createdDate;
    private final String targetRole;
    private final Boolean isDefault;

    private DBProxyEndpoint(BuilderImpl builder) {
        this.dbProxyEndpointName = builder.dbProxyEndpointName;
        this.dbProxyEndpointArn = builder.dbProxyEndpointArn;
        this.dbProxyName = builder.dbProxyName;
        this.status = builder.status;
        this.vpcId = builder.vpcId;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.endpoint = builder.endpoint;
        this.createdDate = builder.createdDate;
        this.targetRole = builder.targetRole;
        this.isDefault = builder.isDefault;
    }

    public final String dbProxyEndpointName() {
        return this.dbProxyEndpointName;
    }

    public final String dbProxyEndpointArn() {
        return this.dbProxyEndpointArn;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    public final DBProxyEndpointStatus status() {
        return DBProxyEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final boolean hasVpcSubnetIds() {
        return this.vpcSubnetIds != null && !(this.vpcSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final DBProxyEndpointTargetRole targetRole() {
        return DBProxyEndpointTargetRole.fromValue(this.targetRole);
    }

    public final String targetRoleAsString() {
        return this.targetRole;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBProxyEndpoint)) {
            return false;
        }
        DBProxyEndpoint other = (DBProxyEndpoint)obj;
        return Objects.equals(this.dbProxyEndpointName(), other.dbProxyEndpointName()) && Objects.equals(this.dbProxyEndpointArn(), other.dbProxyEndpointArn()) && Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && this.hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(this.vpcSubnetIds(), other.vpcSubnetIds()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.targetRoleAsString(), other.targetRoleAsString()) && Objects.equals(this.isDefault(), other.isDefault());
    }

    public final String toString() {
        return ToString.builder((String)"DBProxyEndpoint").add("DBProxyEndpointName", (Object)this.dbProxyEndpointName()).add("DBProxyEndpointArn", (Object)this.dbProxyEndpointArn()).add("DBProxyName", (Object)this.dbProxyName()).add("Status", (Object)this.statusAsString()).add("VpcId", (Object)this.vpcId()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("VpcSubnetIds", this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null).add("Endpoint", (Object)this.endpoint()).add("CreatedDate", (Object)this.createdDate()).add("TargetRole", (Object)this.targetRoleAsString()).add("IsDefault", (Object)this.isDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyEndpointName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyEndpointName()));
            }
            case "DBProxyEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.dbProxyEndpointArn()));
            }
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "VpcSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnetIds()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "TargetRole": {
                return Optional.ofNullable(clazz.cast(this.targetRoleAsString()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBProxyEndpoint, T> g) {
        return obj -> g.apply((DBProxyEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbProxyEndpointName;
        private String dbProxyEndpointArn;
        private String dbProxyName;
        private String status;
        private String vpcId;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private String endpoint;
        private Instant createdDate;
        private String targetRole;
        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(DBProxyEndpoint model) {
            this.dbProxyEndpointName(model.dbProxyEndpointName);
            this.dbProxyEndpointArn(model.dbProxyEndpointArn);
            this.dbProxyName(model.dbProxyName);
            this.status(model.status);
            this.vpcId(model.vpcId);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.vpcSubnetIds(model.vpcSubnetIds);
            this.endpoint(model.endpoint);
            this.createdDate(model.createdDate);
            this.targetRole(model.targetRole);
            this.isDefault(model.isDefault);
        }

        public final String getDbProxyEndpointName() {
            return this.dbProxyEndpointName;
        }

        public final void setDbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
        }

        @Override
        public final Builder dbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        public final String getDbProxyEndpointArn() {
            return this.dbProxyEndpointArn;
        }

        public final void setDbProxyEndpointArn(String dbProxyEndpointArn) {
            this.dbProxyEndpointArn = dbProxyEndpointArn;
        }

        @Override
        public final Builder dbProxyEndpointArn(String dbProxyEndpointArn) {
            this.dbProxyEndpointArn = dbProxyEndpointArn;
            return this;
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DBProxyEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (this.vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String ... vpcSubnetIds) {
            this.vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getTargetRole() {
            return this.targetRole;
        }

        public final void setTargetRole(String targetRole) {
            this.targetRole = targetRole;
        }

        @Override
        public final Builder targetRole(String targetRole) {
            this.targetRole = targetRole;
            return this;
        }

        @Override
        public final Builder targetRole(DBProxyEndpointTargetRole targetRole) {
            this.targetRole(targetRole == null ? null : targetRole.toString());
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public DBProxyEndpoint build() {
            return new DBProxyEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBProxyEndpoint> {
        public Builder dbProxyEndpointName(String var1);

        public Builder dbProxyEndpointArn(String var1);

        public Builder dbProxyName(String var1);

        public Builder status(String var1);

        public Builder status(DBProxyEndpointStatus var1);

        public Builder vpcId(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder vpcSubnetIds(Collection<String> var1);

        public Builder vpcSubnetIds(String ... var1);

        public Builder endpoint(String var1);

        public Builder createdDate(Instant var1);

        public Builder targetRole(String var1);

        public Builder targetRole(DBProxyEndpointTargetRole var1);

        public Builder isDefault(Boolean var1);
    }
}

