/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbClusterRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::dbClusterIdentifier)).setter(ModifyDbClusterRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> NEW_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewDBClusterIdentifier").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::newDBClusterIdentifier)).setter(ModifyDbClusterRequest.setter(Builder::newDBClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyImmediately").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::applyImmediately)).setter(ModifyDbClusterRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::backupRetentionPeriod)).setter(ModifyDbClusterRequest.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroupName").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::dbClusterParameterGroupName)).setter(ModifyDbClusterRequest.setter(Builder::dbClusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::vpcSecurityGroupIds)).setter(ModifyDbClusterRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::port)).setter(ModifyDbClusterRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserPassword").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::masterUserPassword)).setter(ModifyDbClusterRequest.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::optionGroupName)).setter(ModifyDbClusterRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::preferredBackupWindow)).setter(ModifyDbClusterRequest.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::preferredMaintenanceWindow)).setter(ModifyDbClusterRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::enableIAMDatabaseAuthentication)).setter(ModifyDbClusterRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BacktrackWindow").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::backtrackWindow)).setter(ModifyDbClusterRequest.setter(Builder::backtrackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()}).build();
    private static final SdkField<CloudwatchLogsExportConfiguration> CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudwatchLogsExportConfiguration").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::cloudwatchLogsExportConfiguration)).setter(ModifyDbClusterRequest.setter(Builder::cloudwatchLogsExportConfiguration)).constructor(CloudwatchLogsExportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsExportConfiguration").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::engineVersion)).setter(ModifyDbClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowMajorVersionUpgrade").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::allowMajorVersionUpgrade)).setter(ModifyDbClusterRequest.setter(Builder::allowMajorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build()}).build();
    private static final SdkField<String> DB_INSTANCE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceParameterGroupName").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::dbInstanceParameterGroupName)).setter(ModifyDbClusterRequest.setter(Builder::dbInstanceParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceParameterGroupName").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::domain)).setter(ModifyDbClusterRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::domainIAMRoleName)).setter(ModifyDbClusterRequest.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingConfiguration").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::scalingConfiguration)).setter(ModifyDbClusterRequest.setter(Builder::scalingConfiguration)).constructor(ScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::deletionProtection)).setter(ModifyDbClusterRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> ENABLE_HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableHttpEndpoint").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::enableHttpEndpoint)).setter(ModifyDbClusterRequest.setter(Builder::enableHttpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHttpEndpoint").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::copyTagsToSnapshot)).setter(ModifyDbClusterRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Boolean> ENABLE_GLOBAL_WRITE_FORWARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableGlobalWriteForwarding").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::enableGlobalWriteForwarding)).setter(ModifyDbClusterRequest.setter(Builder::enableGlobalWriteForwarding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableGlobalWriteForwarding").build()}).build();
    private static final SdkField<String> DB_CLUSTER_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterInstanceClass").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::dbClusterInstanceClass)).setter(ModifyDbClusterRequest.setter(Builder::dbClusterInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterInstanceClass").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::allocatedStorage)).setter(ModifyDbClusterRequest.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::storageType)).setter(ModifyDbClusterRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::iops)).setter(ModifyDbClusterRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::autoMinorVersionUpgrade)).setter(ModifyDbClusterRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringInterval").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::monitoringInterval)).setter(ModifyDbClusterRequest.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringRoleArn").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::monitoringRoleArn)).setter(ModifyDbClusterRequest.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::enablePerformanceInsights)).setter(ModifyDbClusterRequest.setter(Builder::enablePerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceInsightsKMSKeyId").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::performanceInsightsKMSKeyId)).setter(ModifyDbClusterRequest.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerformanceInsightsRetentionPeriod").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::performanceInsightsRetentionPeriod)).setter(ModifyDbClusterRequest.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessV2ScalingConfiguration").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::serverlessV2ScalingConfiguration)).setter(ModifyDbClusterRequest.setter(Builder::serverlessV2ScalingConfiguration)).constructor(ServerlessV2ScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::networkType)).setter(ModifyDbClusterRequest.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::manageMasterUserPassword)).setter(ModifyDbClusterRequest.setter(Builder::manageMasterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build()}).build();
    private static final SdkField<Boolean> ROTATE_MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RotateMasterUserPassword").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::rotateMasterUserPassword)).setter(ModifyDbClusterRequest.setter(Builder::rotateMasterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotateMasterUserPassword").build()}).build();
    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserSecretKmsKeyId").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::masterUserSecretKmsKeyId)).setter(ModifyDbClusterRequest.setter(Builder::masterUserSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build()}).build();
    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineMode").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::engineMode)).setter(ModifyDbClusterRequest.setter(Builder::engineMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()}).build();
    private static final SdkField<Boolean> ALLOW_ENGINE_MODE_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowEngineModeChange").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::allowEngineModeChange)).setter(ModifyDbClusterRequest.setter(Builder::allowEngineModeChange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowEngineModeChange").build()}).build();
    private static final SdkField<Boolean> ENABLE_LOCAL_WRITE_FORWARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableLocalWriteForwarding").getter(ModifyDbClusterRequest.getter(ModifyDbClusterRequest::enableLocalWriteForwarding)).setter(ModifyDbClusterRequest.setter(Builder::enableLocalWriteForwarding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLocalWriteForwarding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, NEW_DB_CLUSTER_IDENTIFIER_FIELD, APPLY_IMMEDIATELY_FIELD, BACKUP_RETENTION_PERIOD_FIELD, DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, PORT_FIELD, MASTER_USER_PASSWORD_FIELD, OPTION_GROUP_NAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD, CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD, ENGINE_VERSION_FIELD, ALLOW_MAJOR_VERSION_UPGRADE_FIELD, DB_INSTANCE_PARAMETER_GROUP_NAME_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, SCALING_CONFIGURATION_FIELD, DELETION_PROTECTION_FIELD, ENABLE_HTTP_ENDPOINT_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, ENABLE_GLOBAL_WRITE_FORWARDING_FIELD, DB_CLUSTER_INSTANCE_CLASS_FIELD, ALLOCATED_STORAGE_FIELD, STORAGE_TYPE_FIELD, IOPS_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, NETWORK_TYPE_FIELD, MANAGE_MASTER_USER_PASSWORD_FIELD, ROTATE_MASTER_USER_PASSWORD_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD, ENGINE_MODE_FIELD, ALLOW_ENGINE_MODE_CHANGE_FIELD, ENABLE_LOCAL_WRITE_FORWARDING_FIELD));
    private final String dbClusterIdentifier;
    private final String newDBClusterIdentifier;
    private final Boolean applyImmediately;
    private final Integer backupRetentionPeriod;
    private final String dbClusterParameterGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final Integer port;
    private final String masterUserPassword;
    private final String optionGroupName;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Boolean enableIAMDatabaseAuthentication;
    private final Long backtrackWindow;
    private final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
    private final String engineVersion;
    private final Boolean allowMajorVersionUpgrade;
    private final String dbInstanceParameterGroupName;
    private final String domain;
    private final String domainIAMRoleName;
    private final ScalingConfiguration scalingConfiguration;
    private final Boolean deletionProtection;
    private final Boolean enableHttpEndpoint;
    private final Boolean copyTagsToSnapshot;
    private final Boolean enableGlobalWriteForwarding;
    private final String dbClusterInstanceClass;
    private final Integer allocatedStorage;
    private final String storageType;
    private final Integer iops;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final Boolean enablePerformanceInsights;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
    private final String networkType;
    private final Boolean manageMasterUserPassword;
    private final Boolean rotateMasterUserPassword;
    private final String masterUserSecretKmsKeyId;
    private final String engineMode;
    private final Boolean allowEngineModeChange;
    private final Boolean enableLocalWriteForwarding;

    private ModifyDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.newDBClusterIdentifier = builder.newDBClusterIdentifier;
        this.applyImmediately = builder.applyImmediately;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.port = builder.port;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.cloudwatchLogsExportConfiguration = builder.cloudwatchLogsExportConfiguration;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.dbInstanceParameterGroupName = builder.dbInstanceParameterGroupName;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.deletionProtection = builder.deletionProtection;
        this.enableHttpEndpoint = builder.enableHttpEndpoint;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.enableGlobalWriteForwarding = builder.enableGlobalWriteForwarding;
        this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.storageType = builder.storageType;
        this.iops = builder.iops;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.networkType = builder.networkType;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.rotateMasterUserPassword = builder.rotateMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.engineMode = builder.engineMode;
        this.allowEngineModeChange = builder.allowEngineModeChange;
        this.enableLocalWriteForwarding = builder.enableLocalWriteForwarding;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String newDBClusterIdentifier() {
        return this.newDBClusterIdentifier;
    }

    public final Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final Integer port() {
        return this.port;
    }

    public final String masterUserPassword() {
        return this.masterUserPassword;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final Long backtrackWindow() {
        return this.backtrackWindow;
    }

    public final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration() {
        return this.cloudwatchLogsExportConfiguration;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Boolean allowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public final String dbInstanceParameterGroupName() {
        return this.dbInstanceParameterGroupName;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public final ScalingConfiguration scalingConfiguration() {
        return this.scalingConfiguration;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean enableHttpEndpoint() {
        return this.enableHttpEndpoint;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final Boolean enableGlobalWriteForwarding() {
        return this.enableGlobalWriteForwarding;
    }

    public final String dbClusterInstanceClass() {
        return this.dbClusterInstanceClass;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public final String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public final Boolean enablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public final String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public final Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return this.serverlessV2ScalingConfiguration;
    }

    public final String networkType() {
        return this.networkType;
    }

    public final Boolean manageMasterUserPassword() {
        return this.manageMasterUserPassword;
    }

    public final Boolean rotateMasterUserPassword() {
        return this.rotateMasterUserPassword;
    }

    public final String masterUserSecretKmsKeyId() {
        return this.masterUserSecretKmsKeyId;
    }

    public final String engineMode() {
        return this.engineMode;
    }

    public final Boolean allowEngineModeChange() {
        return this.allowEngineModeChange;
    }

    public final Boolean enableLocalWriteForwarding() {
        return this.enableLocalWriteForwarding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchLogsExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableHttpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableGlobalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotateMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowEngineModeChange());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableLocalWriteForwarding());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterRequest)) {
            return false;
        }
        ModifyDbClusterRequest other = (ModifyDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.newDBClusterIdentifier(), other.newDBClusterIdentifier()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.backtrackWindow(), other.backtrackWindow()) && Objects.equals(this.cloudwatchLogsExportConfiguration(), other.cloudwatchLogsExportConfiguration()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade()) && Objects.equals(this.dbInstanceParameterGroupName(), other.dbInstanceParameterGroupName()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.enableHttpEndpoint(), other.enableHttpEndpoint()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.enableGlobalWriteForwarding(), other.enableGlobalWriteForwarding()) && Objects.equals(this.dbClusterInstanceClass(), other.dbClusterInstanceClass()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.enablePerformanceInsights(), other.enablePerformanceInsights()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && Objects.equals(this.serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration()) && Objects.equals(this.networkType(), other.networkType()) && Objects.equals(this.manageMasterUserPassword(), other.manageMasterUserPassword()) && Objects.equals(this.rotateMasterUserPassword(), other.rotateMasterUserPassword()) && Objects.equals(this.masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId()) && Objects.equals(this.engineMode(), other.engineMode()) && Objects.equals(this.allowEngineModeChange(), other.allowEngineModeChange()) && Objects.equals(this.enableLocalWriteForwarding(), other.enableLocalWriteForwarding());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbClusterRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("NewDBClusterIdentifier", (Object)this.newDBClusterIdentifier()).add("ApplyImmediately", (Object)this.applyImmediately()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("DBClusterParameterGroupName", (Object)this.dbClusterParameterGroupName()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("Port", (Object)this.port()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("OptionGroupName", (Object)this.optionGroupName()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("BacktrackWindow", (Object)this.backtrackWindow()).add("CloudwatchLogsExportConfiguration", (Object)this.cloudwatchLogsExportConfiguration()).add("EngineVersion", (Object)this.engineVersion()).add("AllowMajorVersionUpgrade", (Object)this.allowMajorVersionUpgrade()).add("DBInstanceParameterGroupName", (Object)this.dbInstanceParameterGroupName()).add("Domain", (Object)this.domain()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).add("DeletionProtection", (Object)this.deletionProtection()).add("EnableHttpEndpoint", (Object)this.enableHttpEndpoint()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("EnableGlobalWriteForwarding", (Object)this.enableGlobalWriteForwarding()).add("DBClusterInstanceClass", (Object)this.dbClusterInstanceClass()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("StorageType", (Object)this.storageType()).add("Iops", (Object)this.iops()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("EnablePerformanceInsights", (Object)this.enablePerformanceInsights()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("ServerlessV2ScalingConfiguration", (Object)this.serverlessV2ScalingConfiguration()).add("NetworkType", (Object)this.networkType()).add("ManageMasterUserPassword", (Object)this.manageMasterUserPassword()).add("RotateMasterUserPassword", (Object)this.rotateMasterUserPassword()).add("MasterUserSecretKmsKeyId", (Object)this.masterUserSecretKmsKeyId()).add("EngineMode", (Object)this.engineMode()).add("AllowEngineModeChange", (Object)this.allowEngineModeChange()).add("EnableLocalWriteForwarding", (Object)this.enableLocalWriteForwarding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "NewDBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.newDBClusterIdentifier()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "DBClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "BacktrackWindow": {
                return Optional.ofNullable(clazz.cast(this.backtrackWindow()));
            }
            case "CloudwatchLogsExportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchLogsExportConfiguration()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AllowMajorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowMajorVersionUpgrade()));
            }
            case "DBInstanceParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceParameterGroupName()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
            case "ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "EnableHttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.enableHttpEndpoint()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "EnableGlobalWriteForwarding": {
                return Optional.ofNullable(clazz.cast(this.enableGlobalWriteForwarding()));
            }
            case "DBClusterInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbClusterInstanceClass()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "EnablePerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceInsights()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "ServerlessV2ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverlessV2ScalingConfiguration()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
            case "ManageMasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.manageMasterUserPassword()));
            }
            case "RotateMasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.rotateMasterUserPassword()));
            }
            case "MasterUserSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.masterUserSecretKmsKeyId()));
            }
            case "EngineMode": {
                return Optional.ofNullable(clazz.cast(this.engineMode()));
            }
            case "AllowEngineModeChange": {
                return Optional.ofNullable(clazz.cast(this.allowEngineModeChange()));
            }
            case "EnableLocalWriteForwarding": {
                return Optional.ofNullable(clazz.cast(this.enableLocalWriteForwarding()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String newDBClusterIdentifier;
        private Boolean applyImmediately;
        private Integer backupRetentionPeriod;
        private String dbClusterParameterGroupName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Integer port;
        private String masterUserPassword;
        private String optionGroupName;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Boolean enableIAMDatabaseAuthentication;
        private Long backtrackWindow;
        private CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
        private String engineVersion;
        private Boolean allowMajorVersionUpgrade;
        private String dbInstanceParameterGroupName;
        private String domain;
        private String domainIAMRoleName;
        private ScalingConfiguration scalingConfiguration;
        private Boolean deletionProtection;
        private Boolean enableHttpEndpoint;
        private Boolean copyTagsToSnapshot;
        private Boolean enableGlobalWriteForwarding;
        private String dbClusterInstanceClass;
        private Integer allocatedStorage;
        private String storageType;
        private Integer iops;
        private Boolean autoMinorVersionUpgrade;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private Boolean enablePerformanceInsights;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
        private String networkType;
        private Boolean manageMasterUserPassword;
        private Boolean rotateMasterUserPassword;
        private String masterUserSecretKmsKeyId;
        private String engineMode;
        private Boolean allowEngineModeChange;
        private Boolean enableLocalWriteForwarding;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.newDBClusterIdentifier(model.newDBClusterIdentifier);
            this.applyImmediately(model.applyImmediately);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.port(model.port);
            this.masterUserPassword(model.masterUserPassword);
            this.optionGroupName(model.optionGroupName);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.backtrackWindow(model.backtrackWindow);
            this.cloudwatchLogsExportConfiguration(model.cloudwatchLogsExportConfiguration);
            this.engineVersion(model.engineVersion);
            this.allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            this.dbInstanceParameterGroupName(model.dbInstanceParameterGroupName);
            this.domain(model.domain);
            this.domainIAMRoleName(model.domainIAMRoleName);
            this.scalingConfiguration(model.scalingConfiguration);
            this.deletionProtection(model.deletionProtection);
            this.enableHttpEndpoint(model.enableHttpEndpoint);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.enableGlobalWriteForwarding(model.enableGlobalWriteForwarding);
            this.dbClusterInstanceClass(model.dbClusterInstanceClass);
            this.allocatedStorage(model.allocatedStorage);
            this.storageType(model.storageType);
            this.iops(model.iops);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.monitoringInterval(model.monitoringInterval);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.enablePerformanceInsights(model.enablePerformanceInsights);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            this.networkType(model.networkType);
            this.manageMasterUserPassword(model.manageMasterUserPassword);
            this.rotateMasterUserPassword(model.rotateMasterUserPassword);
            this.masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            this.engineMode(model.engineMode);
            this.allowEngineModeChange(model.allowEngineModeChange);
            this.enableLocalWriteForwarding(model.enableLocalWriteForwarding);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getNewDBClusterIdentifier() {
            return this.newDBClusterIdentifier;
        }

        public final void setNewDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
        }

        @Override
        public final Builder newDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Long getBacktrackWindow() {
            return this.backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final CloudwatchLogsExportConfiguration.Builder getCloudwatchLogsExportConfiguration() {
            return this.cloudwatchLogsExportConfiguration != null ? this.cloudwatchLogsExportConfiguration.toBuilder() : null;
        }

        public final void setCloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration.BuilderImpl cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration.build() : null;
        }

        @Override
        public final Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return this.allowMajorVersionUpgrade;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final String getDbInstanceParameterGroupName() {
            return this.dbInstanceParameterGroupName;
        }

        public final void setDbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
        }

        @Override
        public final Builder dbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getEnableHttpEndpoint() {
            return this.enableHttpEndpoint;
        }

        public final void setEnableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
        }

        @Override
        public final Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Boolean getEnableGlobalWriteForwarding() {
            return this.enableGlobalWriteForwarding;
        }

        public final void setEnableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
        }

        @Override
        public final Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
            return this;
        }

        public final String getDbClusterInstanceClass() {
            return this.dbClusterInstanceClass;
        }

        public final void setDbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
        }

        @Override
        public final Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return this.serverlessV2ScalingConfiguration != null ? this.serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return this.manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final Boolean getRotateMasterUserPassword() {
            return this.rotateMasterUserPassword;
        }

        public final void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
        }

        @Override
        public final Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return this.masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final String getEngineMode() {
            return this.engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final Boolean getAllowEngineModeChange() {
            return this.allowEngineModeChange;
        }

        public final void setAllowEngineModeChange(Boolean allowEngineModeChange) {
            this.allowEngineModeChange = allowEngineModeChange;
        }

        @Override
        public final Builder allowEngineModeChange(Boolean allowEngineModeChange) {
            this.allowEngineModeChange = allowEngineModeChange;
            return this;
        }

        public final Boolean getEnableLocalWriteForwarding() {
            return this.enableLocalWriteForwarding;
        }

        public final void setEnableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
        }

        @Override
        public final Builder enableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterRequest build() {
            return new ModifyDbClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder newDBClusterIdentifier(String var1);

        public Builder applyImmediately(Boolean var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder dbClusterParameterGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder port(Integer var1);

        public Builder masterUserPassword(String var1);

        public Builder optionGroupName(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder backtrackWindow(Long var1);

        public Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration var1);

        default public Builder cloudwatchLogsExportConfiguration(Consumer<CloudwatchLogsExportConfiguration.Builder> cloudwatchLogsExportConfiguration) {
            return this.cloudwatchLogsExportConfiguration((CloudwatchLogsExportConfiguration)((CloudwatchLogsExportConfiguration.Builder)CloudwatchLogsExportConfiguration.builder().applyMutation(cloudwatchLogsExportConfiguration)).build());
        }

        public Builder engineVersion(String var1);

        public Builder allowMajorVersionUpgrade(Boolean var1);

        public Builder dbInstanceParameterGroupName(String var1);

        public Builder domain(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder scalingConfiguration(ScalingConfiguration var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfiguration)((ScalingConfiguration.Builder)ScalingConfiguration.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder deletionProtection(Boolean var1);

        public Builder enableHttpEndpoint(Boolean var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder enableGlobalWriteForwarding(Boolean var1);

        public Builder dbClusterInstanceClass(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder storageType(String var1);

        public Builder iops(Integer var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder enablePerformanceInsights(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration var1);

        default public Builder serverlessV2ScalingConfiguration(Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return this.serverlessV2ScalingConfiguration((ServerlessV2ScalingConfiguration)((ServerlessV2ScalingConfiguration.Builder)ServerlessV2ScalingConfiguration.builder().applyMutation(serverlessV2ScalingConfiguration)).build());
        }

        public Builder networkType(String var1);

        public Builder manageMasterUserPassword(Boolean var1);

        public Builder rotateMasterUserPassword(Boolean var1);

        public Builder masterUserSecretKmsKeyId(String var1);

        public Builder engineMode(String var1);

        public Builder allowEngineModeChange(Boolean var1);

        public Builder enableLocalWriteForwarding(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

