/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBInstanceRole implements SdkPojo, Serializable, ToCopyableBuilder<DBInstanceRole.Builder, DBInstanceRole> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DBInstanceRole::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureName").getter(getter(DBInstanceRole::featureName)).setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBInstanceRole::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            FEATURE_NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String featureName;

    private final String status;

    private DBInstanceRole(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.featureName = builder.featureName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For
     * information about supported feature names, see <code>DBEngineVersion</code>.
     * </p>
     * 
     * @return The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM)
     *         role. For information about supported feature names, see <code>DBEngineVersion</code>.
     */
    public final String featureName() {
        return featureName;
    }

    /**
     * <p>
     * Describes the state of association between the IAM role and the DB instance. The Status property returns one of
     * the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other Amazon
     * Web Services services on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to
     * assume the IAM role in order to access other Amazon Web Services services on your behalf.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes the state of association between the IAM role and the DB instance. The Status property returns
     *         one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other
     *         Amazon Web Services services on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable
     *         to assume the IAM role in order to access other Amazon Web Services services on your behalf.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(featureName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstanceRole)) {
            return false;
        }
        DBInstanceRole other = (DBInstanceRole) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(featureName(), other.featureName())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBInstanceRole").add("RoleArn", roleArn()).add("FeatureName", featureName())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "FeatureName":
            return Optional.ofNullable(clazz.cast(featureName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBInstanceRole, T> g) {
        return obj -> g.apply((DBInstanceRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBInstanceRole> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role.
         * For information about supported feature names, see <code>DBEngineVersion</code>.
         * </p>
         * 
         * @param featureName
         *        The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM)
         *        role. For information about supported feature names, see <code>DBEngineVersion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureName(String featureName);

        /**
         * <p>
         * Describes the state of association between the IAM role and the DB instance. The Status property returns one
         * of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other
         * Amazon Web Services services on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to
         * assume the IAM role in order to access other Amazon Web Services services on your behalf.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Describes the state of association between the IAM role and the DB instance. The Status property
         *        returns one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access
         *        other Amazon Web Services services on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is
         *        unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String featureName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstanceRole model) {
            roleArn(model.roleArn);
            featureName(model.featureName);
            status(model.status);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFeatureName() {
            return featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public DBInstanceRole build() {
            return new DBInstanceRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
