/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingCloudwatchLogsExports
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingCloudwatchLogsExports> {
    private static final SdkField<List<String>> LOG_TYPES_TO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogTypesToEnable").getter(PendingCloudwatchLogsExports.getter(PendingCloudwatchLogsExports::logTypesToEnable)).setter(PendingCloudwatchLogsExports.setter(Builder::logTypesToEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToEnable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_TYPES_TO_DISABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogTypesToDisable").getter(PendingCloudwatchLogsExports.getter(PendingCloudwatchLogsExports::logTypesToDisable)).setter(PendingCloudwatchLogsExports.setter(Builder::logTypesToDisable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToDisable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPES_TO_ENABLE_FIELD, LOG_TYPES_TO_DISABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> logTypesToEnable;
    private final List<String> logTypesToDisable;

    private PendingCloudwatchLogsExports(BuilderImpl builder) {
        this.logTypesToEnable = builder.logTypesToEnable;
        this.logTypesToDisable = builder.logTypesToDisable;
    }

    public final boolean hasLogTypesToEnable() {
        return this.logTypesToEnable != null && !(this.logTypesToEnable instanceof SdkAutoConstructList);
    }

    public final List<String> logTypesToEnable() {
        return this.logTypesToEnable;
    }

    public final boolean hasLogTypesToDisable() {
        return this.logTypesToDisable != null && !(this.logTypesToDisable instanceof SdkAutoConstructList);
    }

    public final List<String> logTypesToDisable() {
        return this.logTypesToDisable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTypesToEnable() ? this.logTypesToEnable() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTypesToDisable() ? this.logTypesToDisable() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingCloudwatchLogsExports)) {
            return false;
        }
        PendingCloudwatchLogsExports other = (PendingCloudwatchLogsExports)obj;
        return this.hasLogTypesToEnable() == other.hasLogTypesToEnable() && Objects.equals(this.logTypesToEnable(), other.logTypesToEnable()) && this.hasLogTypesToDisable() == other.hasLogTypesToDisable() && Objects.equals(this.logTypesToDisable(), other.logTypesToDisable());
    }

    public final String toString() {
        return ToString.builder((String)"PendingCloudwatchLogsExports").add("LogTypesToEnable", this.hasLogTypesToEnable() ? this.logTypesToEnable() : null).add("LogTypesToDisable", this.hasLogTypesToDisable() ? this.logTypesToDisable() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogTypesToEnable": {
                return Optional.ofNullable(clazz.cast(this.logTypesToEnable()));
            }
            case "LogTypesToDisable": {
                return Optional.ofNullable(clazz.cast(this.logTypesToDisable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingCloudwatchLogsExports, T> g) {
        return obj -> g.apply((PendingCloudwatchLogsExports)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> logTypesToEnable = DefaultSdkAutoConstructList.getInstance();
        private List<String> logTypesToDisable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PendingCloudwatchLogsExports model) {
            this.logTypesToEnable(model.logTypesToEnable);
            this.logTypesToDisable(model.logTypesToDisable);
        }

        public final Collection<String> getLogTypesToEnable() {
            if (this.logTypesToEnable instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logTypesToEnable;
        }

        public final void setLogTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
        }

        @Override
        @Transient
        public final Builder logTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logTypesToEnable(String ... logTypesToEnable) {
            this.logTypesToEnable(Arrays.asList(logTypesToEnable));
            return this;
        }

        public final Collection<String> getLogTypesToDisable() {
            if (this.logTypesToDisable instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logTypesToDisable;
        }

        public final void setLogTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
        }

        @Override
        @Transient
        public final Builder logTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logTypesToDisable(String ... logTypesToDisable) {
            this.logTypesToDisable(Arrays.asList(logTypesToDisable));
            return this;
        }

        public PendingCloudwatchLogsExports build() {
            return new PendingCloudwatchLogsExports(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingCloudwatchLogsExports> {
        public Builder logTypesToEnable(Collection<String> var1);

        public Builder logTypesToEnable(String ... var1);

        public Builder logTypesToDisable(Collection<String> var1);

        public Builder logTypesToDisable(String ... var1);
    }
}

