/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreDbClusterFromS3Request
extends RdsRequest
implements ToCopyableBuilder<Builder, RestoreDbClusterFromS3Request> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::availabilityZones)).setter(RestoreDbClusterFromS3Request.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::backupRetentionPeriod)).setter(RestoreDbClusterFromS3Request.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharacterSetName").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::characterSetName)).setter(RestoreDbClusterFromS3Request.setter(Builder::characterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::databaseName)).setter(RestoreDbClusterFromS3Request.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::dbClusterIdentifier)).setter(RestoreDbClusterFromS3Request.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroupName").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::dbClusterParameterGroupName)).setter(RestoreDbClusterFromS3Request.setter(Builder::dbClusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::vpcSecurityGroupIds)).setter(RestoreDbClusterFromS3Request.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::dbSubnetGroupName)).setter(RestoreDbClusterFromS3Request.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::engine)).setter(RestoreDbClusterFromS3Request.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::engineVersion)).setter(RestoreDbClusterFromS3Request.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::port)).setter(RestoreDbClusterFromS3Request.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::masterUsername)).setter(RestoreDbClusterFromS3Request.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserPassword").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::masterUserPassword)).setter(RestoreDbClusterFromS3Request.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::optionGroupName)).setter(RestoreDbClusterFromS3Request.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::preferredBackupWindow)).setter(RestoreDbClusterFromS3Request.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::preferredMaintenanceWindow)).setter(RestoreDbClusterFromS3Request.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::tags)).setter(RestoreDbClusterFromS3Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::storageEncrypted)).setter(RestoreDbClusterFromS3Request.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::kmsKeyId)).setter(RestoreDbClusterFromS3Request.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::enableIAMDatabaseAuthentication)).setter(RestoreDbClusterFromS3Request.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<String> SOURCE_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEngine").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::sourceEngine)).setter(RestoreDbClusterFromS3Request.setter(Builder::sourceEngine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngine").build()}).build();
    private static final SdkField<String> SOURCE_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEngineVersion").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::sourceEngineVersion)).setter(RestoreDbClusterFromS3Request.setter(Builder::sourceEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngineVersion").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::s3BucketName)).setter(RestoreDbClusterFromS3Request.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::s3Prefix)).setter(RestoreDbClusterFromS3Request.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> S3_INGESTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3IngestionRoleArn").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::s3IngestionRoleArn)).setter(RestoreDbClusterFromS3Request.setter(Builder::s3IngestionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3IngestionRoleArn").build()}).build();
    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BacktrackWindow").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::backtrackWindow)).setter(RestoreDbClusterFromS3Request.setter(Builder::backtrackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableCloudwatchLogsExports").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::enableCloudwatchLogsExports)).setter(RestoreDbClusterFromS3Request.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::deletionProtection)).setter(RestoreDbClusterFromS3Request.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::copyTagsToSnapshot)).setter(RestoreDbClusterFromS3Request.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::domain)).setter(RestoreDbClusterFromS3Request.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::domainIAMRoleName)).setter(RestoreDbClusterFromS3Request.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessV2ScalingConfiguration").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::serverlessV2ScalingConfiguration)).setter(RestoreDbClusterFromS3Request.setter(Builder::serverlessV2ScalingConfiguration)).constructor(ServerlessV2ScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(RestoreDbClusterFromS3Request.getter(RestoreDbClusterFromS3Request::networkType)).setter(RestoreDbClusterFromS3Request.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CHARACTER_SET_NAME_FIELD, DATABASE_NAME_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD, OPTION_GROUP_NAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, TAGS_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, SOURCE_ENGINE_FIELD, SOURCE_ENGINE_VERSION_FIELD, S3_BUCKET_NAME_FIELD, S3_PREFIX_FIELD, S3_INGESTION_ROLE_ARN_FIELD, BACKTRACK_WINDOW_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, DELETION_PROTECTION_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, NETWORK_TYPE_FIELD));
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final String dbSubnetGroupName;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String masterUsername;
    private final String masterUserPassword;
    private final String optionGroupName;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final List<Tag> tags;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final Boolean enableIAMDatabaseAuthentication;
    private final String sourceEngine;
    private final String sourceEngineVersion;
    private final String s3BucketName;
    private final String s3Prefix;
    private final String s3IngestionRoleArn;
    private final Long backtrackWindow;
    private final List<String> enableCloudwatchLogsExports;
    private final Boolean deletionProtection;
    private final Boolean copyTagsToSnapshot;
    private final String domain;
    private final String domainIAMRoleName;
    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
    private final String networkType;

    private RestoreDbClusterFromS3Request(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.tags = builder.tags;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.sourceEngine = builder.sourceEngine;
        this.sourceEngineVersion = builder.sourceEngineVersion;
        this.s3BucketName = builder.s3BucketName;
        this.s3Prefix = builder.s3Prefix;
        this.s3IngestionRoleArn = builder.s3IngestionRoleArn;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.deletionProtection = builder.deletionProtection;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.networkType = builder.networkType;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String characterSetName() {
        return this.characterSetName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Integer port() {
        return this.port;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String masterUserPassword() {
        return this.masterUserPassword;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final String sourceEngine() {
        return this.sourceEngine;
    }

    public final String sourceEngineVersion() {
        return this.sourceEngineVersion;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final String s3IngestionRoleArn() {
        return this.s3IngestionRoleArn;
    }

    public final Long backtrackWindow() {
        return this.backtrackWindow;
    }

    public final boolean hasEnableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports != null && !(this.enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return this.serverlessV2ScalingConfiguration;
    }

    public final String networkType() {
        return this.networkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3IngestionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterFromS3Request)) {
            return false;
        }
        RestoreDbClusterFromS3Request other = (RestoreDbClusterFromS3Request)((Object)obj);
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.sourceEngine(), other.sourceEngine()) && Objects.equals(this.sourceEngineVersion(), other.sourceEngineVersion()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3IngestionRoleArn(), other.s3IngestionRoleArn()) && Objects.equals(this.backtrackWindow(), other.backtrackWindow()) && this.hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports() && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName()) && Objects.equals(this.serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration()) && Objects.equals(this.networkType(), other.networkType());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreDbClusterFromS3Request").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("CharacterSetName", (Object)this.characterSetName()).add("DatabaseName", (Object)this.databaseName()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterParameterGroupName", (Object)this.dbClusterParameterGroupName()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Port", (Object)this.port()).add("MasterUsername", (Object)this.masterUsername()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("OptionGroupName", (Object)this.optionGroupName()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("Tags", this.hasTags() ? this.tags() : null).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("SourceEngine", (Object)this.sourceEngine()).add("SourceEngineVersion", (Object)this.sourceEngineVersion()).add("S3BucketName", (Object)this.s3BucketName()).add("S3Prefix", (Object)this.s3Prefix()).add("S3IngestionRoleArn", (Object)this.s3IngestionRoleArn()).add("BacktrackWindow", (Object)this.backtrackWindow()).add("EnableCloudwatchLogsExports", this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null).add("DeletionProtection", (Object)this.deletionProtection()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("Domain", (Object)this.domain()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).add("ServerlessV2ScalingConfiguration", (Object)this.serverlessV2ScalingConfiguration()).add("NetworkType", (Object)this.networkType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "SourceEngine": {
                return Optional.ofNullable(clazz.cast(this.sourceEngine()));
            }
            case "SourceEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceEngineVersion()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3IngestionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.s3IngestionRoleArn()));
            }
            case "BacktrackWindow": {
                return Optional.ofNullable(clazz.cast(this.backtrackWindow()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
            case "ServerlessV2ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverlessV2ScalingConfiguration()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterFromS3Request, T> g) {
        return obj -> g.apply((RestoreDbClusterFromS3Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroupName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String dbSubnetGroupName;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String masterUsername;
        private String masterUserPassword;
        private String optionGroupName;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private Boolean enableIAMDatabaseAuthentication;
        private String sourceEngine;
        private String sourceEngineVersion;
        private String s3BucketName;
        private String s3Prefix;
        private String s3IngestionRoleArn;
        private Long backtrackWindow;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private Boolean deletionProtection;
        private Boolean copyTagsToSnapshot;
        private String domain;
        private String domainIAMRoleName;
        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterFromS3Request model) {
            super(model);
            this.availabilityZones(model.availabilityZones);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.characterSetName(model.characterSetName);
            this.databaseName(model.databaseName);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.port(model.port);
            this.masterUsername(model.masterUsername);
            this.masterUserPassword(model.masterUserPassword);
            this.optionGroupName(model.optionGroupName);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.tags(model.tags);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.sourceEngine(model.sourceEngine);
            this.sourceEngineVersion(model.sourceEngineVersion);
            this.s3BucketName(model.s3BucketName);
            this.s3Prefix(model.s3Prefix);
            this.s3IngestionRoleArn(model.s3IngestionRoleArn);
            this.backtrackWindow(model.backtrackWindow);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.deletionProtection(model.deletionProtection);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.domain(model.domain);
            this.domainIAMRoleName(model.domainIAMRoleName);
            this.serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            this.networkType(model.networkType);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final String getSourceEngine() {
            return this.sourceEngine;
        }

        public final void setSourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
        }

        @Override
        public final Builder sourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
            return this;
        }

        public final String getSourceEngineVersion() {
            return this.sourceEngineVersion;
        }

        public final void setSourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
        }

        @Override
        public final Builder sourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3IngestionRoleArn() {
            return this.s3IngestionRoleArn;
        }

        public final void setS3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
        }

        @Override
        public final Builder s3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
            return this;
        }

        public final Long getBacktrackWindow() {
            return this.backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (this.enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return this.serverlessV2ScalingConfiguration != null ? this.serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterFromS3Request build() {
            return new RestoreDbClusterFromS3Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreDbClusterFromS3Request> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder masterUserPassword(String var1);

        public Builder optionGroupName(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder sourceEngine(String var1);

        public Builder sourceEngineVersion(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3IngestionRoleArn(String var1);

        public Builder backtrackWindow(Long var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder deletionProtection(Boolean var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder domain(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration var1);

        default public Builder serverlessV2ScalingConfiguration(Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return this.serverlessV2ScalingConfiguration((ServerlessV2ScalingConfiguration)((ServerlessV2ScalingConfiguration.Builder)ServerlessV2ScalingConfiguration.builder().applyMutation(serverlessV2ScalingConfiguration)).build());
        }

        public Builder networkType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

