/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DBProxyTargetGroup;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse;

public class DescribeDBProxyTargetGroupsPublisher
implements SdkPublisher<DescribeDbProxyTargetGroupsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbProxyTargetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBProxyTargetGroupsPublisher(RdsAsyncClient client, DescribeDbProxyTargetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBProxyTargetGroupsPublisher(RdsAsyncClient client, DescribeDbProxyTargetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbProxyTargetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbProxyTargetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBProxyTargetGroup> targetGroups() {
        Function<DescribeDbProxyTargetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targetGroups() != null) {
                return response.targetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbProxyTargetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbProxyTargetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDbProxyTargetGroupsResponse> {
        private DescribeDbProxyTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxyTargetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbProxyTargetGroupsResponse> nextPage(DescribeDbProxyTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxyTargetGroupsPublisher.this.client.describeDBProxyTargetGroups(DescribeDBProxyTargetGroupsPublisher.this.firstRequest);
            }
            return DescribeDBProxyTargetGroupsPublisher.this.client.describeDBProxyTargetGroups((DescribeDbProxyTargetGroupsRequest)((Object)DescribeDBProxyTargetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

