/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxyTarget;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterDbProxyTargetsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, RegisterDbProxyTargetsResponse> {
    private static final SdkField<List<DBProxyTarget>> DB_PROXY_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBProxyTargets").getter(RegisterDbProxyTargetsResponse.getter(RegisterDbProxyTargetsResponse::dbProxyTargets)).setter(RegisterDbProxyTargetsResponse.setter(Builder::dbProxyTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBProxyTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_TARGETS_FIELD));
    private final List<DBProxyTarget> dbProxyTargets;

    private RegisterDbProxyTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.dbProxyTargets = builder.dbProxyTargets;
    }

    public final boolean hasDbProxyTargets() {
        return this.dbProxyTargets != null && !(this.dbProxyTargets instanceof SdkAutoConstructList);
    }

    public final List<DBProxyTarget> dbProxyTargets() {
        return this.dbProxyTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbProxyTargets() ? this.dbProxyTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDbProxyTargetsResponse)) {
            return false;
        }
        RegisterDbProxyTargetsResponse other = (RegisterDbProxyTargetsResponse)((Object)obj);
        return this.hasDbProxyTargets() == other.hasDbProxyTargets() && Objects.equals(this.dbProxyTargets(), other.dbProxyTargets());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterDbProxyTargetsResponse").add("DBProxyTargets", this.hasDbProxyTargets() ? this.dbProxyTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyTargets": {
                return Optional.ofNullable(clazz.cast(this.dbProxyTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterDbProxyTargetsResponse, T> g) {
        return obj -> g.apply((RegisterDbProxyTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBProxyTarget> dbProxyTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDbProxyTargetsResponse model) {
            super(model);
            this.dbProxyTargets(model.dbProxyTargets);
        }

        public final List<DBProxyTarget.Builder> getDbProxyTargets() {
            List<DBProxyTarget.Builder> result = TargetListCopier.copyToBuilder(this.dbProxyTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbProxyTargets(Collection<DBProxyTarget.BuilderImpl> dbProxyTargets) {
            this.dbProxyTargets = TargetListCopier.copyFromBuilder(dbProxyTargets);
        }

        @Override
        @Transient
        public final Builder dbProxyTargets(Collection<DBProxyTarget> dbProxyTargets) {
            this.dbProxyTargets = TargetListCopier.copy(dbProxyTargets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbProxyTargets(DBProxyTarget ... dbProxyTargets) {
            this.dbProxyTargets(Arrays.asList(dbProxyTargets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbProxyTargets(Consumer<DBProxyTarget.Builder> ... dbProxyTargets) {
            this.dbProxyTargets(Stream.of(dbProxyTargets).map(c -> (DBProxyTarget)((DBProxyTarget.Builder)DBProxyTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegisterDbProxyTargetsResponse build() {
            return new RegisterDbProxyTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterDbProxyTargetsResponse> {
        public Builder dbProxyTargets(Collection<DBProxyTarget> var1);

        public Builder dbProxyTargets(DBProxyTarget ... var1);

        public Builder dbProxyTargets(Consumer<DBProxyTarget.Builder> ... var1);
    }
}

