/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;

public class DescribeReservedDBInstancesOfferingsPublisher
implements SdkPublisher<DescribeReservedDbInstancesOfferingsResponse> {
    private final RdsAsyncClient client;
    private final DescribeReservedDbInstancesOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedDBInstancesOfferingsPublisher(RdsAsyncClient client, DescribeReservedDbInstancesOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedDBInstancesOfferingsPublisher(RdsAsyncClient client, DescribeReservedDbInstancesOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedDbInstancesOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedDbInstancesOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        Function<DescribeReservedDbInstancesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstancesOfferings() != null) {
                return response.reservedDBInstancesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedDbInstancesOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReservedDbInstancesOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedDbInstancesOfferingsResponse> {
        private DescribeReservedDbInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDbInstancesOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReservedDbInstancesOfferingsResponse> nextPage(DescribeReservedDbInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesOfferingsPublisher.this.client.describeReservedDBInstancesOfferings(DescribeReservedDBInstancesOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedDBInstancesOfferingsPublisher.this.client.describeReservedDBInstancesOfferings((DescribeReservedDbInstancesOfferingsRequest)((Object)DescribeReservedDBInstancesOfferingsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

