/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.CharacterSet;
import software.amazon.awssdk.services.rds.model.EngineModeListCopier;
import software.amazon.awssdk.services.rds.model.FeatureNameListCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.SupportedCharacterSetsListCopier;
import software.amazon.awssdk.services.rds.model.SupportedTimezonesListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.Timezone;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;
import software.amazon.awssdk.services.rds.model.ValidUpgradeTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBEngineVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBEngineVersion> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBEngineVersion.getter(DBEngineVersion::engine)).setter(DBEngineVersion.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBEngineVersion.getter(DBEngineVersion::engineVersion)).setter(DBEngineVersion.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupFamily").getter(DBEngineVersion.getter(DBEngineVersion::dbParameterGroupFamily)).setter(DBEngineVersion.setter(Builder::dbParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build()}).build();
    private static final SdkField<String> DB_ENGINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineDescription)).setter(DBEngineVersion.setter(Builder::dbEngineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineDescription").build()}).build();
    private static final SdkField<String> DB_ENGINE_VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineVersionDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineVersionDescription)).setter(DBEngineVersion.setter(Builder::dbEngineVersionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionDescription").build()}).build();
    private static final SdkField<CharacterSet> DEFAULT_CHARACTER_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultCharacterSet").getter(DBEngineVersion.getter(DBEngineVersion::defaultCharacterSet)).setter(DBEngineVersion.setter(Builder::defaultCharacterSet)).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCharacterSet").build()}).build();
    private static final SdkField<List<CharacterSet>> SUPPORTED_CHARACTER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedCharacterSets").getter(DBEngineVersion.getter(DBEngineVersion::supportedCharacterSets)).setter(DBEngineVersion.setter(Builder::supportedCharacterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedCharacterSets").build(), ListTrait.builder().memberLocationName("CharacterSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSet").build()}).build()).build()}).build();
    private static final SdkField<List<CharacterSet>> SUPPORTED_NCHAR_CHARACTER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNcharCharacterSets").getter(DBEngineVersion.getter(DBEngineVersion::supportedNcharCharacterSets)).setter(DBEngineVersion.setter(Builder::supportedNcharCharacterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNcharCharacterSets").build(), ListTrait.builder().memberLocationName("CharacterSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSet").build()}).build()).build()}).build();
    private static final SdkField<List<UpgradeTarget>> VALID_UPGRADE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidUpgradeTarget").getter(DBEngineVersion.getter(DBEngineVersion::validUpgradeTarget)).setter(DBEngineVersion.setter(Builder::validUpgradeTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUpgradeTarget").build(), ListTrait.builder().memberLocationName("UpgradeTarget").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpgradeTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeTarget").build()}).build()).build()}).build();
    private static final SdkField<List<Timezone>> SUPPORTED_TIMEZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTimezones").getter(DBEngineVersion.getter(DBEngineVersion::supportedTimezones)).setter(DBEngineVersion.setter(Builder::supportedTimezones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTimezones").build(), ListTrait.builder().memberLocationName("Timezone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Timezone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPORTABLE_LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportableLogTypes").getter(DBEngineVersion.getter(DBEngineVersion::exportableLogTypes)).setter(DBEngineVersion.setter(Builder::exportableLogTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableLogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLogExportsToCloudwatchLogs").getter(DBEngineVersion.getter(DBEngineVersion::supportsLogExportsToCloudwatchLogs)).setter(DBEngineVersion.setter(Builder::supportsLogExportsToCloudwatchLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLogExportsToCloudwatchLogs").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_READ_REPLICA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsReadReplica").getter(DBEngineVersion.getter(DBEngineVersion::supportsReadReplica)).setter(DBEngineVersion.setter(Builder::supportsReadReplica)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsReadReplica").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEngineModes").getter(DBEngineVersion.getter(DBEngineVersion::supportedEngineModes)).setter(DBEngineVersion.setter(Builder::supportedEngineModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_FEATURE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedFeatureNames").getter(DBEngineVersion.getter(DBEngineVersion::supportedFeatureNames)).setter(DBEngineVersion.setter(Builder::supportedFeatureNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFeatureNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBEngineVersion.getter(DBEngineVersion::status)).setter(DBEngineVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_PARALLEL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsParallelQuery").getter(DBEngineVersion.getter(DBEngineVersion::supportsParallelQuery)).setter(DBEngineVersion.setter(Builder::supportsParallelQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsParallelQuery").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_GLOBAL_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsGlobalDatabases").getter(DBEngineVersion.getter(DBEngineVersion::supportsGlobalDatabases)).setter(DBEngineVersion.setter(Builder::supportsGlobalDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsGlobalDatabases").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorEngineVersion").getter(DBEngineVersion.getter(DBEngineVersion::majorEngineVersion)).setter(DBEngineVersion.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInstallationFilesS3BucketName").getter(DBEngineVersion.getter(DBEngineVersion::databaseInstallationFilesS3BucketName)).setter(DBEngineVersion.setter(Builder::databaseInstallationFilesS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3BucketName").build()}).build();
    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInstallationFilesS3Prefix").getter(DBEngineVersion.getter(DBEngineVersion::databaseInstallationFilesS3Prefix)).setter(DBEngineVersion.setter(Builder::databaseInstallationFilesS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3Prefix").build()}).build();
    private static final SdkField<String> DB_ENGINE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineVersionArn").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineVersionArn)).setter(DBEngineVersion.setter(Builder::dbEngineVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(DBEngineVersion.getter(DBEngineVersion::kmsKeyId)).setter(DBEngineVersion.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DBEngineVersion.getter(DBEngineVersion::createTime)).setter(DBEngineVersion.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(DBEngineVersion.getter(DBEngineVersion::tagList)).setter(DBEngineVersion.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_BABELFISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsBabelfish").getter(DBEngineVersion.getter(DBEngineVersion::supportsBabelfish)).setter(DBEngineVersion.setter(Builder::supportsBabelfish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsBabelfish").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DB_ENGINE_DESCRIPTION_FIELD, DB_ENGINE_VERSION_DESCRIPTION_FIELD, DEFAULT_CHARACTER_SET_FIELD, SUPPORTED_CHARACTER_SETS_FIELD, SUPPORTED_NCHAR_CHARACTER_SETS_FIELD, VALID_UPGRADE_TARGET_FIELD, SUPPORTED_TIMEZONES_FIELD, EXPORTABLE_LOG_TYPES_FIELD, SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD, SUPPORTS_READ_REPLICA_FIELD, SUPPORTED_ENGINE_MODES_FIELD, SUPPORTED_FEATURE_NAMES_FIELD, STATUS_FIELD, SUPPORTS_PARALLEL_QUERY_FIELD, SUPPORTS_GLOBAL_DATABASES_FIELD, MAJOR_ENGINE_VERSION_FIELD, DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD, DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD, DB_ENGINE_VERSION_ARN_FIELD, KMS_KEY_ID_FIELD, CREATE_TIME_FIELD, TAG_LIST_FIELD, SUPPORTS_BABELFISH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final String dbEngineDescription;
    private final String dbEngineVersionDescription;
    private final CharacterSet defaultCharacterSet;
    private final List<CharacterSet> supportedCharacterSets;
    private final List<CharacterSet> supportedNcharCharacterSets;
    private final List<UpgradeTarget> validUpgradeTarget;
    private final List<Timezone> supportedTimezones;
    private final List<String> exportableLogTypes;
    private final Boolean supportsLogExportsToCloudwatchLogs;
    private final Boolean supportsReadReplica;
    private final List<String> supportedEngineModes;
    private final List<String> supportedFeatureNames;
    private final String status;
    private final Boolean supportsParallelQuery;
    private final Boolean supportsGlobalDatabases;
    private final String majorEngineVersion;
    private final String databaseInstallationFilesS3BucketName;
    private final String databaseInstallationFilesS3Prefix;
    private final String dbEngineVersionArn;
    private final String kmsKeyId;
    private final Instant createTime;
    private final List<Tag> tagList;
    private final Boolean supportsBabelfish;

    private DBEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.defaultCharacterSet = builder.defaultCharacterSet;
        this.supportedCharacterSets = builder.supportedCharacterSets;
        this.supportedNcharCharacterSets = builder.supportedNcharCharacterSets;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.supportedTimezones = builder.supportedTimezones;
        this.exportableLogTypes = builder.exportableLogTypes;
        this.supportsLogExportsToCloudwatchLogs = builder.supportsLogExportsToCloudwatchLogs;
        this.supportsReadReplica = builder.supportsReadReplica;
        this.supportedEngineModes = builder.supportedEngineModes;
        this.supportedFeatureNames = builder.supportedFeatureNames;
        this.status = builder.status;
        this.supportsParallelQuery = builder.supportsParallelQuery;
        this.supportsGlobalDatabases = builder.supportsGlobalDatabases;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.databaseInstallationFilesS3BucketName = builder.databaseInstallationFilesS3BucketName;
        this.databaseInstallationFilesS3Prefix = builder.databaseInstallationFilesS3Prefix;
        this.dbEngineVersionArn = builder.dbEngineVersionArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.createTime = builder.createTime;
        this.tagList = builder.tagList;
        this.supportsBabelfish = builder.supportsBabelfish;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public final String dbEngineDescription() {
        return this.dbEngineDescription;
    }

    public final String dbEngineVersionDescription() {
        return this.dbEngineVersionDescription;
    }

    public final CharacterSet defaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public final boolean hasSupportedCharacterSets() {
        return this.supportedCharacterSets != null && !(this.supportedCharacterSets instanceof SdkAutoConstructList);
    }

    public final List<CharacterSet> supportedCharacterSets() {
        return this.supportedCharacterSets;
    }

    public final boolean hasSupportedNcharCharacterSets() {
        return this.supportedNcharCharacterSets != null && !(this.supportedNcharCharacterSets instanceof SdkAutoConstructList);
    }

    public final List<CharacterSet> supportedNcharCharacterSets() {
        return this.supportedNcharCharacterSets;
    }

    public final boolean hasValidUpgradeTarget() {
        return this.validUpgradeTarget != null && !(this.validUpgradeTarget instanceof SdkAutoConstructList);
    }

    public final List<UpgradeTarget> validUpgradeTarget() {
        return this.validUpgradeTarget;
    }

    public final boolean hasSupportedTimezones() {
        return this.supportedTimezones != null && !(this.supportedTimezones instanceof SdkAutoConstructList);
    }

    public final List<Timezone> supportedTimezones() {
        return this.supportedTimezones;
    }

    public final boolean hasExportableLogTypes() {
        return this.exportableLogTypes != null && !(this.exportableLogTypes instanceof SdkAutoConstructList);
    }

    public final List<String> exportableLogTypes() {
        return this.exportableLogTypes;
    }

    public final Boolean supportsLogExportsToCloudwatchLogs() {
        return this.supportsLogExportsToCloudwatchLogs;
    }

    public final Boolean supportsReadReplica() {
        return this.supportsReadReplica;
    }

    public final boolean hasSupportedEngineModes() {
        return this.supportedEngineModes != null && !(this.supportedEngineModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedEngineModes() {
        return this.supportedEngineModes;
    }

    public final boolean hasSupportedFeatureNames() {
        return this.supportedFeatureNames != null && !(this.supportedFeatureNames instanceof SdkAutoConstructList);
    }

    public final List<String> supportedFeatureNames() {
        return this.supportedFeatureNames;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean supportsParallelQuery() {
        return this.supportsParallelQuery;
    }

    public final Boolean supportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public final String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public final String databaseInstallationFilesS3BucketName() {
        return this.databaseInstallationFilesS3BucketName;
    }

    public final String databaseInstallationFilesS3Prefix() {
        return this.databaseInstallationFilesS3Prefix;
    }

    public final String dbEngineVersionArn() {
        return this.dbEngineVersionArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final Boolean supportsBabelfish() {
        return this.supportsBabelfish;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCharacterSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedCharacterSets() ? this.supportedCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNcharCharacterSets() ? this.supportedNcharCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTimezones() ? this.supportedTimezones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportableLogTypes() ? this.exportableLogTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLogExportsToCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsReadReplica());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEngineModes() ? this.supportedEngineModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedFeatureNames() ? this.supportedFeatureNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsParallelQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsGlobalDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInstallationFilesS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInstallationFilesS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsBabelfish());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.dbEngineDescription(), other.dbEngineDescription()) && Objects.equals(this.dbEngineVersionDescription(), other.dbEngineVersionDescription()) && Objects.equals(this.defaultCharacterSet(), other.defaultCharacterSet()) && this.hasSupportedCharacterSets() == other.hasSupportedCharacterSets() && Objects.equals(this.supportedCharacterSets(), other.supportedCharacterSets()) && this.hasSupportedNcharCharacterSets() == other.hasSupportedNcharCharacterSets() && Objects.equals(this.supportedNcharCharacterSets(), other.supportedNcharCharacterSets()) && this.hasValidUpgradeTarget() == other.hasValidUpgradeTarget() && Objects.equals(this.validUpgradeTarget(), other.validUpgradeTarget()) && this.hasSupportedTimezones() == other.hasSupportedTimezones() && Objects.equals(this.supportedTimezones(), other.supportedTimezones()) && this.hasExportableLogTypes() == other.hasExportableLogTypes() && Objects.equals(this.exportableLogTypes(), other.exportableLogTypes()) && Objects.equals(this.supportsLogExportsToCloudwatchLogs(), other.supportsLogExportsToCloudwatchLogs()) && Objects.equals(this.supportsReadReplica(), other.supportsReadReplica()) && this.hasSupportedEngineModes() == other.hasSupportedEngineModes() && Objects.equals(this.supportedEngineModes(), other.supportedEngineModes()) && this.hasSupportedFeatureNames() == other.hasSupportedFeatureNames() && Objects.equals(this.supportedFeatureNames(), other.supportedFeatureNames()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.supportsParallelQuery(), other.supportsParallelQuery()) && Objects.equals(this.supportsGlobalDatabases(), other.supportsGlobalDatabases()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && Objects.equals(this.databaseInstallationFilesS3BucketName(), other.databaseInstallationFilesS3BucketName()) && Objects.equals(this.databaseInstallationFilesS3Prefix(), other.databaseInstallationFilesS3Prefix()) && Objects.equals(this.dbEngineVersionArn(), other.dbEngineVersionArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.createTime(), other.createTime()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.supportsBabelfish(), other.supportsBabelfish());
    }

    public final String toString() {
        return ToString.builder((String)"DBEngineVersion").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("DBEngineDescription", (Object)this.dbEngineDescription()).add("DBEngineVersionDescription", (Object)this.dbEngineVersionDescription()).add("DefaultCharacterSet", (Object)this.defaultCharacterSet()).add("SupportedCharacterSets", this.hasSupportedCharacterSets() ? this.supportedCharacterSets() : null).add("SupportedNcharCharacterSets", this.hasSupportedNcharCharacterSets() ? this.supportedNcharCharacterSets() : null).add("ValidUpgradeTarget", this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null).add("SupportedTimezones", this.hasSupportedTimezones() ? this.supportedTimezones() : null).add("ExportableLogTypes", this.hasExportableLogTypes() ? this.exportableLogTypes() : null).add("SupportsLogExportsToCloudwatchLogs", (Object)this.supportsLogExportsToCloudwatchLogs()).add("SupportsReadReplica", (Object)this.supportsReadReplica()).add("SupportedEngineModes", this.hasSupportedEngineModes() ? this.supportedEngineModes() : null).add("SupportedFeatureNames", this.hasSupportedFeatureNames() ? this.supportedFeatureNames() : null).add("Status", (Object)this.status()).add("SupportsParallelQuery", (Object)this.supportsParallelQuery()).add("SupportsGlobalDatabases", (Object)this.supportsGlobalDatabases()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).add("DatabaseInstallationFilesS3BucketName", (Object)this.databaseInstallationFilesS3BucketName()).add("DatabaseInstallationFilesS3Prefix", (Object)this.databaseInstallationFilesS3Prefix()).add("DBEngineVersionArn", (Object)this.dbEngineVersionArn()).add("KMSKeyId", (Object)this.kmsKeyId()).add("CreateTime", (Object)this.createTime()).add("TagList", this.hasTagList() ? this.tagList() : null).add("SupportsBabelfish", (Object)this.supportsBabelfish()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DBParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "DBEngineDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineDescription()));
            }
            case "DBEngineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersionDescription()));
            }
            case "DefaultCharacterSet": {
                return Optional.ofNullable(clazz.cast(this.defaultCharacterSet()));
            }
            case "SupportedCharacterSets": {
                return Optional.ofNullable(clazz.cast(this.supportedCharacterSets()));
            }
            case "SupportedNcharCharacterSets": {
                return Optional.ofNullable(clazz.cast(this.supportedNcharCharacterSets()));
            }
            case "ValidUpgradeTarget": {
                return Optional.ofNullable(clazz.cast(this.validUpgradeTarget()));
            }
            case "SupportedTimezones": {
                return Optional.ofNullable(clazz.cast(this.supportedTimezones()));
            }
            case "ExportableLogTypes": {
                return Optional.ofNullable(clazz.cast(this.exportableLogTypes()));
            }
            case "SupportsLogExportsToCloudwatchLogs": {
                return Optional.ofNullable(clazz.cast(this.supportsLogExportsToCloudwatchLogs()));
            }
            case "SupportsReadReplica": {
                return Optional.ofNullable(clazz.cast(this.supportsReadReplica()));
            }
            case "SupportedEngineModes": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineModes()));
            }
            case "SupportedFeatureNames": {
                return Optional.ofNullable(clazz.cast(this.supportedFeatureNames()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SupportsParallelQuery": {
                return Optional.ofNullable(clazz.cast(this.supportsParallelQuery()));
            }
            case "SupportsGlobalDatabases": {
                return Optional.ofNullable(clazz.cast(this.supportsGlobalDatabases()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
            case "DatabaseInstallationFilesS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.databaseInstallationFilesS3BucketName()));
            }
            case "DatabaseInstallationFilesS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.databaseInstallationFilesS3Prefix()));
            }
            case "DBEngineVersionArn": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersionArn()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "SupportsBabelfish": {
                return Optional.ofNullable(clazz.cast(this.supportsBabelfish()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBEngineVersion, T> g) {
        return obj -> g.apply((DBEngineVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private String dbEngineDescription;
        private String dbEngineVersionDescription;
        private CharacterSet defaultCharacterSet;
        private List<CharacterSet> supportedCharacterSets = DefaultSdkAutoConstructList.getInstance();
        private List<CharacterSet> supportedNcharCharacterSets = DefaultSdkAutoConstructList.getInstance();
        private List<UpgradeTarget> validUpgradeTarget = DefaultSdkAutoConstructList.getInstance();
        private List<Timezone> supportedTimezones = DefaultSdkAutoConstructList.getInstance();
        private List<String> exportableLogTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsLogExportsToCloudwatchLogs;
        private Boolean supportsReadReplica;
        private List<String> supportedEngineModes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedFeatureNames = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Boolean supportsParallelQuery;
        private Boolean supportsGlobalDatabases;
        private String majorEngineVersion;
        private String databaseInstallationFilesS3BucketName;
        private String databaseInstallationFilesS3Prefix;
        private String dbEngineVersionArn;
        private String kmsKeyId;
        private Instant createTime;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsBabelfish;

        private BuilderImpl() {
        }

        private BuilderImpl(DBEngineVersion model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.dbEngineDescription(model.dbEngineDescription);
            this.dbEngineVersionDescription(model.dbEngineVersionDescription);
            this.defaultCharacterSet(model.defaultCharacterSet);
            this.supportedCharacterSets(model.supportedCharacterSets);
            this.supportedNcharCharacterSets(model.supportedNcharCharacterSets);
            this.validUpgradeTarget(model.validUpgradeTarget);
            this.supportedTimezones(model.supportedTimezones);
            this.exportableLogTypes(model.exportableLogTypes);
            this.supportsLogExportsToCloudwatchLogs(model.supportsLogExportsToCloudwatchLogs);
            this.supportsReadReplica(model.supportsReadReplica);
            this.supportedEngineModes(model.supportedEngineModes);
            this.supportedFeatureNames(model.supportedFeatureNames);
            this.status(model.status);
            this.supportsParallelQuery(model.supportsParallelQuery);
            this.supportsGlobalDatabases(model.supportsGlobalDatabases);
            this.majorEngineVersion(model.majorEngineVersion);
            this.databaseInstallationFilesS3BucketName(model.databaseInstallationFilesS3BucketName);
            this.databaseInstallationFilesS3Prefix(model.databaseInstallationFilesS3Prefix);
            this.dbEngineVersionArn(model.dbEngineVersionArn);
            this.kmsKeyId(model.kmsKeyId);
            this.createTime(model.createTime);
            this.tagList(model.tagList);
            this.supportsBabelfish(model.supportsBabelfish);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        @Override
        @Transient
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final String getDbEngineDescription() {
            return this.dbEngineDescription;
        }

        public final void setDbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        @Override
        @Transient
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final String getDbEngineVersionDescription() {
            return this.dbEngineVersionDescription;
        }

        public final void setDbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        @Override
        @Transient
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final CharacterSet.Builder getDefaultCharacterSet() {
            return this.defaultCharacterSet != null ? this.defaultCharacterSet.toBuilder() : null;
        }

        public final void setDefaultCharacterSet(CharacterSet.BuilderImpl defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet != null ? defaultCharacterSet.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultCharacterSet(CharacterSet defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet;
            return this;
        }

        public final List<CharacterSet.Builder> getSupportedCharacterSets() {
            List<CharacterSet.Builder> result = SupportedCharacterSetsListCopier.copyToBuilder(this.supportedCharacterSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedCharacterSets(Collection<CharacterSet.BuilderImpl> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedCharacterSets);
        }

        @Override
        @Transient
        public final Builder supportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copy(supportedCharacterSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedCharacterSets(CharacterSet ... supportedCharacterSets) {
            this.supportedCharacterSets(Arrays.asList(supportedCharacterSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... supportedCharacterSets) {
            this.supportedCharacterSets(Stream.of(supportedCharacterSets).map(c -> (CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CharacterSet.Builder> getSupportedNcharCharacterSets() {
            List<CharacterSet.Builder> result = SupportedCharacterSetsListCopier.copyToBuilder(this.supportedNcharCharacterSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedNcharCharacterSets(Collection<CharacterSet.BuilderImpl> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedNcharCharacterSets);
        }

        @Override
        @Transient
        public final Builder supportedNcharCharacterSets(Collection<CharacterSet> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copy(supportedNcharCharacterSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(CharacterSet ... supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets(Arrays.asList(supportedNcharCharacterSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder> ... supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets(Stream.of(supportedNcharCharacterSets).map(c -> (CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UpgradeTarget.Builder> getValidUpgradeTarget() {
            List<UpgradeTarget.Builder> result = ValidUpgradeTargetListCopier.copyToBuilder(this.validUpgradeTarget);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        @Override
        @Transient
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
            this.validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... validUpgradeTarget) {
            this.validUpgradeTarget(Stream.of(validUpgradeTarget).map(c -> (UpgradeTarget)((UpgradeTarget.Builder)UpgradeTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Timezone.Builder> getSupportedTimezones() {
            List<Timezone.Builder> result = SupportedTimezonesListCopier.copyToBuilder(this.supportedTimezones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedTimezones(Collection<Timezone.BuilderImpl> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copyFromBuilder(supportedTimezones);
        }

        @Override
        @Transient
        public final Builder supportedTimezones(Collection<Timezone> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copy(supportedTimezones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedTimezones(Timezone ... supportedTimezones) {
            this.supportedTimezones(Arrays.asList(supportedTimezones));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedTimezones(Consumer<Timezone.Builder> ... supportedTimezones) {
            this.supportedTimezones(Stream.of(supportedTimezones).map(c -> (Timezone)((Timezone.Builder)Timezone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getExportableLogTypes() {
            if (this.exportableLogTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportableLogTypes;
        }

        public final void setExportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
        }

        @Override
        @Transient
        public final Builder exportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exportableLogTypes(String ... exportableLogTypes) {
            this.exportableLogTypes(Arrays.asList(exportableLogTypes));
            return this;
        }

        public final Boolean getSupportsLogExportsToCloudwatchLogs() {
            return this.supportsLogExportsToCloudwatchLogs;
        }

        public final void setSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
        }

        @Override
        @Transient
        public final Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
            return this;
        }

        public final Boolean getSupportsReadReplica() {
            return this.supportsReadReplica;
        }

        public final void setSupportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
        }

        @Override
        @Transient
        public final Builder supportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
            return this;
        }

        public final Collection<String> getSupportedEngineModes() {
            if (this.supportedEngineModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedEngineModes;
        }

        public final void setSupportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
        }

        @Override
        @Transient
        public final Builder supportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedEngineModes(String ... supportedEngineModes) {
            this.supportedEngineModes(Arrays.asList(supportedEngineModes));
            return this;
        }

        public final Collection<String> getSupportedFeatureNames() {
            if (this.supportedFeatureNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedFeatureNames;
        }

        public final void setSupportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
        }

        @Override
        @Transient
        public final Builder supportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedFeatureNames(String ... supportedFeatureNames) {
            this.supportedFeatureNames(Arrays.asList(supportedFeatureNames));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getSupportsParallelQuery() {
            return this.supportsParallelQuery;
        }

        public final void setSupportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
        }

        @Override
        @Transient
        public final Builder supportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
            return this;
        }

        public final Boolean getSupportsGlobalDatabases() {
            return this.supportsGlobalDatabases;
        }

        public final void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
        }

        @Override
        @Transient
        public final Builder supportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
            return this;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        @Transient
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final String getDatabaseInstallationFilesS3BucketName() {
            return this.databaseInstallationFilesS3BucketName;
        }

        public final void setDatabaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
        }

        @Override
        @Transient
        public final Builder databaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
            return this;
        }

        public final String getDatabaseInstallationFilesS3Prefix() {
            return this.databaseInstallationFilesS3Prefix;
        }

        public final void setDatabaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
        }

        @Override
        @Transient
        public final Builder databaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
            return this;
        }

        public final String getDbEngineVersionArn() {
            return this.dbEngineVersionArn;
        }

        public final void setDbEngineVersionArn(String dbEngineVersionArn) {
            this.dbEngineVersionArn = dbEngineVersionArn;
        }

        @Override
        @Transient
        public final Builder dbEngineVersionArn(String dbEngineVersionArn) {
            this.dbEngineVersionArn = dbEngineVersionArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        @Transient
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSupportsBabelfish() {
            return this.supportsBabelfish;
        }

        public final void setSupportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
        }

        @Override
        @Transient
        public final Builder supportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
            return this;
        }

        public DBEngineVersion build() {
            return new DBEngineVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBEngineVersion> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder dbEngineDescription(String var1);

        public Builder dbEngineVersionDescription(String var1);

        public Builder defaultCharacterSet(CharacterSet var1);

        default public Builder defaultCharacterSet(Consumer<CharacterSet.Builder> defaultCharacterSet) {
            return this.defaultCharacterSet((CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation(defaultCharacterSet)).build());
        }

        public Builder supportedCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedCharacterSets(CharacterSet ... var1);

        public Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... var1);

        public Builder supportedNcharCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedNcharCharacterSets(CharacterSet ... var1);

        public Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder> ... var1);

        public Builder validUpgradeTarget(Collection<UpgradeTarget> var1);

        public Builder validUpgradeTarget(UpgradeTarget ... var1);

        public Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... var1);

        public Builder supportedTimezones(Collection<Timezone> var1);

        public Builder supportedTimezones(Timezone ... var1);

        public Builder supportedTimezones(Consumer<Timezone.Builder> ... var1);

        public Builder exportableLogTypes(Collection<String> var1);

        public Builder exportableLogTypes(String ... var1);

        public Builder supportsLogExportsToCloudwatchLogs(Boolean var1);

        public Builder supportsReadReplica(Boolean var1);

        public Builder supportedEngineModes(Collection<String> var1);

        public Builder supportedEngineModes(String ... var1);

        public Builder supportedFeatureNames(Collection<String> var1);

        public Builder supportedFeatureNames(String ... var1);

        public Builder status(String var1);

        public Builder supportsParallelQuery(Boolean var1);

        public Builder supportsGlobalDatabases(Boolean var1);

        public Builder majorEngineVersion(String var1);

        public Builder databaseInstallationFilesS3BucketName(String var1);

        public Builder databaseInstallationFilesS3Prefix(String var1);

        public Builder dbEngineVersionArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder createTime(Instant var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder supportsBabelfish(Boolean var1);
    }
}

