/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxyTargetGroup;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.TargetGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbProxyTargetGroupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbProxyTargetGroupsResponse> {
    private static final SdkField<List<DBProxyTargetGroup>> TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetGroups").getter(DescribeDbProxyTargetGroupsResponse.getter(DescribeDbProxyTargetGroupsResponse::targetGroups)).setter(DescribeDbProxyTargetGroupsResponse.setter(Builder::targetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBProxyTargetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbProxyTargetGroupsResponse.getter(DescribeDbProxyTargetGroupsResponse::marker)).setter(DescribeDbProxyTargetGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD, MARKER_FIELD));
    private final List<DBProxyTargetGroup> targetGroups;
    private final String marker;

    private DescribeDbProxyTargetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.targetGroups = builder.targetGroups;
        this.marker = builder.marker;
    }

    public final boolean hasTargetGroups() {
        return this.targetGroups != null && !(this.targetGroups instanceof SdkAutoConstructList);
    }

    public final List<DBProxyTargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroups() ? this.targetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbProxyTargetGroupsResponse)) {
            return false;
        }
        DescribeDbProxyTargetGroupsResponse other = (DescribeDbProxyTargetGroupsResponse)((Object)obj);
        return this.hasTargetGroups() == other.hasTargetGroups() && Objects.equals(this.targetGroups(), other.targetGroups()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbProxyTargetGroupsResponse").add("TargetGroups", this.hasTargetGroups() ? this.targetGroups() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroups": {
                return Optional.ofNullable(clazz.cast(this.targetGroups()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbProxyTargetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbProxyTargetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBProxyTargetGroup> targetGroups = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbProxyTargetGroupsResponse model) {
            super(model);
            this.targetGroups(model.targetGroups);
            this.marker(model.marker);
        }

        public final List<DBProxyTargetGroup.Builder> getTargetGroups() {
            List<DBProxyTargetGroup.Builder> result = TargetGroupListCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<DBProxyTargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupListCopier.copyFromBuilder(targetGroups);
        }

        @Override
        @Transient
        public final Builder targetGroups(Collection<DBProxyTargetGroup> targetGroups) {
            this.targetGroups = TargetGroupListCopier.copy(targetGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetGroups(DBProxyTargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetGroups(Consumer<DBProxyTargetGroup.Builder> ... targetGroups) {
            this.targetGroups(Stream.of(targetGroups).map(c -> (DBProxyTargetGroup)((DBProxyTargetGroup.Builder)DBProxyTargetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbProxyTargetGroupsResponse build() {
            return new DescribeDbProxyTargetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbProxyTargetGroupsResponse> {
        public Builder targetGroups(Collection<DBProxyTargetGroup> var1);

        public Builder targetGroups(DBProxyTargetGroup ... var1);

        public Builder targetGroups(Consumer<DBProxyTargetGroup.Builder> ... var1);

        public Builder marker(String var1);
    }
}

