/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbLogFilesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbLogFilesResponse> {
    private static final SdkField<List<DescribeDBLogFilesDetails>> DESCRIBE_DB_LOG_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DescribeDBLogFiles").getter(DescribeDbLogFilesResponse.getter(DescribeDbLogFilesResponse::describeDBLogFiles)).setter(DescribeDbLogFilesResponse.setter(Builder::describeDBLogFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescribeDBLogFiles").build(), ListTrait.builder().memberLocationName("DescribeDBLogFilesDetails").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeDBLogFilesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescribeDBLogFilesDetails").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbLogFilesResponse.getter(DescribeDbLogFilesResponse::marker)).setter(DescribeDbLogFilesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIBE_DB_LOG_FILES_FIELD, MARKER_FIELD));
    private final List<DescribeDBLogFilesDetails> describeDBLogFiles;
    private final String marker;

    private DescribeDbLogFilesResponse(BuilderImpl builder) {
        super(builder);
        this.describeDBLogFiles = builder.describeDBLogFiles;
        this.marker = builder.marker;
    }

    public final boolean hasDescribeDBLogFiles() {
        return this.describeDBLogFiles != null && !(this.describeDBLogFiles instanceof SdkAutoConstructList);
    }

    public final List<DescribeDBLogFilesDetails> describeDBLogFiles() {
        return this.describeDBLogFiles;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDescribeDBLogFiles() ? this.describeDBLogFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbLogFilesResponse)) {
            return false;
        }
        DescribeDbLogFilesResponse other = (DescribeDbLogFilesResponse)((Object)obj);
        return this.hasDescribeDBLogFiles() == other.hasDescribeDBLogFiles() && Objects.equals(this.describeDBLogFiles(), other.describeDBLogFiles()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbLogFilesResponse").add("DescribeDBLogFiles", this.hasDescribeDBLogFiles() ? this.describeDBLogFiles() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DescribeDBLogFiles": {
                return Optional.ofNullable(clazz.cast(this.describeDBLogFiles()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbLogFilesResponse, T> g) {
        return obj -> g.apply((DescribeDbLogFilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DescribeDBLogFilesDetails> describeDBLogFiles = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbLogFilesResponse model) {
            super(model);
            this.describeDBLogFiles(model.describeDBLogFiles);
            this.marker(model.marker);
        }

        public final List<DescribeDBLogFilesDetails.Builder> getDescribeDBLogFiles() {
            List<DescribeDBLogFilesDetails.Builder> result = DescribeDBLogFilesListCopier.copyToBuilder(this.describeDBLogFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDescribeDBLogFiles(Collection<DescribeDBLogFilesDetails.BuilderImpl> describeDBLogFiles) {
            this.describeDBLogFiles = DescribeDBLogFilesListCopier.copyFromBuilder(describeDBLogFiles);
        }

        @Override
        @Transient
        public final Builder describeDBLogFiles(Collection<DescribeDBLogFilesDetails> describeDBLogFiles) {
            this.describeDBLogFiles = DescribeDBLogFilesListCopier.copy(describeDBLogFiles);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder describeDBLogFiles(DescribeDBLogFilesDetails ... describeDBLogFiles) {
            this.describeDBLogFiles(Arrays.asList(describeDBLogFiles));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder describeDBLogFiles(Consumer<DescribeDBLogFilesDetails.Builder> ... describeDBLogFiles) {
            this.describeDBLogFiles(Stream.of(describeDBLogFiles).map(c -> (DescribeDBLogFilesDetails)((DescribeDBLogFilesDetails.Builder)DescribeDBLogFilesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbLogFilesResponse build() {
            return new DescribeDbLogFilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbLogFilesResponse> {
        public Builder describeDBLogFiles(Collection<DescribeDBLogFilesDetails> var1);

        public Builder describeDBLogFiles(DescribeDBLogFilesDetails ... var1);

        public Builder describeDBLogFiles(Consumer<DescribeDBLogFilesDetails.Builder> ... var1);

        public Builder marker(String var1);
    }
}

