/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.model.OptionSettingConfigurationListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Option
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Option> {
    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionName").getter(Option.getter(Option::optionName)).setter(Option.setter(Builder::optionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()}).build();
    private static final SdkField<String> OPTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionDescription").getter(Option.getter(Option::optionDescription)).setter(Option.setter(Builder::optionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionDescription").build()}).build();
    private static final SdkField<Boolean> PERSISTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Persistent").getter(Option.getter(Option::persistent)).setter(Option.setter(Builder::persistent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persistent").build()}).build();
    private static final SdkField<Boolean> PERMANENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Permanent").getter(Option.getter(Option::permanent)).setter(Option.setter(Builder::permanent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permanent").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(Option.getter(Option::port)).setter(Option.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> OPTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionVersion").getter(Option.getter(Option::optionVersion)).setter(Option.setter(Builder::optionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionVersion").build()}).build();
    private static final SdkField<List<OptionSetting>> OPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionSettings").getter(Option.getter(Option::optionSettings)).setter(Option.setter(Builder::optionSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(), ListTrait.builder().memberLocationName("OptionSetting").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSetting").build()}).build()).build()}).build();
    private static final SdkField<List<DBSecurityGroupMembership>> DB_SECURITY_GROUP_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBSecurityGroupMemberships").getter(Option.getter(Option::dbSecurityGroupMemberships)).setter(Option.setter(Builder::dbSecurityGroupMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupMemberships").build(), ListTrait.builder().memberLocationName("DBSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUP_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupMemberships").getter(Option.getter(Option::vpcSecurityGroupMemberships)).setter(Option.setter(Builder::vpcSecurityGroupMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMemberships").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMembership").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_NAME_FIELD, OPTION_DESCRIPTION_FIELD, PERSISTENT_FIELD, PERMANENT_FIELD, PORT_FIELD, OPTION_VERSION_FIELD, OPTION_SETTINGS_FIELD, DB_SECURITY_GROUP_MEMBERSHIPS_FIELD, VPC_SECURITY_GROUP_MEMBERSHIPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String optionName;
    private final String optionDescription;
    private final Boolean persistent;
    private final Boolean permanent;
    private final Integer port;
    private final String optionVersion;
    private final List<OptionSetting> optionSettings;
    private final List<DBSecurityGroupMembership> dbSecurityGroupMemberships;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships;

    private Option(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.optionDescription = builder.optionDescription;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.port = builder.port;
        this.optionVersion = builder.optionVersion;
        this.optionSettings = builder.optionSettings;
        this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
        this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
    }

    public final String optionName() {
        return this.optionName;
    }

    public final String optionDescription() {
        return this.optionDescription;
    }

    public final Boolean persistent() {
        return this.persistent;
    }

    public final Boolean permanent() {
        return this.permanent;
    }

    public final Integer port() {
        return this.port;
    }

    public final String optionVersion() {
        return this.optionVersion;
    }

    public final boolean hasOptionSettings() {
        return this.optionSettings != null && !(this.optionSettings instanceof SdkAutoConstructList);
    }

    public final List<OptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public final boolean hasDbSecurityGroupMemberships() {
        return this.dbSecurityGroupMemberships != null && !(this.dbSecurityGroupMemberships instanceof SdkAutoConstructList);
    }

    public final List<DBSecurityGroupMembership> dbSecurityGroupMemberships() {
        return this.dbSecurityGroupMemberships;
    }

    public final boolean hasVpcSecurityGroupMemberships() {
        return this.vpcSecurityGroupMemberships != null && !(this.vpcSecurityGroupMemberships instanceof SdkAutoConstructList);
    }

    public final List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships() {
        return this.vpcSecurityGroupMemberships;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistent());
        hashCode = 31 * hashCode + Objects.hashCode(this.permanent());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionSettings() ? this.optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbSecurityGroupMemberships() ? this.dbSecurityGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupMemberships() ? this.vpcSecurityGroupMemberships() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        return Objects.equals(this.optionName(), other.optionName()) && Objects.equals(this.optionDescription(), other.optionDescription()) && Objects.equals(this.persistent(), other.persistent()) && Objects.equals(this.permanent(), other.permanent()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.optionVersion(), other.optionVersion()) && this.hasOptionSettings() == other.hasOptionSettings() && Objects.equals(this.optionSettings(), other.optionSettings()) && this.hasDbSecurityGroupMemberships() == other.hasDbSecurityGroupMemberships() && Objects.equals(this.dbSecurityGroupMemberships(), other.dbSecurityGroupMemberships()) && this.hasVpcSecurityGroupMemberships() == other.hasVpcSecurityGroupMemberships() && Objects.equals(this.vpcSecurityGroupMemberships(), other.vpcSecurityGroupMemberships());
    }

    public final String toString() {
        return ToString.builder((String)"Option").add("OptionName", (Object)this.optionName()).add("OptionDescription", (Object)this.optionDescription()).add("Persistent", (Object)this.persistent()).add("Permanent", (Object)this.permanent()).add("Port", (Object)this.port()).add("OptionVersion", (Object)this.optionVersion()).add("OptionSettings", this.hasOptionSettings() ? this.optionSettings() : null).add("DBSecurityGroupMemberships", this.hasDbSecurityGroupMemberships() ? this.dbSecurityGroupMemberships() : null).add("VpcSecurityGroupMemberships", this.hasVpcSecurityGroupMemberships() ? this.vpcSecurityGroupMemberships() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionName": {
                return Optional.ofNullable(clazz.cast(this.optionName()));
            }
            case "OptionDescription": {
                return Optional.ofNullable(clazz.cast(this.optionDescription()));
            }
            case "Persistent": {
                return Optional.ofNullable(clazz.cast(this.persistent()));
            }
            case "Permanent": {
                return Optional.ofNullable(clazz.cast(this.permanent()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "OptionVersion": {
                return Optional.ofNullable(clazz.cast(this.optionVersion()));
            }
            case "OptionSettings": {
                return Optional.ofNullable(clazz.cast(this.optionSettings()));
            }
            case "DBSecurityGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupMemberships()));
            }
            case "VpcSecurityGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupMemberships()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Option, T> g) {
        return obj -> g.apply((Option)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String optionName;
        private String optionDescription;
        private Boolean persistent;
        private Boolean permanent;
        private Integer port;
        private String optionVersion;
        private List<OptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();
        private List<DBSecurityGroupMembership> dbSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();
        private List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Option model) {
            this.optionName(model.optionName);
            this.optionDescription(model.optionDescription);
            this.persistent(model.persistent);
            this.permanent(model.permanent);
            this.port(model.port);
            this.optionVersion(model.optionVersion);
            this.optionSettings(model.optionSettings);
            this.dbSecurityGroupMemberships(model.dbSecurityGroupMemberships);
            this.vpcSecurityGroupMemberships(model.vpcSecurityGroupMemberships);
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public final String getOptionDescription() {
            return this.optionDescription;
        }

        @Override
        public final Builder optionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
            return this;
        }

        public final void setOptionDescription(String optionDescription) {
            this.optionDescription = optionDescription;
        }

        public final Boolean getPersistent() {
            return this.persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public final Boolean getPermanent() {
            return this.permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getOptionVersion() {
            return this.optionVersion;
        }

        @Override
        public final Builder optionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
            return this;
        }

        public final void setOptionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
        }

        public final List<OptionSetting.Builder> getOptionSettings() {
            List<OptionSetting.Builder> result = OptionSettingConfigurationListCopier.copyToBuilder(this.optionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder optionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(OptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<OptionSetting.Builder> ... optionSettings) {
            this.optionSettings(Stream.of(optionSettings).map(c -> (OptionSetting)((OptionSetting.Builder)OptionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<OptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = OptionSettingConfigurationListCopier.copyFromBuilder(optionSettings);
        }

        public final List<DBSecurityGroupMembership.Builder> getDbSecurityGroupMemberships() {
            List<DBSecurityGroupMembership.Builder> result = DBSecurityGroupMembershipListCopier.copyToBuilder(this.dbSecurityGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(DBSecurityGroupMembership ... dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships(Arrays.asList(dbSecurityGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(Consumer<DBSecurityGroupMembership.Builder> ... dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships(Stream.of(dbSecurityGroupMemberships).map(c -> (DBSecurityGroupMembership)((DBSecurityGroupMembership.Builder)DBSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbSecurityGroupMemberships(Collection<DBSecurityGroupMembership.BuilderImpl> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupMembershipListCopier.copyFromBuilder(dbSecurityGroupMemberships);
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroupMemberships() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier.copyToBuilder(this.vpcSecurityGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership ... vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships(Arrays.asList(vpcSecurityGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships(Stream.of(vpcSecurityGroupMemberships).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroupMemberships);
        }

        public Option build() {
            return new Option(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Option> {
        public Builder optionName(String var1);

        public Builder optionDescription(String var1);

        public Builder persistent(Boolean var1);

        public Builder permanent(Boolean var1);

        public Builder port(Integer var1);

        public Builder optionVersion(String var1);

        public Builder optionSettings(Collection<OptionSetting> var1);

        public Builder optionSettings(OptionSetting ... var1);

        public Builder optionSettings(Consumer<OptionSetting.Builder> ... var1);

        public Builder dbSecurityGroupMemberships(Collection<DBSecurityGroupMembership> var1);

        public Builder dbSecurityGroupMemberships(DBSecurityGroupMembership ... var1);

        public Builder dbSecurityGroupMemberships(Consumer<DBSecurityGroupMembership.Builder> ... var1);

        public Builder vpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroupMemberships(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroupMemberships(Consumer<VpcSecurityGroupMembership.Builder> ... var1);
    }
}

