/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelExportTaskResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, CancelExportTaskResponse> {
    private static final SdkField<String> EXPORT_TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportTaskIdentifier").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::exportTaskIdentifier)).setter(CancelExportTaskResponse.setter(Builder::exportTaskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::sourceArn)).setter(CancelExportTaskResponse.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<List<String>> EXPORT_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportOnly").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::exportOnly)).setter(CancelExportTaskResponse.setter(Builder::exportOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportOnly").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SnapshotTime").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::snapshotTime)).setter(CancelExportTaskResponse.setter(Builder::snapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTime").build()}).build();
    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TaskStartTime").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::taskStartTime)).setter(CancelExportTaskResponse.setter(Builder::taskStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStartTime").build()}).build();
    private static final SdkField<Instant> TASK_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TaskEndTime").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::taskEndTime)).setter(CancelExportTaskResponse.setter(Builder::taskEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskEndTime").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::s3Bucket)).setter(CancelExportTaskResponse.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::s3Prefix)).setter(CancelExportTaskResponse.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::iamRoleArn)).setter(CancelExportTaskResponse.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::kmsKeyId)).setter(CancelExportTaskResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::status)).setter(CancelExportTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentProgress").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::percentProgress)).setter(CancelExportTaskResponse.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()}).build();
    private static final SdkField<Integer> TOTAL_EXTRACTED_DATA_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalExtractedDataInGB").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::totalExtractedDataInGB)).setter(CancelExportTaskResponse.setter(Builder::totalExtractedDataInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalExtractedDataInGB").build()}).build();
    private static final SdkField<String> FAILURE_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCause").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::failureCause)).setter(CancelExportTaskResponse.setter(Builder::failureCause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCause").build()}).build();
    private static final SdkField<String> WARNING_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarningMessage").getter(CancelExportTaskResponse.getter(CancelExportTaskResponse::warningMessage)).setter(CancelExportTaskResponse.setter(Builder::warningMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_IDENTIFIER_FIELD, SOURCE_ARN_FIELD, EXPORT_ONLY_FIELD, SNAPSHOT_TIME_FIELD, TASK_START_TIME_FIELD, TASK_END_TIME_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD, IAM_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, STATUS_FIELD, PERCENT_PROGRESS_FIELD, TOTAL_EXTRACTED_DATA_IN_GB_FIELD, FAILURE_CAUSE_FIELD, WARNING_MESSAGE_FIELD));
    private final String exportTaskIdentifier;
    private final String sourceArn;
    private final List<String> exportOnly;
    private final Instant snapshotTime;
    private final Instant taskStartTime;
    private final Instant taskEndTime;
    private final String s3Bucket;
    private final String s3Prefix;
    private final String iamRoleArn;
    private final String kmsKeyId;
    private final String status;
    private final Integer percentProgress;
    private final Integer totalExtractedDataInGB;
    private final String failureCause;
    private final String warningMessage;

    private CancelExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.exportTaskIdentifier = builder.exportTaskIdentifier;
        this.sourceArn = builder.sourceArn;
        this.exportOnly = builder.exportOnly;
        this.snapshotTime = builder.snapshotTime;
        this.taskStartTime = builder.taskStartTime;
        this.taskEndTime = builder.taskEndTime;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.iamRoleArn = builder.iamRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.status = builder.status;
        this.percentProgress = builder.percentProgress;
        this.totalExtractedDataInGB = builder.totalExtractedDataInGB;
        this.failureCause = builder.failureCause;
        this.warningMessage = builder.warningMessage;
    }

    public final String exportTaskIdentifier() {
        return this.exportTaskIdentifier;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final boolean hasExportOnly() {
        return this.exportOnly != null && !(this.exportOnly instanceof SdkAutoConstructList);
    }

    public final List<String> exportOnly() {
        return this.exportOnly;
    }

    public final Instant snapshotTime() {
        return this.snapshotTime;
    }

    public final Instant taskStartTime() {
        return this.taskStartTime;
    }

    public final Instant taskEndTime() {
        return this.taskEndTime;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String status() {
        return this.status;
    }

    public final Integer percentProgress() {
        return this.percentProgress;
    }

    public final Integer totalExtractedDataInGB() {
        return this.totalExtractedDataInGB;
    }

    public final String failureCause() {
        return this.failureCause;
    }

    public final String warningMessage() {
        return this.warningMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportOnly() ? this.exportOnly() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalExtractedDataInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(this.warningMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelExportTaskResponse)) {
            return false;
        }
        CancelExportTaskResponse other = (CancelExportTaskResponse)((Object)obj);
        return Objects.equals(this.exportTaskIdentifier(), other.exportTaskIdentifier()) && Objects.equals(this.sourceArn(), other.sourceArn()) && this.hasExportOnly() == other.hasExportOnly() && Objects.equals(this.exportOnly(), other.exportOnly()) && Objects.equals(this.snapshotTime(), other.snapshotTime()) && Objects.equals(this.taskStartTime(), other.taskStartTime()) && Objects.equals(this.taskEndTime(), other.taskEndTime()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.totalExtractedDataInGB(), other.totalExtractedDataInGB()) && Objects.equals(this.failureCause(), other.failureCause()) && Objects.equals(this.warningMessage(), other.warningMessage());
    }

    public final String toString() {
        return ToString.builder((String)"CancelExportTaskResponse").add("ExportTaskIdentifier", (Object)this.exportTaskIdentifier()).add("SourceArn", (Object)this.sourceArn()).add("ExportOnly", this.hasExportOnly() ? this.exportOnly() : null).add("SnapshotTime", (Object)this.snapshotTime()).add("TaskStartTime", (Object)this.taskStartTime()).add("TaskEndTime", (Object)this.taskEndTime()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Prefix", (Object)this.s3Prefix()).add("IamRoleArn", (Object)this.iamRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Status", (Object)this.status()).add("PercentProgress", (Object)this.percentProgress()).add("TotalExtractedDataInGB", (Object)this.totalExtractedDataInGB()).add("FailureCause", (Object)this.failureCause()).add("WarningMessage", (Object)this.warningMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.exportTaskIdentifier()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "ExportOnly": {
                return Optional.ofNullable(clazz.cast(this.exportOnly()));
            }
            case "SnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotTime()));
            }
            case "TaskStartTime": {
                return Optional.ofNullable(clazz.cast(this.taskStartTime()));
            }
            case "TaskEndTime": {
                return Optional.ofNullable(clazz.cast(this.taskEndTime()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PercentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "TotalExtractedDataInGB": {
                return Optional.ofNullable(clazz.cast(this.totalExtractedDataInGB()));
            }
            case "FailureCause": {
                return Optional.ofNullable(clazz.cast(this.failureCause()));
            }
            case "WarningMessage": {
                return Optional.ofNullable(clazz.cast(this.warningMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelExportTaskResponse, T> g) {
        return obj -> g.apply((CancelExportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String exportTaskIdentifier;
        private String sourceArn;
        private List<String> exportOnly = DefaultSdkAutoConstructList.getInstance();
        private Instant snapshotTime;
        private Instant taskStartTime;
        private Instant taskEndTime;
        private String s3Bucket;
        private String s3Prefix;
        private String iamRoleArn;
        private String kmsKeyId;
        private String status;
        private Integer percentProgress;
        private Integer totalExtractedDataInGB;
        private String failureCause;
        private String warningMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelExportTaskResponse model) {
            super(model);
            this.exportTaskIdentifier(model.exportTaskIdentifier);
            this.sourceArn(model.sourceArn);
            this.exportOnly(model.exportOnly);
            this.snapshotTime(model.snapshotTime);
            this.taskStartTime(model.taskStartTime);
            this.taskEndTime(model.taskEndTime);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
            this.iamRoleArn(model.iamRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.status(model.status);
            this.percentProgress(model.percentProgress);
            this.totalExtractedDataInGB(model.totalExtractedDataInGB);
            this.failureCause(model.failureCause);
            this.warningMessage(model.warningMessage);
        }

        public final String getExportTaskIdentifier() {
            return this.exportTaskIdentifier;
        }

        @Override
        public final Builder exportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
            return this;
        }

        public final void setExportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final Collection<String> getExportOnly() {
            if (this.exportOnly instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportOnly;
        }

        @Override
        public final Builder exportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportOnly(String ... exportOnly) {
            this.exportOnly(Arrays.asList(exportOnly));
            return this;
        }

        public final void setExportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
        }

        public final Instant getSnapshotTime() {
            return this.snapshotTime;
        }

        @Override
        public final Builder snapshotTime(Instant snapshotTime) {
            this.snapshotTime = snapshotTime;
            return this;
        }

        public final void setSnapshotTime(Instant snapshotTime) {
            this.snapshotTime = snapshotTime;
        }

        public final Instant getTaskStartTime() {
            return this.taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final Instant getTaskEndTime() {
            return this.taskEndTime;
        }

        @Override
        public final Builder taskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
            return this;
        }

        public final void setTaskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPercentProgress() {
            return this.percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final Integer getTotalExtractedDataInGB() {
            return this.totalExtractedDataInGB;
        }

        @Override
        public final Builder totalExtractedDataInGB(Integer totalExtractedDataInGB) {
            this.totalExtractedDataInGB = totalExtractedDataInGB;
            return this;
        }

        public final void setTotalExtractedDataInGB(Integer totalExtractedDataInGB) {
            this.totalExtractedDataInGB = totalExtractedDataInGB;
        }

        public final String getFailureCause() {
            return this.failureCause;
        }

        @Override
        public final Builder failureCause(String failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final void setFailureCause(String failureCause) {
            this.failureCause = failureCause;
        }

        public final String getWarningMessage() {
            return this.warningMessage;
        }

        @Override
        public final Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public final void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public CancelExportTaskResponse build() {
            return new CancelExportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelExportTaskResponse> {
        public Builder exportTaskIdentifier(String var1);

        public Builder sourceArn(String var1);

        public Builder exportOnly(Collection<String> var1);

        public Builder exportOnly(String ... var1);

        public Builder snapshotTime(Instant var1);

        public Builder taskStartTime(Instant var1);

        public Builder taskEndTime(Instant var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder iamRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder status(String var1);

        public Builder percentProgress(Integer var1);

        public Builder totalExtractedDataInGB(Integer var1);

        public Builder failureCause(String var1);

        public Builder warningMessage(String var1);
    }
}

