/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceRegion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceRegion> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(SourceRegion.getter(SourceRegion::regionName)).setter(SourceRegion.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(SourceRegion.getter(SourceRegion::endpoint)).setter(SourceRegion.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SourceRegion.getter(SourceRegion::status)).setter(SourceRegion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsDBInstanceAutomatedBackupsReplication").getter(SourceRegion.getter(SourceRegion::supportsDBInstanceAutomatedBackupsReplication)).setter(SourceRegion.setter(Builder::supportsDBInstanceAutomatedBackupsReplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsDBInstanceAutomatedBackupsReplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, ENDPOINT_FIELD, STATUS_FIELD, SUPPORTS_DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String endpoint;
    private final String status;
    private final Boolean supportsDBInstanceAutomatedBackupsReplication;

    private SourceRegion(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
        this.supportsDBInstanceAutomatedBackupsReplication = builder.supportsDBInstanceAutomatedBackupsReplication;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean supportsDBInstanceAutomatedBackupsReplication() {
        return this.supportsDBInstanceAutomatedBackupsReplication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsDBInstanceAutomatedBackupsReplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRegion)) {
            return false;
        }
        SourceRegion other = (SourceRegion)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.supportsDBInstanceAutomatedBackupsReplication(), other.supportsDBInstanceAutomatedBackupsReplication());
    }

    public final String toString() {
        return ToString.builder((String)"SourceRegion").add("RegionName", (Object)this.regionName()).add("Endpoint", (Object)this.endpoint()).add("Status", (Object)this.status()).add("SupportsDBInstanceAutomatedBackupsReplication", (Object)this.supportsDBInstanceAutomatedBackupsReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SupportsDBInstanceAutomatedBackupsReplication": {
                return Optional.ofNullable(clazz.cast(this.supportsDBInstanceAutomatedBackupsReplication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceRegion, T> g) {
        return obj -> g.apply((SourceRegion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String endpoint;
        private String status;
        private Boolean supportsDBInstanceAutomatedBackupsReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRegion model) {
            this.regionName(model.regionName);
            this.endpoint(model.endpoint);
            this.status(model.status);
            this.supportsDBInstanceAutomatedBackupsReplication(model.supportsDBInstanceAutomatedBackupsReplication);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getSupportsDBInstanceAutomatedBackupsReplication() {
            return this.supportsDBInstanceAutomatedBackupsReplication;
        }

        @Override
        public final Builder supportsDBInstanceAutomatedBackupsReplication(Boolean supportsDBInstanceAutomatedBackupsReplication) {
            this.supportsDBInstanceAutomatedBackupsReplication = supportsDBInstanceAutomatedBackupsReplication;
            return this;
        }

        public final void setSupportsDBInstanceAutomatedBackupsReplication(Boolean supportsDBInstanceAutomatedBackupsReplication) {
            this.supportsDBInstanceAutomatedBackupsReplication = supportsDBInstanceAutomatedBackupsReplication;
        }

        public SourceRegion build() {
            return new SourceRegion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceRegion> {
        public Builder regionName(String var1);

        public Builder endpoint(String var1);

        public Builder status(String var1);

        public Builder supportsDBInstanceAutomatedBackupsReplication(Boolean var1);
    }
}

