/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBClusterBacktrack;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse;

public class DescribeDBClusterBacktracksIterable
implements SdkIterable<DescribeDbClusterBacktracksResponse> {
    private final RdsClient client;
    private final DescribeDbClusterBacktracksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClusterBacktracksIterable(RdsClient client, DescribeDbClusterBacktracksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbClusterBacktracksResponseFetcher();
    }

    public Iterator<DescribeDbClusterBacktracksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBClusterBacktrack> dbClusterBacktracks() {
        Function<DescribeDbClusterBacktracksResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterBacktracks() != null) {
                return response.dbClusterBacktracks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClusterBacktracksResponseFetcher
    implements SyncPageFetcher<DescribeDbClusterBacktracksResponse> {
        private DescribeDbClusterBacktracksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterBacktracksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClusterBacktracksResponse nextPage(DescribeDbClusterBacktracksResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterBacktracksIterable.this.client.describeDBClusterBacktracks(DescribeDBClusterBacktracksIterable.this.firstRequest);
            }
            return DescribeDBClusterBacktracksIterable.this.client.describeDBClusterBacktracks((DescribeDbClusterBacktracksRequest)((Object)DescribeDBClusterBacktracksIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

