/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteInstallationMediaRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DeleteInstallationMediaRequest> {
    private static final SdkField<String> INSTALLATION_MEDIA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstallationMediaId").getter(DeleteInstallationMediaRequest.getter(DeleteInstallationMediaRequest::installationMediaId)).setter(DeleteInstallationMediaRequest.setter(Builder::installationMediaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallationMediaId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALLATION_MEDIA_ID_FIELD));
    private final String installationMediaId;

    private DeleteInstallationMediaRequest(BuilderImpl builder) {
        super(builder);
        this.installationMediaId = builder.installationMediaId;
    }

    public final String installationMediaId() {
        return this.installationMediaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.installationMediaId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstallationMediaRequest)) {
            return false;
        }
        DeleteInstallationMediaRequest other = (DeleteInstallationMediaRequest)((Object)obj);
        return Objects.equals(this.installationMediaId(), other.installationMediaId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteInstallationMediaRequest").add("InstallationMediaId", (Object)this.installationMediaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstallationMediaId": {
                return Optional.ofNullable(clazz.cast(this.installationMediaId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstallationMediaRequest, T> g) {
        return obj -> g.apply((DeleteInstallationMediaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String installationMediaId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstallationMediaRequest model) {
            super(model);
            this.installationMediaId(model.installationMediaId);
        }

        public final String getInstallationMediaId() {
            return this.installationMediaId;
        }

        @Override
        public final Builder installationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
            return this;
        }

        public final void setInstallationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstallationMediaRequest build() {
            return new DeleteInstallationMediaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteInstallationMediaRequest> {
        public Builder installationMediaId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

