/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;
import software.amazon.awssdk.services.rds.model.ReservedDBInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedDbInstancesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeReservedDbInstancesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReservedDbInstancesResponse.getter(DescribeReservedDbInstancesResponse::marker)).setter(DescribeReservedDbInstancesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReservedDBInstance>> RESERVED_DB_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedDBInstances").getter(DescribeReservedDbInstancesResponse.getter(DescribeReservedDbInstancesResponse::reservedDBInstances)).setter(DescribeReservedDbInstancesResponse.setter(Builder::reservedDBInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstances").build(), ListTrait.builder().memberLocationName("ReservedDBInstance").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedDBInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstance").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, RESERVED_DB_INSTANCES_FIELD));
    private final String marker;
    private final List<ReservedDBInstance> reservedDBInstances;

    private DescribeReservedDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedDBInstances = builder.reservedDBInstances;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReservedDBInstances() {
        return this.reservedDBInstances != null && !(this.reservedDBInstances instanceof SdkAutoConstructList);
    }

    public final List<ReservedDBInstance> reservedDBInstances() {
        return this.reservedDBInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedDBInstances() ? this.reservedDBInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesResponse)) {
            return false;
        }
        DescribeReservedDbInstancesResponse other = (DescribeReservedDbInstancesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReservedDBInstances() == other.hasReservedDBInstances() && Objects.equals(this.reservedDBInstances(), other.reservedDBInstances());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedDbInstancesResponse").add("Marker", (Object)this.marker()).add("ReservedDBInstances", this.hasReservedDBInstances() ? this.reservedDBInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedDBInstances": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedDbInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedDbInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedDBInstance> reservedDBInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedDBInstances(model.reservedDBInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedDBInstance.Builder> getReservedDBInstances() {
            if (this.reservedDBInstances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reservedDBInstances != null ? (Collection)this.reservedDBInstances.stream().map(ReservedDBInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedDBInstances(Collection<ReservedDBInstance> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copy(reservedDBInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstances(ReservedDBInstance ... reservedDBInstances) {
            this.reservedDBInstances(Arrays.asList(reservedDBInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstances(Consumer<ReservedDBInstance.Builder> ... reservedDBInstances) {
            this.reservedDBInstances(Stream.of(reservedDBInstances).map(c -> (ReservedDBInstance)((ReservedDBInstance.Builder)ReservedDBInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedDBInstances(Collection<ReservedDBInstance.BuilderImpl> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copyFromBuilder(reservedDBInstances);
        }

        @Override
        public DescribeReservedDbInstancesResponse build() {
            return new DescribeReservedDbInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedDbInstancesResponse> {
        public Builder marker(String var1);

        public Builder reservedDBInstances(Collection<ReservedDBInstance> var1);

        public Builder reservedDBInstances(ReservedDBInstance ... var1);

        public Builder reservedDBInstances(Consumer<ReservedDBInstance.Builder> ... var1);
    }
}

