/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterSnapshotAttributesResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterSnapshotIdentifier").getter(DBClusterSnapshotAttributesResult.getter(DBClusterSnapshotAttributesResult::dbClusterSnapshotIdentifier)).setter(DBClusterSnapshotAttributesResult.setter(Builder::dbClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<List<DBClusterSnapshotAttribute>> DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterSnapshotAttributes").getter(DBClusterSnapshotAttributesResult.getter(DBClusterSnapshotAttributesResult::dbClusterSnapshotAttributes)).setter(DBClusterSnapshotAttributesResult.setter(Builder::dbClusterSnapshotAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotAttributes").build(), ListTrait.builder().memberLocationName("DBClusterSnapshotAttribute").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterSnapshotAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotAttribute").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbClusterSnapshotIdentifier;
    private final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes;

    private DBClusterSnapshotAttributesResult(BuilderImpl builder) {
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterSnapshotAttributes = builder.dbClusterSnapshotAttributes;
    }

    public final String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public final boolean hasDbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes != null && !(this.dbClusterSnapshotAttributes instanceof SdkAutoConstructList);
    }

    public final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterSnapshotAttributes() ? this.dbClusterSnapshotAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshotAttributesResult)) {
            return false;
        }
        DBClusterSnapshotAttributesResult other = (DBClusterSnapshotAttributesResult)obj;
        return Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && this.hasDbClusterSnapshotAttributes() == other.hasDbClusterSnapshotAttributes() && Objects.equals(this.dbClusterSnapshotAttributes(), other.dbClusterSnapshotAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DBClusterSnapshotAttributesResult").add("DBClusterSnapshotIdentifier", (Object)this.dbClusterSnapshotIdentifier()).add("DBClusterSnapshotAttributes", this.hasDbClusterSnapshotAttributes() ? this.dbClusterSnapshotAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "DBClusterSnapshotAttributes": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterSnapshotAttributesResult, T> g) {
        return obj -> g.apply((DBClusterSnapshotAttributesResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshotAttributesResult model) {
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.dbClusterSnapshotAttributes(model.dbClusterSnapshotAttributes);
        }

        public final String getDbClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final Collection<DBClusterSnapshotAttribute.Builder> getDbClusterSnapshotAttributes() {
            if (this.dbClusterSnapshotAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbClusterSnapshotAttributes != null ? (Collection)this.dbClusterSnapshotAttributes.stream().map(DBClusterSnapshotAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copy(dbClusterSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Arrays.asList(dbClusterSnapshotAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(Consumer<DBClusterSnapshotAttribute.Builder> ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Stream.of(dbClusterSnapshotAttributes).map(c -> (DBClusterSnapshotAttribute)((DBClusterSnapshotAttribute.Builder)DBClusterSnapshotAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute.BuilderImpl> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copyFromBuilder(dbClusterSnapshotAttributes);
        }

        public DBClusterSnapshotAttributesResult build() {
            return new DBClusterSnapshotAttributesResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> var1);

        public Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... var1);

        public Builder dbClusterSnapshotAttributes(Consumer<DBClusterSnapshotAttribute.Builder> ... var1);
    }
}

