/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDbInstanceAutomatedBackupsReplicationRequest extends RdsRequest
        implements
        ToCopyableBuilder<StopDbInstanceAutomatedBackupsReplicationRequest.Builder, StopDbInstanceAutomatedBackupsReplicationRequest> {
    private static final SdkField<String> SOURCE_DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBInstanceArn")
            .getter(getter(StopDbInstanceAutomatedBackupsReplicationRequest::sourceDBInstanceArn))
            .setter(setter(Builder::sourceDBInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DB_INSTANCE_ARN_FIELD));

    private final String sourceDBInstanceArn;

    private StopDbInstanceAutomatedBackupsReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBInstanceArn = builder.sourceDBInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source DB instance for which to stop replicating automated backups, for
     * example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source DB instance for which to stop replicating automated backups,
     *         for example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
     */
    public final String sourceDBInstanceArn() {
        return sourceDBInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBInstanceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDbInstanceAutomatedBackupsReplicationRequest)) {
            return false;
        }
        StopDbInstanceAutomatedBackupsReplicationRequest other = (StopDbInstanceAutomatedBackupsReplicationRequest) obj;
        return Objects.equals(sourceDBInstanceArn(), other.sourceDBInstanceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDbInstanceAutomatedBackupsReplicationRequest")
                .add("SourceDBInstanceArn", sourceDBInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDBInstanceArn":
            return Optional.ofNullable(clazz.cast(sourceDBInstanceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopDbInstanceAutomatedBackupsReplicationRequest, T> g) {
        return obj -> g.apply((StopDbInstanceAutomatedBackupsReplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StopDbInstanceAutomatedBackupsReplicationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source DB instance for which to stop replicating automated backups, for
         * example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
         * </p>
         * 
         * @param sourceDBInstanceArn
         *        The Amazon Resource Name (ARN) of the source DB instance for which to stop replicating automated
         *        backups, for example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBInstanceArn(String sourceDBInstanceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String sourceDBInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDbInstanceAutomatedBackupsReplicationRequest model) {
            super(model);
            sourceDBInstanceArn(model.sourceDBInstanceArn);
        }

        public final String getSourceDBInstanceArn() {
            return sourceDBInstanceArn;
        }

        @Override
        public final Builder sourceDBInstanceArn(String sourceDBInstanceArn) {
            this.sourceDBInstanceArn = sourceDBInstanceArn;
            return this;
        }

        public final void setSourceDBInstanceArn(String sourceDBInstanceArn) {
            this.sourceDBInstanceArn = sourceDBInstanceArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopDbInstanceAutomatedBackupsReplicationRequest build() {
            return new StopDbInstanceAutomatedBackupsReplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
