/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Option group option settings are used to display settings available for each option with their default values and
 * other information. These values are used with the DescribeOptionGroupOptions action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionGroupOptionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<OptionGroupOptionSetting.Builder, OptionGroupOptionSetting> {
    private static final SdkField<String> SETTING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SettingName").getter(getter(OptionGroupOptionSetting::settingName)).setter(setter(Builder::settingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingName").build()).build();

    private static final SdkField<String> SETTING_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SettingDescription").getter(getter(OptionGroupOptionSetting::settingDescription))
            .setter(setter(Builder::settingDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingDescription").build())
            .build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(OptionGroupOptionSetting::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> APPLY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplyType").getter(getter(OptionGroupOptionSetting::applyType)).setter(setter(Builder::applyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyType").build()).build();

    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowedValues").getter(getter(OptionGroupOptionSetting::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()).build();

    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsModifiable").getter(getter(OptionGroupOptionSetting::isModifiable))
            .setter(setter(Builder::isModifiable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()).build();

    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRequired").getter(getter(OptionGroupOptionSetting::isRequired)).setter(setter(Builder::isRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRequired").build()).build();

    private static final SdkField<List<MinimumEngineVersionPerAllowedValue>> MINIMUM_ENGINE_VERSION_PER_ALLOWED_VALUE_FIELD = SdkField
            .<List<MinimumEngineVersionPerAllowedValue>> builder(MarshallingType.LIST)
            .memberName("MinimumEngineVersionPerAllowedValue")
            .getter(getter(OptionGroupOptionSetting::minimumEngineVersionPerAllowedValue))
            .setter(setter(Builder::minimumEngineVersionPerAllowedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MinimumEngineVersionPerAllowedValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("MinimumEngineVersionPerAllowedValue")
                            .memberFieldInfo(
                                    SdkField.<MinimumEngineVersionPerAllowedValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MinimumEngineVersionPerAllowedValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("MinimumEngineVersionPerAllowedValue").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETTING_NAME_FIELD,
            SETTING_DESCRIPTION_FIELD, DEFAULT_VALUE_FIELD, APPLY_TYPE_FIELD, ALLOWED_VALUES_FIELD, IS_MODIFIABLE_FIELD,
            IS_REQUIRED_FIELD, MINIMUM_ENGINE_VERSION_PER_ALLOWED_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String settingName;

    private final String settingDescription;

    private final String defaultValue;

    private final String applyType;

    private final String allowedValues;

    private final Boolean isModifiable;

    private final Boolean isRequired;

    private final List<MinimumEngineVersionPerAllowedValue> minimumEngineVersionPerAllowedValue;

    private OptionGroupOptionSetting(BuilderImpl builder) {
        this.settingName = builder.settingName;
        this.settingDescription = builder.settingDescription;
        this.defaultValue = builder.defaultValue;
        this.applyType = builder.applyType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.isRequired = builder.isRequired;
        this.minimumEngineVersionPerAllowedValue = builder.minimumEngineVersionPerAllowedValue;
    }

    /**
     * <p>
     * The name of the option group option.
     * </p>
     * 
     * @return The name of the option group option.
     */
    public final String settingName() {
        return settingName;
    }

    /**
     * <p>
     * The description of the option group option.
     * </p>
     * 
     * @return The description of the option group option.
     */
    public final String settingDescription() {
        return settingDescription;
    }

    /**
     * <p>
     * The default value for the option group option.
     * </p>
     * 
     * @return The default value for the option group option.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The DB engine specific parameter type for the option group option.
     * </p>
     * 
     * @return The DB engine specific parameter type for the option group option.
     */
    public final String applyType() {
        return applyType;
    }

    /**
     * <p>
     * Indicates the acceptable values for the option group option.
     * </p>
     * 
     * @return Indicates the acceptable values for the option group option.
     */
    public final String allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * Boolean value where true indicates that this option group option can be changed from the default value.
     * </p>
     * 
     * @return Boolean value where true indicates that this option group option can be changed from the default value.
     */
    public final Boolean isModifiable() {
        return isModifiable;
    }

    /**
     * <p>
     * Boolean value where true indicates that a value must be specified for this option setting of the option group
     * option.
     * </p>
     * 
     * @return Boolean value where true indicates that a value must be specified for this option setting of the option
     *         group option.
     */
    public final Boolean isRequired() {
        return isRequired;
    }

    /**
     * Returns true if the MinimumEngineVersionPerAllowedValue property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasMinimumEngineVersionPerAllowedValue() {
        return minimumEngineVersionPerAllowedValue != null
                && !(minimumEngineVersionPerAllowedValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The minimum DB engine version required for the corresponding allowed value for this option setting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMinimumEngineVersionPerAllowedValue()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The minimum DB engine version required for the corresponding allowed value for this option setting.
     */
    public final List<MinimumEngineVersionPerAllowedValue> minimumEngineVersionPerAllowedValue() {
        return minimumEngineVersionPerAllowedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(settingName());
        hashCode = 31 * hashCode + Objects.hashCode(settingDescription());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(applyType());
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(isRequired());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMinimumEngineVersionPerAllowedValue() ? minimumEngineVersionPerAllowedValue() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroupOptionSetting)) {
            return false;
        }
        OptionGroupOptionSetting other = (OptionGroupOptionSetting) obj;
        return Objects.equals(settingName(), other.settingName())
                && Objects.equals(settingDescription(), other.settingDescription())
                && Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(applyType(), other.applyType())
                && Objects.equals(allowedValues(), other.allowedValues()) && Objects.equals(isModifiable(), other.isModifiable())
                && Objects.equals(isRequired(), other.isRequired())
                && hasMinimumEngineVersionPerAllowedValue() == other.hasMinimumEngineVersionPerAllowedValue()
                && Objects.equals(minimumEngineVersionPerAllowedValue(), other.minimumEngineVersionPerAllowedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("OptionGroupOptionSetting")
                .add("SettingName", settingName())
                .add("SettingDescription", settingDescription())
                .add("DefaultValue", defaultValue())
                .add("ApplyType", applyType())
                .add("AllowedValues", allowedValues())
                .add("IsModifiable", isModifiable())
                .add("IsRequired", isRequired())
                .add("MinimumEngineVersionPerAllowedValue",
                        hasMinimumEngineVersionPerAllowedValue() ? minimumEngineVersionPerAllowedValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SettingName":
            return Optional.ofNullable(clazz.cast(settingName()));
        case "SettingDescription":
            return Optional.ofNullable(clazz.cast(settingDescription()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "ApplyType":
            return Optional.ofNullable(clazz.cast(applyType()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "IsModifiable":
            return Optional.ofNullable(clazz.cast(isModifiable()));
        case "IsRequired":
            return Optional.ofNullable(clazz.cast(isRequired()));
        case "MinimumEngineVersionPerAllowedValue":
            return Optional.ofNullable(clazz.cast(minimumEngineVersionPerAllowedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionGroupOptionSetting, T> g) {
        return obj -> g.apply((OptionGroupOptionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionGroupOptionSetting> {
        /**
         * <p>
         * The name of the option group option.
         * </p>
         * 
         * @param settingName
         *        The name of the option group option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingName(String settingName);

        /**
         * <p>
         * The description of the option group option.
         * </p>
         * 
         * @param settingDescription
         *        The description of the option group option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingDescription(String settingDescription);

        /**
         * <p>
         * The default value for the option group option.
         * </p>
         * 
         * @param defaultValue
         *        The default value for the option group option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The DB engine specific parameter type for the option group option.
         * </p>
         * 
         * @param applyType
         *        The DB engine specific parameter type for the option group option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyType(String applyType);

        /**
         * <p>
         * Indicates the acceptable values for the option group option.
         * </p>
         * 
         * @param allowedValues
         *        Indicates the acceptable values for the option group option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String allowedValues);

        /**
         * <p>
         * Boolean value where true indicates that this option group option can be changed from the default value.
         * </p>
         * 
         * @param isModifiable
         *        Boolean value where true indicates that this option group option can be changed from the default
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isModifiable(Boolean isModifiable);

        /**
         * <p>
         * Boolean value where true indicates that a value must be specified for this option setting of the option group
         * option.
         * </p>
         * 
         * @param isRequired
         *        Boolean value where true indicates that a value must be specified for this option setting of the
         *        option group option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRequired(Boolean isRequired);

        /**
         * <p>
         * The minimum DB engine version required for the corresponding allowed value for this option setting.
         * </p>
         * 
         * @param minimumEngineVersionPerAllowedValue
         *        The minimum DB engine version required for the corresponding allowed value for this option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersionPerAllowedValue(
                Collection<MinimumEngineVersionPerAllowedValue> minimumEngineVersionPerAllowedValue);

        /**
         * <p>
         * The minimum DB engine version required for the corresponding allowed value for this option setting.
         * </p>
         * 
         * @param minimumEngineVersionPerAllowedValue
         *        The minimum DB engine version required for the corresponding allowed value for this option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersionPerAllowedValue(MinimumEngineVersionPerAllowedValue... minimumEngineVersionPerAllowedValue);

        /**
         * <p>
         * The minimum DB engine version required for the corresponding allowed value for this option setting.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <MinimumEngineVersionPerAllowedValue>.Builder} avoiding the need to create one manually via {@link List
         * <MinimumEngineVersionPerAllowedValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MinimumEngineVersionPerAllowedValue>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #minimumEngineVersionPerAllowedValue(List<MinimumEngineVersionPerAllowedValue>)}.
         * 
         * @param minimumEngineVersionPerAllowedValue
         *        a consumer that will call methods on {@link List<MinimumEngineVersionPerAllowedValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumEngineVersionPerAllowedValue(List<MinimumEngineVersionPerAllowedValue>)
         */
        Builder minimumEngineVersionPerAllowedValue(
                Consumer<MinimumEngineVersionPerAllowedValue.Builder>... minimumEngineVersionPerAllowedValue);
    }

    static final class BuilderImpl implements Builder {
        private String settingName;

        private String settingDescription;

        private String defaultValue;

        private String applyType;

        private String allowedValues;

        private Boolean isModifiable;

        private Boolean isRequired;

        private List<MinimumEngineVersionPerAllowedValue> minimumEngineVersionPerAllowedValue = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroupOptionSetting model) {
            settingName(model.settingName);
            settingDescription(model.settingDescription);
            defaultValue(model.defaultValue);
            applyType(model.applyType);
            allowedValues(model.allowedValues);
            isModifiable(model.isModifiable);
            isRequired(model.isRequired);
            minimumEngineVersionPerAllowedValue(model.minimumEngineVersionPerAllowedValue);
        }

        public final String getSettingName() {
            return settingName;
        }

        @Override
        public final Builder settingName(String settingName) {
            this.settingName = settingName;
            return this;
        }

        public final void setSettingName(String settingName) {
            this.settingName = settingName;
        }

        public final String getSettingDescription() {
            return settingDescription;
        }

        @Override
        public final Builder settingDescription(String settingDescription) {
            this.settingDescription = settingDescription;
            return this;
        }

        public final void setSettingDescription(String settingDescription) {
            this.settingDescription = settingDescription;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getApplyType() {
            return applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final String getAllowedValues() {
            return allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final Boolean getIsModifiable() {
            return isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final Boolean getIsRequired() {
            return isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        public final Collection<MinimumEngineVersionPerAllowedValue.Builder> getMinimumEngineVersionPerAllowedValue() {
            if (minimumEngineVersionPerAllowedValue instanceof SdkAutoConstructList) {
                return null;
            }
            return minimumEngineVersionPerAllowedValue != null ? minimumEngineVersionPerAllowedValue.stream()
                    .map(MinimumEngineVersionPerAllowedValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder minimumEngineVersionPerAllowedValue(
                Collection<MinimumEngineVersionPerAllowedValue> minimumEngineVersionPerAllowedValue) {
            this.minimumEngineVersionPerAllowedValue = MinimumEngineVersionPerAllowedValueListCopier
                    .copy(minimumEngineVersionPerAllowedValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder minimumEngineVersionPerAllowedValue(
                MinimumEngineVersionPerAllowedValue... minimumEngineVersionPerAllowedValue) {
            minimumEngineVersionPerAllowedValue(Arrays.asList(minimumEngineVersionPerAllowedValue));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder minimumEngineVersionPerAllowedValue(
                Consumer<MinimumEngineVersionPerAllowedValue.Builder>... minimumEngineVersionPerAllowedValue) {
            minimumEngineVersionPerAllowedValue(Stream.of(minimumEngineVersionPerAllowedValue)
                    .map(c -> MinimumEngineVersionPerAllowedValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMinimumEngineVersionPerAllowedValue(
                Collection<MinimumEngineVersionPerAllowedValue.BuilderImpl> minimumEngineVersionPerAllowedValue) {
            this.minimumEngineVersionPerAllowedValue = MinimumEngineVersionPerAllowedValueListCopier
                    .copyFromBuilder(minimumEngineVersionPerAllowedValue);
        }

        @Override
        public OptionGroupOptionSetting build() {
            return new OptionGroupOptionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
