/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of all available options
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OptionConfiguration.Builder, OptionConfiguration> {
    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionName").getter(getter(OptionConfiguration::optionName)).setter(setter(Builder::optionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(OptionConfiguration::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> OPTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionVersion").getter(getter(OptionConfiguration::optionVersion))
            .setter(setter(Builder::optionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionVersion").build()).build();

    private static final SdkField<List<String>> DB_SECURITY_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroupMemberships")
            .getter(getter(OptionConfiguration::dbSecurityGroupMemberships))
            .setter(setter(Builder::dbSecurityGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupMemberships")
            .getter(getter(OptionConfiguration::vpcSecurityGroupMemberships))
            .setter(setter(Builder::vpcSecurityGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMemberships")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<OptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<OptionSetting>> builder(MarshallingType.LIST)
            .memberName("OptionSettings")
            .getter(getter(OptionConfiguration::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionSetting")
                            .memberFieldInfo(
                                    SdkField.<OptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionSetting").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_NAME_FIELD, PORT_FIELD,
            OPTION_VERSION_FIELD, DB_SECURITY_GROUP_MEMBERSHIPS_FIELD, VPC_SECURITY_GROUP_MEMBERSHIPS_FIELD,
            OPTION_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String optionName;

    private final Integer port;

    private final String optionVersion;

    private final List<String> dbSecurityGroupMemberships;

    private final List<String> vpcSecurityGroupMemberships;

    private final List<OptionSetting> optionSettings;

    private OptionConfiguration(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.port = builder.port;
        this.optionVersion = builder.optionVersion;
        this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
        this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
        this.optionSettings = builder.optionSettings;
    }

    /**
     * <p>
     * The configuration of options to include in a group.
     * </p>
     * 
     * @return The configuration of options to include in a group.
     */
    public final String optionName() {
        return optionName;
    }

    /**
     * <p>
     * The optional port for the option.
     * </p>
     * 
     * @return The optional port for the option.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The version for the option.
     * </p>
     * 
     * @return The version for the option.
     */
    public final String optionVersion() {
        return optionVersion;
    }

    /**
     * Returns true if the DBSecurityGroupMemberships property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasDbSecurityGroupMemberships() {
        return dbSecurityGroupMemberships != null && !(dbSecurityGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DBSecurityGroupMembership name strings used for this option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbSecurityGroupMemberships()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DBSecurityGroupMembership name strings used for this option.
     */
    public final List<String> dbSecurityGroupMemberships() {
        return dbSecurityGroupMemberships;
    }

    /**
     * Returns true if the VpcSecurityGroupMemberships property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasVpcSecurityGroupMemberships() {
        return vpcSecurityGroupMemberships != null && !(vpcSecurityGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VpcSecurityGroupMembership name strings used for this option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupMemberships()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VpcSecurityGroupMembership name strings used for this option.
     */
    public final List<String> vpcSecurityGroupMemberships() {
        return vpcSecurityGroupMemberships;
    }

    /**
     * Returns true if the OptionSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOptionSettings() {
        return optionSettings != null && !(optionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The option settings to include in an option group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOptionSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The option settings to include in an option group.
     */
    public final List<OptionSetting> optionSettings() {
        return optionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optionName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(optionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroupMemberships() ? dbSecurityGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupMemberships() ? vpcSecurityGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionSettings() ? optionSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionConfiguration)) {
            return false;
        }
        OptionConfiguration other = (OptionConfiguration) obj;
        return Objects.equals(optionName(), other.optionName()) && Objects.equals(port(), other.port())
                && Objects.equals(optionVersion(), other.optionVersion())
                && hasDbSecurityGroupMemberships() == other.hasDbSecurityGroupMemberships()
                && Objects.equals(dbSecurityGroupMemberships(), other.dbSecurityGroupMemberships())
                && hasVpcSecurityGroupMemberships() == other.hasVpcSecurityGroupMemberships()
                && Objects.equals(vpcSecurityGroupMemberships(), other.vpcSecurityGroupMemberships())
                && hasOptionSettings() == other.hasOptionSettings() && Objects.equals(optionSettings(), other.optionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptionConfiguration").add("OptionName", optionName()).add("Port", port())
                .add("OptionVersion", optionVersion())
                .add("DBSecurityGroupMemberships", hasDbSecurityGroupMemberships() ? dbSecurityGroupMemberships() : null)
                .add("VpcSecurityGroupMemberships", hasVpcSecurityGroupMemberships() ? vpcSecurityGroupMemberships() : null)
                .add("OptionSettings", hasOptionSettings() ? optionSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionName":
            return Optional.ofNullable(clazz.cast(optionName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "OptionVersion":
            return Optional.ofNullable(clazz.cast(optionVersion()));
        case "DBSecurityGroupMemberships":
            return Optional.ofNullable(clazz.cast(dbSecurityGroupMemberships()));
        case "VpcSecurityGroupMemberships":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupMemberships()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionConfiguration, T> g) {
        return obj -> g.apply((OptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionConfiguration> {
        /**
         * <p>
         * The configuration of options to include in a group.
         * </p>
         * 
         * @param optionName
         *        The configuration of options to include in a group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionName(String optionName);

        /**
         * <p>
         * The optional port for the option.
         * </p>
         * 
         * @param port
         *        The optional port for the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The version for the option.
         * </p>
         * 
         * @param optionVersion
         *        The version for the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionVersion(String optionVersion);

        /**
         * <p>
         * A list of DBSecurityGroupMembership name strings used for this option.
         * </p>
         * 
         * @param dbSecurityGroupMemberships
         *        A list of DBSecurityGroupMembership name strings used for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupMemberships(Collection<String> dbSecurityGroupMemberships);

        /**
         * <p>
         * A list of DBSecurityGroupMembership name strings used for this option.
         * </p>
         * 
         * @param dbSecurityGroupMemberships
         *        A list of DBSecurityGroupMembership name strings used for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupMemberships(String... dbSecurityGroupMemberships);

        /**
         * <p>
         * A list of VpcSecurityGroupMembership name strings used for this option.
         * </p>
         * 
         * @param vpcSecurityGroupMemberships
         *        A list of VpcSecurityGroupMembership name strings used for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships);

        /**
         * <p>
         * A list of VpcSecurityGroupMembership name strings used for this option.
         * </p>
         * 
         * @param vpcSecurityGroupMemberships
         *        A list of VpcSecurityGroupMembership name strings used for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupMemberships(String... vpcSecurityGroupMemberships);

        /**
         * <p>
         * The option settings to include in an option group.
         * </p>
         * 
         * @param optionSettings
         *        The option settings to include in an option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<OptionSetting> optionSettings);

        /**
         * <p>
         * The option settings to include in an option group.
         * </p>
         * 
         * @param optionSettings
         *        The option settings to include in an option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(OptionSetting... optionSettings);

        /**
         * <p>
         * The option settings to include in an option group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OptionSetting>.Builder} avoiding the need
         * to create one manually via {@link List<OptionSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OptionSetting>.Builder#build()} is called immediately and
         * its result is passed to {@link #optionSettings(List<OptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on {@link List<OptionSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(List<OptionSetting>)
         */
        Builder optionSettings(Consumer<OptionSetting.Builder>... optionSettings);
    }

    static final class BuilderImpl implements Builder {
        private String optionName;

        private Integer port;

        private String optionVersion;

        private List<String> dbSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private List<OptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptionConfiguration model) {
            optionName(model.optionName);
            port(model.port);
            optionVersion(model.optionVersion);
            dbSecurityGroupMemberships(model.dbSecurityGroupMemberships);
            vpcSecurityGroupMemberships(model.vpcSecurityGroupMemberships);
            optionSettings(model.optionSettings);
        }

        public final String getOptionName() {
            return optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getOptionVersion() {
            return optionVersion;
        }

        @Override
        public final Builder optionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
            return this;
        }

        public final void setOptionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
        }

        public final Collection<String> getDbSecurityGroupMemberships() {
            if (dbSecurityGroupMemberships instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroupMemberships;
        }

        @Override
        public final Builder dbSecurityGroupMemberships(Collection<String> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupNameListCopier.copy(dbSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(String... dbSecurityGroupMemberships) {
            dbSecurityGroupMemberships(Arrays.asList(dbSecurityGroupMemberships));
            return this;
        }

        public final void setDbSecurityGroupMemberships(Collection<String> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupNameListCopier.copy(dbSecurityGroupMemberships);
        }

        public final Collection<String> getVpcSecurityGroupMemberships() {
            if (vpcSecurityGroupMemberships instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupMemberships;
        }

        @Override
        public final Builder vpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(String... vpcSecurityGroupMemberships) {
            vpcSecurityGroupMemberships(Arrays.asList(vpcSecurityGroupMemberships));
            return this;
        }

        public final void setVpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupMemberships);
        }

        public final Collection<OptionSetting.Builder> getOptionSettings() {
            if (optionSettings instanceof SdkAutoConstructList) {
                return null;
            }
            return optionSettings != null ? optionSettings.stream().map(OptionSetting::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder optionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(OptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<OptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings).map(c -> OptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<OptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = OptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        public OptionConfiguration build() {
            return new OptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
