/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbProxyTargetGroupResponse extends RdsResponse implements
        ToCopyableBuilder<ModifyDbProxyTargetGroupResponse.Builder, ModifyDbProxyTargetGroupResponse> {
    private static final SdkField<DBProxyTargetGroup> DB_PROXY_TARGET_GROUP_FIELD = SdkField
            .<DBProxyTargetGroup> builder(MarshallingType.SDK_POJO).memberName("DBProxyTargetGroup")
            .getter(getter(ModifyDbProxyTargetGroupResponse::dbProxyTargetGroup)).setter(setter(Builder::dbProxyTargetGroup))
            .constructor(DBProxyTargetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyTargetGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_TARGET_GROUP_FIELD));

    private final DBProxyTargetGroup dbProxyTargetGroup;

    private ModifyDbProxyTargetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbProxyTargetGroup = builder.dbProxyTargetGroup;
    }

    /**
     * <p>
     * The settings of the modified <code>DBProxyTarget</code>.
     * </p>
     * 
     * @return The settings of the modified <code>DBProxyTarget</code>.
     */
    public final DBProxyTargetGroup dbProxyTargetGroup() {
        return dbProxyTargetGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyTargetGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyTargetGroupResponse)) {
            return false;
        }
        ModifyDbProxyTargetGroupResponse other = (ModifyDbProxyTargetGroupResponse) obj;
        return Objects.equals(dbProxyTargetGroup(), other.dbProxyTargetGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbProxyTargetGroupResponse").add("DBProxyTargetGroup", dbProxyTargetGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyTargetGroup":
            return Optional.ofNullable(clazz.cast(dbProxyTargetGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyTargetGroupResponse, T> g) {
        return obj -> g.apply((ModifyDbProxyTargetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbProxyTargetGroupResponse> {
        /**
         * <p>
         * The settings of the modified <code>DBProxyTarget</code>.
         * </p>
         * 
         * @param dbProxyTargetGroup
         *        The settings of the modified <code>DBProxyTarget</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyTargetGroup(DBProxyTargetGroup dbProxyTargetGroup);

        /**
         * <p>
         * The settings of the modified <code>DBProxyTarget</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DBProxyTargetGroup.Builder} avoiding the need to
         * create one manually via {@link DBProxyTargetGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBProxyTargetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #dbProxyTargetGroup(DBProxyTargetGroup)}.
         * 
         * @param dbProxyTargetGroup
         *        a consumer that will call methods on {@link DBProxyTargetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbProxyTargetGroup(DBProxyTargetGroup)
         */
        default Builder dbProxyTargetGroup(Consumer<DBProxyTargetGroup.Builder> dbProxyTargetGroup) {
            return dbProxyTargetGroup(DBProxyTargetGroup.builder().applyMutation(dbProxyTargetGroup).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBProxyTargetGroup dbProxyTargetGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyTargetGroupResponse model) {
            super(model);
            dbProxyTargetGroup(model.dbProxyTargetGroup);
        }

        public final DBProxyTargetGroup.Builder getDbProxyTargetGroup() {
            return dbProxyTargetGroup != null ? dbProxyTargetGroup.toBuilder() : null;
        }

        @Override
        public final Builder dbProxyTargetGroup(DBProxyTargetGroup dbProxyTargetGroup) {
            this.dbProxyTargetGroup = dbProxyTargetGroup;
            return this;
        }

        public final void setDbProxyTargetGroup(DBProxyTargetGroup.BuilderImpl dbProxyTargetGroup) {
            this.dbProxyTargetGroup = dbProxyTargetGroup != null ? dbProxyTargetGroup.build() : null;
        }

        @Override
        public ModifyDbProxyTargetGroupResponse build() {
            return new ModifyDbProxyTargetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
