/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the state of scheduled or in-process failover operations on an Aurora global database
 * (<a>GlobalCluster</a>). This Data type is empty unless a failover operation is scheduled or is currently underway on
 * the Aurora global database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverState implements SdkPojo, Serializable, ToCopyableBuilder<FailoverState.Builder, FailoverState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FailoverState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FROM_DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromDbClusterArn").getter(getter(FailoverState::fromDbClusterArn))
            .setter(setter(Builder::fromDbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromDbClusterArn").build()).build();

    private static final SdkField<String> TO_DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ToDbClusterArn").getter(getter(FailoverState::toDbClusterArn)).setter(setter(Builder::toDbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToDbClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            FROM_DB_CLUSTER_ARN_FIELD, TO_DB_CLUSTER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String fromDbClusterArn;

    private final String toDbClusterArn;

    private FailoverState(BuilderImpl builder) {
        this.status = builder.status;
        this.fromDbClusterArn = builder.fromDbClusterArn;
        this.toDbClusterArn = builder.toDbClusterArn;
    }

    /**
     * <p>
     * The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been received by the
     * service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are being
     * verified before the failover process can start.
     * </p>
     * </li>
     * <li>
     * <p>
     * failing-over &#x96; This status covers the range of Aurora internal operations that take place during the
     * failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and
     * synchronizing replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was cancelled and
     * the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous
     * states.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been received
     *         by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB
     *         cluster are being verified before the failover process can start.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         failing-over &#x96; This status covers the range of Aurora internal operations that take place during the
     *         failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and
     *         synchronizing replicas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was
     *         cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to
     *         their previous states.
     *         </p>
     *         </li>
     * @see FailoverStatus
     */
    public final FailoverStatus status() {
        return FailoverStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been received by the
     * service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are being
     * verified before the failover process can start.
     * </p>
     * </li>
     * <li>
     * <p>
     * failing-over &#x96; This status covers the range of Aurora internal operations that take place during the
     * failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and
     * synchronizing replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was cancelled and
     * the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous
     * states.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been received
     *         by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB
     *         cluster are being verified before the failover process can start.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         failing-over &#x96; This status covers the range of Aurora internal operations that take place during the
     *         failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and
     *         synchronizing replicas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was
     *         cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to
     *         their previous states.
     *         </p>
     *         </li>
     * @see FailoverStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated
     * with this state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is
     *         associated with this state.
     */
    public final String fromDbClusterArn() {
        return fromDbClusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated
     * with this state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is
     *         associated with this state.
     */
    public final String toDbClusterArn() {
        return toDbClusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fromDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(toDbClusterArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverState)) {
            return false;
        }
        FailoverState other = (FailoverState) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(fromDbClusterArn(), other.fromDbClusterArn())
                && Objects.equals(toDbClusterArn(), other.toDbClusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverState").add("Status", statusAsString()).add("FromDbClusterArn", fromDbClusterArn())
                .add("ToDbClusterArn", toDbClusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FromDbClusterArn":
            return Optional.ofNullable(clazz.cast(fromDbClusterArn()));
        case "ToDbClusterArn":
            return Optional.ofNullable(clazz.cast(toDbClusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverState, T> g) {
        return obj -> g.apply((FailoverState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailoverState> {
        /**
         * <p>
         * The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been received by
         * the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are
         * being verified before the failover process can start.
         * </p>
         * </li>
         * <li>
         * <p>
         * failing-over &#x96; This status covers the range of Aurora internal operations that take place during the
         * failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and
         * synchronizing replicas.
         * </p>
         * </li>
         * <li>
         * <p>
         * cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was cancelled
         * and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their
         * previous states.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as
         *        follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been
         *        received by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified
         *        secondary DB cluster are being verified before the failover process can start.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        failing-over &#x96; This status covers the range of Aurora internal operations that take place during
         *        the failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora
         *        DB, and synchronizing replicas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was
         *        cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning
         *        to their previous states.
         *        </p>
         *        </li>
         * @see FailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been received by
         * the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are
         * being verified before the failover process can start.
         * </p>
         * </li>
         * <li>
         * <p>
         * failing-over &#x96; This status covers the range of Aurora internal operations that take place during the
         * failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and
         * synchronizing replicas.
         * </p>
         * </li>
         * <li>
         * <p>
         * cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was cancelled
         * and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their
         * previous states.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the Aurora global database (<a>GlobalCluster</a>). Possible values are as
         *        follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        pending &#x96; A request to fail over the Aurora global database (<a>GlobalCluster</a>) has been
         *        received by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified
         *        secondary DB cluster are being verified before the failover process can start.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        failing-over &#x96; This status covers the range of Aurora internal operations that take place during
         *        the failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora
         *        DB, and synchronizing replicas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        cancelling &#x96; The request to fail over the Aurora global database (<a>GlobalCluster</a>) was
         *        cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning
         *        to their previous states.
         *        </p>
         *        </li>
         * @see FailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverStatus
         */
        Builder status(FailoverStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is
         * associated with this state.
         * </p>
         * 
         * @param fromDbClusterArn
         *        The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is
         *        associated with this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDbClusterArn(String fromDbClusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is
         * associated with this state.
         * </p>
         * 
         * @param toDbClusterArn
         *        The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is
         *        associated with this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toDbClusterArn(String toDbClusterArn);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String fromDbClusterArn;

        private String toDbClusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverState model) {
            status(model.status);
            fromDbClusterArn(model.fromDbClusterArn);
            toDbClusterArn(model.toDbClusterArn);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FailoverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFromDbClusterArn() {
            return fromDbClusterArn;
        }

        @Override
        public final Builder fromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
            return this;
        }

        public final void setFromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
        }

        public final String getToDbClusterArn() {
            return toDbClusterArn;
        }

        @Override
        public final Builder toDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
            return this;
        }

        public final void setToDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
        }

        @Override
        public FailoverState build() {
            return new FailoverState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
