/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <code>DescribeDBInstanceAutomatedBackups</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbInstanceAutomatedBackupsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbInstanceAutomatedBackupsResponse.Builder, DescribeDbInstanceAutomatedBackupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbInstanceAutomatedBackupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBInstanceAutomatedBackup>> DB_INSTANCE_AUTOMATED_BACKUPS_FIELD = SdkField
            .<List<DBInstanceAutomatedBackup>> builder(MarshallingType.LIST)
            .memberName("DBInstanceAutomatedBackups")
            .getter(getter(DescribeDbInstanceAutomatedBackupsResponse::dbInstanceAutomatedBackups))
            .setter(setter(Builder::dbInstanceAutomatedBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBInstanceAutomatedBackup")
                            .memberFieldInfo(
                                    SdkField.<DBInstanceAutomatedBackup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBInstanceAutomatedBackup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBInstanceAutomatedBackup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_INSTANCE_AUTOMATED_BACKUPS_FIELD));

    private final String marker;

    private final List<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups;

    private DescribeDbInstanceAutomatedBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbInstanceAutomatedBackups = builder.dbInstanceAutomatedBackups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the DBInstanceAutomatedBackups property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasDbInstanceAutomatedBackups() {
        return dbInstanceAutomatedBackups != null && !(dbInstanceAutomatedBackups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DBInstanceAutomatedBackup</code> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbInstanceAutomatedBackups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>DBInstanceAutomatedBackup</code> instances.
     */
    public final List<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups() {
        return dbInstanceAutomatedBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbInstanceAutomatedBackups() ? dbInstanceAutomatedBackups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbInstanceAutomatedBackupsResponse)) {
            return false;
        }
        DescribeDbInstanceAutomatedBackupsResponse other = (DescribeDbInstanceAutomatedBackupsResponse) obj;
        return Objects.equals(marker(), other.marker())
                && hasDbInstanceAutomatedBackups() == other.hasDbInstanceAutomatedBackups()
                && Objects.equals(dbInstanceAutomatedBackups(), other.dbInstanceAutomatedBackups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbInstanceAutomatedBackupsResponse").add("Marker", marker())
                .add("DBInstanceAutomatedBackups", hasDbInstanceAutomatedBackups() ? dbInstanceAutomatedBackups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBInstanceAutomatedBackups":
            return Optional.ofNullable(clazz.cast(dbInstanceAutomatedBackups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbInstanceAutomatedBackupsResponse, T> g) {
        return obj -> g.apply((DescribeDbInstanceAutomatedBackupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbInstanceAutomatedBackupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <code>DBInstanceAutomatedBackup</code> instances.
         * </p>
         * 
         * @param dbInstanceAutomatedBackups
         *        A list of <code>DBInstanceAutomatedBackup</code> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceAutomatedBackups(Collection<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups);

        /**
         * <p>
         * A list of <code>DBInstanceAutomatedBackup</code> instances.
         * </p>
         * 
         * @param dbInstanceAutomatedBackups
         *        A list of <code>DBInstanceAutomatedBackup</code> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceAutomatedBackups(DBInstanceAutomatedBackup... dbInstanceAutomatedBackups);

        /**
         * <p>
         * A list of <code>DBInstanceAutomatedBackup</code> instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBInstanceAutomatedBackup>.Builder}
         * avoiding the need to create one manually via {@link List<DBInstanceAutomatedBackup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBInstanceAutomatedBackup>.Builder#build()} is called
         * immediately and its result is passed to {@link #dbInstanceAutomatedBackups(List<DBInstanceAutomatedBackup>)}.
         * 
         * @param dbInstanceAutomatedBackups
         *        a consumer that will call methods on {@link List<DBInstanceAutomatedBackup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbInstanceAutomatedBackups(List<DBInstanceAutomatedBackup>)
         */
        Builder dbInstanceAutomatedBackups(Consumer<DBInstanceAutomatedBackup.Builder>... dbInstanceAutomatedBackups);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbInstanceAutomatedBackupsResponse model) {
            super(model);
            marker(model.marker);
            dbInstanceAutomatedBackups(model.dbInstanceAutomatedBackups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBInstanceAutomatedBackup.Builder> getDbInstanceAutomatedBackups() {
            if (dbInstanceAutomatedBackups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbInstanceAutomatedBackups != null ? dbInstanceAutomatedBackups.stream()
                    .map(DBInstanceAutomatedBackup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbInstanceAutomatedBackups(Collection<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups) {
            this.dbInstanceAutomatedBackups = DBInstanceAutomatedBackupListCopier.copy(dbInstanceAutomatedBackups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackups(DBInstanceAutomatedBackup... dbInstanceAutomatedBackups) {
            dbInstanceAutomatedBackups(Arrays.asList(dbInstanceAutomatedBackups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackups(Consumer<DBInstanceAutomatedBackup.Builder>... dbInstanceAutomatedBackups) {
            dbInstanceAutomatedBackups(Stream.of(dbInstanceAutomatedBackups)
                    .map(c -> DBInstanceAutomatedBackup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbInstanceAutomatedBackups(
                Collection<DBInstanceAutomatedBackup.BuilderImpl> dbInstanceAutomatedBackups) {
            this.dbInstanceAutomatedBackups = DBInstanceAutomatedBackupListCopier.copyFromBuilder(dbInstanceAutomatedBackups);
        }

        @Override
        public DescribeDbInstanceAutomatedBackupsResponse build() {
            return new DescribeDbInstanceAutomatedBackupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
