/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.ProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreDbInstanceToPointInTimeRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, RestoreDbInstanceToPointInTimeRequest> {
    private static final SdkField<String> SOURCE_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBInstanceIdentifier").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::sourceDBInstanceIdentifier)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::sourceDBInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceIdentifier").build()}).build();
    private static final SdkField<String> TARGET_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBInstanceIdentifier").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::targetDBInstanceIdentifier)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::targetDBInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBInstanceIdentifier").build()}).build();
    private static final SdkField<Instant> RESTORE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RestoreTime").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::restoreTime)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::restoreTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTime").build()}).build();
    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseLatestRestorableTime").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::useLatestRestorableTime)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::useLatestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::dbInstanceClass)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::port)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::availabilityZone)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::dbSubnetGroupName)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::multiAZ)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::publiclyAccessible)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::autoMinorVersionUpgrade)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::licenseModel)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBName").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::dbName)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::engine)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::iops)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::optionGroupName)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::copyTagsToSnapshot)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::tags)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::storageType)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TdeCredentialArn").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::tdeCredentialArn)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::tdeCredentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TdeCredentialPassword").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::tdeCredentialPassword)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::tdeCredentialPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialPassword").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::vpcSecurityGroupIds)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::domain)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::domainIAMRoleName)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::enableIAMDatabaseAuthentication)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableCloudwatchLogsExports").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::enableCloudwatchLogsExports)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessorFeatures").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::processorFeatures)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName("ProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseDefaultProcessorFeatures").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::useDefaultProcessorFeatures)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::useDefaultProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupName").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::dbParameterGroupName)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::dbParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::deletionProtection)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<String> SOURCE_DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDbiResourceId").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::sourceDbiResourceId)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::sourceDbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDbiResourceId").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllocatedStorage").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::maxAllocatedStorage)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build()}).build();
    private static final SdkField<String> SOURCE_DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBInstanceAutomatedBackupsArn").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::sourceDBInstanceAutomatedBackupsArn)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::sourceDBInstanceAutomatedBackupsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceAutomatedBackupsArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_CUSTOMER_OWNED_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCustomerOwnedIp").getter(RestoreDbInstanceToPointInTimeRequest.getter(RestoreDbInstanceToPointInTimeRequest::enableCustomerOwnedIp)).setter(RestoreDbInstanceToPointInTimeRequest.setter(Builder::enableCustomerOwnedIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCustomerOwnedIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DB_INSTANCE_IDENTIFIER_FIELD, TARGET_DB_INSTANCE_IDENTIFIER_FIELD, RESTORE_TIME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD, DB_INSTANCE_CLASS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD, DB_SUBNET_GROUP_NAME_FIELD, MULTI_AZ_FIELD, PUBLICLY_ACCESSIBLE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD, DB_NAME_FIELD, ENGINE_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, TAGS_FIELD, STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, TDE_CREDENTIAL_PASSWORD_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD, USE_DEFAULT_PROCESSOR_FEATURES_FIELD, DB_PARAMETER_GROUP_NAME_FIELD, DELETION_PROTECTION_FIELD, SOURCE_DBI_RESOURCE_ID_FIELD, MAX_ALLOCATED_STORAGE_FIELD, SOURCE_DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD, ENABLE_CUSTOMER_OWNED_IP_FIELD));
    private final String sourceDBInstanceIdentifier;
    private final String targetDBInstanceIdentifier;
    private final Instant restoreTime;
    private final Boolean useLatestRestorableTime;
    private final String dbInstanceClass;
    private final Integer port;
    private final String availabilityZone;
    private final String dbSubnetGroupName;
    private final Boolean multiAZ;
    private final Boolean publiclyAccessible;
    private final Boolean autoMinorVersionUpgrade;
    private final String licenseModel;
    private final String dbName;
    private final String engine;
    private final Integer iops;
    private final String optionGroupName;
    private final Boolean copyTagsToSnapshot;
    private final List<Tag> tags;
    private final String storageType;
    private final String tdeCredentialArn;
    private final String tdeCredentialPassword;
    private final List<String> vpcSecurityGroupIds;
    private final String domain;
    private final String domainIAMRoleName;
    private final Boolean enableIAMDatabaseAuthentication;
    private final List<String> enableCloudwatchLogsExports;
    private final List<ProcessorFeature> processorFeatures;
    private final Boolean useDefaultProcessorFeatures;
    private final String dbParameterGroupName;
    private final Boolean deletionProtection;
    private final String sourceDbiResourceId;
    private final Integer maxAllocatedStorage;
    private final String sourceDBInstanceAutomatedBackupsArn;
    private final Boolean enableCustomerOwnedIp;

    private RestoreDbInstanceToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBInstanceIdentifier = builder.sourceDBInstanceIdentifier;
        this.targetDBInstanceIdentifier = builder.targetDBInstanceIdentifier;
        this.restoreTime = builder.restoreTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.multiAZ = builder.multiAZ;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.dbName = builder.dbName;
        this.engine = builder.engine;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.tags = builder.tags;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.deletionProtection = builder.deletionProtection;
        this.sourceDbiResourceId = builder.sourceDbiResourceId;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.sourceDBInstanceAutomatedBackupsArn = builder.sourceDBInstanceAutomatedBackupsArn;
        this.enableCustomerOwnedIp = builder.enableCustomerOwnedIp;
    }

    public final String sourceDBInstanceIdentifier() {
        return this.sourceDBInstanceIdentifier;
    }

    public final String targetDBInstanceIdentifier() {
        return this.targetDBInstanceIdentifier;
    }

    public final Instant restoreTime() {
        return this.restoreTime;
    }

    public final Boolean useLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final Integer port() {
        return this.port;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String licenseModel() {
        return this.licenseModel;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final String engine() {
        return this.engine;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public final String tdeCredentialPassword() {
        return this.tdeCredentialPassword;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final boolean hasEnableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports != null && !(this.enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public final boolean hasProcessorFeatures() {
        return this.processorFeatures != null && !(this.processorFeatures instanceof SdkAutoConstructList);
    }

    public final List<ProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public final Boolean useDefaultProcessorFeatures() {
        return this.useDefaultProcessorFeatures;
    }

    public final String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final String sourceDbiResourceId() {
        return this.sourceDbiResourceId;
    }

    public final Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public final String sourceDBInstanceAutomatedBackupsArn() {
        return this.sourceDBInstanceAutomatedBackupsArn;
    }

    public final Boolean enableCustomerOwnedIp() {
        return this.enableCustomerOwnedIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessorFeatures() ? this.processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBInstanceAutomatedBackupsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCustomerOwnedIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbInstanceToPointInTimeRequest)) {
            return false;
        }
        RestoreDbInstanceToPointInTimeRequest other = (RestoreDbInstanceToPointInTimeRequest)((Object)obj);
        return Objects.equals(this.sourceDBInstanceIdentifier(), other.sourceDBInstanceIdentifier()) && Objects.equals(this.targetDBInstanceIdentifier(), other.targetDBInstanceIdentifier()) && Objects.equals(this.restoreTime(), other.restoreTime()) && Objects.equals(this.useLatestRestorableTime(), other.useLatestRestorableTime()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.tdeCredentialPassword(), other.tdeCredentialPassword()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && this.hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports() && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && this.hasProcessorFeatures() == other.hasProcessorFeatures() && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures()) && Objects.equals(this.dbParameterGroupName(), other.dbParameterGroupName()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.sourceDbiResourceId(), other.sourceDbiResourceId()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.sourceDBInstanceAutomatedBackupsArn(), other.sourceDBInstanceAutomatedBackupsArn()) && Objects.equals(this.enableCustomerOwnedIp(), other.enableCustomerOwnedIp());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreDbInstanceToPointInTimeRequest").add("SourceDBInstanceIdentifier", (Object)this.sourceDBInstanceIdentifier()).add("TargetDBInstanceIdentifier", (Object)this.targetDBInstanceIdentifier()).add("RestoreTime", (Object)this.restoreTime()).add("UseLatestRestorableTime", (Object)this.useLatestRestorableTime()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("MultiAZ", (Object)this.multiAZ()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("LicenseModel", (Object)this.licenseModel()).add("DBName", (Object)this.dbName()).add("Engine", (Object)this.engine()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("Tags", this.hasTags() ? this.tags() : null).add("StorageType", (Object)this.storageType()).add("TdeCredentialArn", (Object)this.tdeCredentialArn()).add("TdeCredentialPassword", (Object)this.tdeCredentialPassword()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("Domain", (Object)this.domain()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("EnableCloudwatchLogsExports", this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null).add("ProcessorFeatures", this.hasProcessorFeatures() ? this.processorFeatures() : null).add("UseDefaultProcessorFeatures", (Object)this.useDefaultProcessorFeatures()).add("DBParameterGroupName", (Object)this.dbParameterGroupName()).add("DeletionProtection", (Object)this.deletionProtection()).add("SourceDbiResourceId", (Object)this.sourceDbiResourceId()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("SourceDBInstanceAutomatedBackupsArn", (Object)this.sourceDBInstanceAutomatedBackupsArn()).add("EnableCustomerOwnedIp", (Object)this.enableCustomerOwnedIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBInstanceIdentifier()));
            }
            case "TargetDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDBInstanceIdentifier()));
            }
            case "RestoreTime": {
                return Optional.ofNullable(clazz.cast(this.restoreTime()));
            }
            case "UseLatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableTime()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "TdeCredentialArn": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialArn()));
            }
            case "TdeCredentialPassword": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialPassword()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "UseDefaultProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.useDefaultProcessorFeatures()));
            }
            case "DBParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupName()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "SourceDbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceDbiResourceId()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "SourceDBInstanceAutomatedBackupsArn": {
                return Optional.ofNullable(clazz.cast(this.sourceDBInstanceAutomatedBackupsArn()));
            }
            case "EnableCustomerOwnedIp": {
                return Optional.ofNullable(clazz.cast(this.enableCustomerOwnedIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbInstanceToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreDbInstanceToPointInTimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String sourceDBInstanceIdentifier;
        private String targetDBInstanceIdentifier;
        private Instant restoreTime;
        private Boolean useLatestRestorableTime;
        private String dbInstanceClass;
        private Integer port;
        private String availabilityZone;
        private String dbSubnetGroupName;
        private Boolean multiAZ;
        private Boolean publiclyAccessible;
        private Boolean autoMinorVersionUpgrade;
        private String licenseModel;
        private String dbName;
        private String engine;
        private Integer iops;
        private String optionGroupName;
        private Boolean copyTagsToSnapshot;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String storageType;
        private String tdeCredentialArn;
        private String tdeCredentialPassword;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String domain;
        private String domainIAMRoleName;
        private Boolean enableIAMDatabaseAuthentication;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultProcessorFeatures;
        private String dbParameterGroupName;
        private Boolean deletionProtection;
        private String sourceDbiResourceId;
        private Integer maxAllocatedStorage;
        private String sourceDBInstanceAutomatedBackupsArn;
        private Boolean enableCustomerOwnedIp;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbInstanceToPointInTimeRequest model) {
            super(model);
            this.sourceDBInstanceIdentifier(model.sourceDBInstanceIdentifier);
            this.targetDBInstanceIdentifier(model.targetDBInstanceIdentifier);
            this.restoreTime(model.restoreTime);
            this.useLatestRestorableTime(model.useLatestRestorableTime);
            this.dbInstanceClass(model.dbInstanceClass);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.multiAZ(model.multiAZ);
            this.publiclyAccessible(model.publiclyAccessible);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.licenseModel(model.licenseModel);
            this.dbName(model.dbName);
            this.engine(model.engine);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.tags(model.tags);
            this.storageType(model.storageType);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.tdeCredentialPassword(model.tdeCredentialPassword);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.domain(model.domain);
            this.domainIAMRoleName(model.domainIAMRoleName);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.processorFeatures(model.processorFeatures);
            this.useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.deletionProtection(model.deletionProtection);
            this.sourceDbiResourceId(model.sourceDbiResourceId);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.sourceDBInstanceAutomatedBackupsArn(model.sourceDBInstanceAutomatedBackupsArn);
            this.enableCustomerOwnedIp(model.enableCustomerOwnedIp);
        }

        public final String getSourceDBInstanceIdentifier() {
            return this.sourceDBInstanceIdentifier;
        }

        @Override
        public final Builder sourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
            return this;
        }

        public final void setSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
        }

        public final String getTargetDBInstanceIdentifier() {
            return this.targetDBInstanceIdentifier;
        }

        @Override
        public final Builder targetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
            return this;
        }

        public final void setTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
        }

        public final Instant getRestoreTime() {
            return this.restoreTime;
        }

        @Override
        public final Builder restoreTime(Instant restoreTime) {
            this.restoreTime = restoreTime;
            return this;
        }

        public final void setRestoreTime(Instant restoreTime) {
            this.restoreTime = restoreTime;
        }

        public final Boolean getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final String getDbName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final String getTdeCredentialPassword() {
            return this.tdeCredentialPassword;
        }

        @Override
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (this.enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final Collection<ProcessorFeature.Builder> getProcessorFeatures() {
            if (this.processorFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processorFeatures != null ? (Collection)this.processorFeatures.stream().map(ProcessorFeature::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (ProcessorFeature)((ProcessorFeature.Builder)ProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return this.useDefaultProcessorFeatures;
        }

        @Override
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        public final String getDbParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final String getSourceDbiResourceId() {
            return this.sourceDbiResourceId;
        }

        @Override
        public final Builder sourceDbiResourceId(String sourceDbiResourceId) {
            this.sourceDbiResourceId = sourceDbiResourceId;
            return this;
        }

        public final void setSourceDbiResourceId(String sourceDbiResourceId) {
            this.sourceDbiResourceId = sourceDbiResourceId;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        public final String getSourceDBInstanceAutomatedBackupsArn() {
            return this.sourceDBInstanceAutomatedBackupsArn;
        }

        @Override
        public final Builder sourceDBInstanceAutomatedBackupsArn(String sourceDBInstanceAutomatedBackupsArn) {
            this.sourceDBInstanceAutomatedBackupsArn = sourceDBInstanceAutomatedBackupsArn;
            return this;
        }

        public final void setSourceDBInstanceAutomatedBackupsArn(String sourceDBInstanceAutomatedBackupsArn) {
            this.sourceDBInstanceAutomatedBackupsArn = sourceDBInstanceAutomatedBackupsArn;
        }

        public final Boolean getEnableCustomerOwnedIp() {
            return this.enableCustomerOwnedIp;
        }

        @Override
        public final Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
            return this;
        }

        public final void setEnableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbInstanceToPointInTimeRequest build() {
            return new RestoreDbInstanceToPointInTimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreDbInstanceToPointInTimeRequest> {
        public Builder sourceDBInstanceIdentifier(String var1);

        public Builder targetDBInstanceIdentifier(String var1);

        public Builder restoreTime(Instant var1);

        public Builder useLatestRestorableTime(Boolean var1);

        public Builder dbInstanceClass(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder dbName(String var1);

        public Builder engine(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder tdeCredentialPassword(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder domain(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder processorFeatures(Collection<ProcessorFeature> var1);

        public Builder processorFeatures(ProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... var1);

        public Builder useDefaultProcessorFeatures(Boolean var1);

        public Builder dbParameterGroupName(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder sourceDbiResourceId(String var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder sourceDBInstanceAutomatedBackupsArn(String var1);

        public Builder enableCustomerOwnedIp(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

