/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxyStatus;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.UserAuthConfigInfo;
import software.amazon.awssdk.services.rds.model.UserAuthConfigInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBProxy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBProxy> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(DBProxy.getter(DBProxy::dbProxyName)).setter(DBProxy.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<String> DB_PROXY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyArn").getter(DBProxy.getter(DBProxy::dbProxyArn)).setter(DBProxy.setter(Builder::dbProxyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBProxy.getter(DBProxy::statusAsString)).setter(DBProxy.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENGINE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineFamily").getter(DBProxy.getter(DBProxy::engineFamily)).setter(DBProxy.setter(Builder::engineFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineFamily").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(DBProxy.getter(DBProxy::vpcSecurityGroupIds)).setter(DBProxy.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSubnetIds").getter(DBProxy.getter(DBProxy::vpcSubnetIds)).setter(DBProxy.setter(Builder::vpcSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UserAuthConfigInfo>> AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Auth").getter(DBProxy.getter(DBProxy::auth)).setter(DBProxy.setter(Builder::auth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auth").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAuthConfigInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DBProxy.getter(DBProxy::roleArn)).setter(DBProxy.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(DBProxy.getter(DBProxy::endpoint)).setter(DBProxy.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Boolean> REQUIRE_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireTLS").getter(DBProxy.getter(DBProxy::requireTLS)).setter(DBProxy.setter(Builder::requireTLS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireTLS").build()}).build();
    private static final SdkField<Integer> IDLE_CLIENT_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdleClientTimeout").getter(DBProxy.getter(DBProxy::idleClientTimeout)).setter(DBProxy.setter(Builder::idleClientTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleClientTimeout").build()}).build();
    private static final SdkField<Boolean> DEBUG_LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DebugLogging").getter(DBProxy.getter(DBProxy::debugLogging)).setter(DBProxy.setter(Builder::debugLogging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugLogging").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(DBProxy.getter(DBProxy::createdDate)).setter(DBProxy.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedDate").getter(DBProxy.getter(DBProxy::updatedDate)).setter(DBProxy.setter(Builder::updatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD, DB_PROXY_ARN_FIELD, STATUS_FIELD, ENGINE_FAMILY_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, VPC_SUBNET_IDS_FIELD, AUTH_FIELD, ROLE_ARN_FIELD, ENDPOINT_FIELD, REQUIRE_TLS_FIELD, IDLE_CLIENT_TIMEOUT_FIELD, DEBUG_LOGGING_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbProxyName;
    private final String dbProxyArn;
    private final String status;
    private final String engineFamily;
    private final List<String> vpcSecurityGroupIds;
    private final List<String> vpcSubnetIds;
    private final List<UserAuthConfigInfo> auth;
    private final String roleArn;
    private final String endpoint;
    private final Boolean requireTLS;
    private final Integer idleClientTimeout;
    private final Boolean debugLogging;
    private final Instant createdDate;
    private final Instant updatedDate;

    private DBProxy(BuilderImpl builder) {
        this.dbProxyName = builder.dbProxyName;
        this.dbProxyArn = builder.dbProxyArn;
        this.status = builder.status;
        this.engineFamily = builder.engineFamily;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.auth = builder.auth;
        this.roleArn = builder.roleArn;
        this.endpoint = builder.endpoint;
        this.requireTLS = builder.requireTLS;
        this.idleClientTimeout = builder.idleClientTimeout;
        this.debugLogging = builder.debugLogging;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    public final String dbProxyArn() {
        return this.dbProxyArn;
    }

    public final DBProxyStatus status() {
        return DBProxyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String engineFamily() {
        return this.engineFamily;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final boolean hasVpcSubnetIds() {
        return this.vpcSubnetIds != null && !(this.vpcSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public final boolean hasAuth() {
        return this.auth != null && !(this.auth instanceof SdkAutoConstructList);
    }

    public final List<UserAuthConfigInfo> auth() {
        return this.auth;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Boolean requireTLS() {
        return this.requireTLS;
    }

    public final Integer idleClientTimeout() {
        return this.idleClientTimeout;
    }

    public final Boolean debugLogging() {
        return this.debugLogging;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant updatedDate() {
        return this.updatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuth() ? this.auth() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireTLS());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleClientTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugLogging());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBProxy)) {
            return false;
        }
        DBProxy other = (DBProxy)obj;
        return Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.dbProxyArn(), other.dbProxyArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.engineFamily(), other.engineFamily()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && this.hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(this.vpcSubnetIds(), other.vpcSubnetIds()) && this.hasAuth() == other.hasAuth() && Objects.equals(this.auth(), other.auth()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.requireTLS(), other.requireTLS()) && Objects.equals(this.idleClientTimeout(), other.idleClientTimeout()) && Objects.equals(this.debugLogging(), other.debugLogging()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.updatedDate(), other.updatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"DBProxy").add("DBProxyName", (Object)this.dbProxyName()).add("DBProxyArn", (Object)this.dbProxyArn()).add("Status", (Object)this.statusAsString()).add("EngineFamily", (Object)this.engineFamily()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("VpcSubnetIds", this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null).add("Auth", this.hasAuth() ? this.auth() : null).add("RoleArn", (Object)this.roleArn()).add("Endpoint", (Object)this.endpoint()).add("RequireTLS", (Object)this.requireTLS()).add("IdleClientTimeout", (Object)this.idleClientTimeout()).add("DebugLogging", (Object)this.debugLogging()).add("CreatedDate", (Object)this.createdDate()).add("UpdatedDate", (Object)this.updatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "DBProxyArn": {
                return Optional.ofNullable(clazz.cast(this.dbProxyArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EngineFamily": {
                return Optional.ofNullable(clazz.cast(this.engineFamily()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "VpcSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnetIds()));
            }
            case "Auth": {
                return Optional.ofNullable(clazz.cast(this.auth()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "RequireTLS": {
                return Optional.ofNullable(clazz.cast(this.requireTLS()));
            }
            case "IdleClientTimeout": {
                return Optional.ofNullable(clazz.cast(this.idleClientTimeout()));
            }
            case "DebugLogging": {
                return Optional.ofNullable(clazz.cast(this.debugLogging()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "UpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.updatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBProxy, T> g) {
        return obj -> g.apply((DBProxy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbProxyName;
        private String dbProxyArn;
        private String status;
        private String engineFamily;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<UserAuthConfigInfo> auth = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String endpoint;
        private Boolean requireTLS;
        private Integer idleClientTimeout;
        private Boolean debugLogging;
        private Instant createdDate;
        private Instant updatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DBProxy model) {
            this.dbProxyName(model.dbProxyName);
            this.dbProxyArn(model.dbProxyArn);
            this.status(model.status);
            this.engineFamily(model.engineFamily);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.vpcSubnetIds(model.vpcSubnetIds);
            this.auth(model.auth);
            this.roleArn(model.roleArn);
            this.endpoint(model.endpoint);
            this.requireTLS(model.requireTLS);
            this.idleClientTimeout(model.idleClientTimeout);
            this.debugLogging(model.debugLogging);
            this.createdDate(model.createdDate);
            this.updatedDate(model.updatedDate);
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        public final String getDbProxyArn() {
            return this.dbProxyArn;
        }

        @Override
        public final Builder dbProxyArn(String dbProxyArn) {
            this.dbProxyArn = dbProxyArn;
            return this;
        }

        public final void setDbProxyArn(String dbProxyArn) {
            this.dbProxyArn = dbProxyArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DBProxyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEngineFamily() {
            return this.engineFamily;
        }

        @Override
        public final Builder engineFamily(String engineFamily) {
            this.engineFamily = engineFamily;
            return this;
        }

        public final void setEngineFamily(String engineFamily) {
            this.engineFamily = engineFamily;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        public final Collection<String> getVpcSubnetIds() {
            if (this.vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSubnetIds;
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String ... vpcSubnetIds) {
            this.vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
        }

        public final Collection<UserAuthConfigInfo.Builder> getAuth() {
            if (this.auth instanceof SdkAutoConstructList) {
                return null;
            }
            return this.auth != null ? (Collection)this.auth.stream().map(UserAuthConfigInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder auth(Collection<UserAuthConfigInfo> auth) {
            this.auth = UserAuthConfigInfoListCopier.copy(auth);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(UserAuthConfigInfo ... auth) {
            this.auth(Arrays.asList(auth));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(Consumer<UserAuthConfigInfo.Builder> ... auth) {
            this.auth(Stream.of(auth).map(c -> (UserAuthConfigInfo)((UserAuthConfigInfo.Builder)UserAuthConfigInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuth(Collection<UserAuthConfigInfo.BuilderImpl> auth) {
            this.auth = UserAuthConfigInfoListCopier.copyFromBuilder(auth);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final Boolean getRequireTLS() {
            return this.requireTLS;
        }

        @Override
        public final Builder requireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
            return this;
        }

        public final void setRequireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
        }

        public final Integer getIdleClientTimeout() {
            return this.idleClientTimeout;
        }

        @Override
        public final Builder idleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        public final void setIdleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
        }

        public final Boolean getDebugLogging() {
            return this.debugLogging;
        }

        @Override
        public final Builder debugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        public final void setDebugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        public DBProxy build() {
            return new DBProxy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBProxy> {
        public Builder dbProxyName(String var1);

        public Builder dbProxyArn(String var1);

        public Builder status(String var1);

        public Builder status(DBProxyStatus var1);

        public Builder engineFamily(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder vpcSubnetIds(Collection<String> var1);

        public Builder vpcSubnetIds(String ... var1);

        public Builder auth(Collection<UserAuthConfigInfo> var1);

        public Builder auth(UserAuthConfigInfo ... var1);

        public Builder auth(Consumer<UserAuthConfigInfo.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder endpoint(String var1);

        public Builder requireTLS(Boolean var1);

        public Builder idleClientTimeout(Integer var1);

        public Builder debugLogging(Boolean var1);

        public Builder createdDate(Instant var1);

        public Builder updatedDate(Instant var1);
    }
}

