/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DBProxyTarget;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse;

public class DescribeDBProxyTargetsPublisher
implements SdkPublisher<DescribeDbProxyTargetsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbProxyTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBProxyTargetsPublisher(RdsAsyncClient client, DescribeDbProxyTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBProxyTargetsPublisher(RdsAsyncClient client, DescribeDbProxyTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbProxyTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbProxyTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBProxyTarget> targets() {
        Function<DescribeDbProxyTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbProxyTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbProxyTargetsResponseFetcher
    implements AsyncPageFetcher<DescribeDbProxyTargetsResponse> {
        private DescribeDbProxyTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxyTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbProxyTargetsResponse> nextPage(DescribeDbProxyTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxyTargetsPublisher.this.client.describeDBProxyTargets(DescribeDBProxyTargetsPublisher.this.firstRequest);
            }
            return DescribeDBProxyTargetsPublisher.this.client.describeDBProxyTargets((DescribeDbProxyTargetsRequest)((Object)DescribeDBProxyTargetsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

