/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedDbInstancesOfferingRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, PurchaseReservedDbInstancesOfferingRequest> {
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedDBInstancesOfferingId").getter(PurchaseReservedDbInstancesOfferingRequest.getter(PurchaseReservedDbInstancesOfferingRequest::reservedDBInstancesOfferingId)).setter(PurchaseReservedDbInstancesOfferingRequest.setter(Builder::reservedDBInstancesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId").build()}).build();
    private static final SdkField<String> RESERVED_DB_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedDBInstanceId").getter(PurchaseReservedDbInstancesOfferingRequest.getter(PurchaseReservedDbInstancesOfferingRequest::reservedDBInstanceId)).setter(PurchaseReservedDbInstancesOfferingRequest.setter(Builder::reservedDBInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceId").build()}).build();
    private static final SdkField<Integer> DB_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DBInstanceCount").getter(PurchaseReservedDbInstancesOfferingRequest.getter(PurchaseReservedDbInstancesOfferingRequest::dbInstanceCount)).setter(PurchaseReservedDbInstancesOfferingRequest.setter(Builder::dbInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceCount").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PurchaseReservedDbInstancesOfferingRequest.getter(PurchaseReservedDbInstancesOfferingRequest::tags)).setter(PurchaseReservedDbInstancesOfferingRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, RESERVED_DB_INSTANCE_ID_FIELD, DB_INSTANCE_COUNT_FIELD, TAGS_FIELD));
    private final String reservedDBInstancesOfferingId;
    private final String reservedDBInstanceId;
    private final Integer dbInstanceCount;
    private final List<Tag> tags;

    private PurchaseReservedDbInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.tags = builder.tags;
    }

    public String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public String reservedDBInstanceId() {
        return this.reservedDBInstanceId;
    }

    public Integer dbInstanceCount() {
        return this.dbInstanceCount;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedDbInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedDbInstancesOfferingRequest other = (PurchaseReservedDbInstancesOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId()) && Objects.equals(this.reservedDBInstanceId(), other.reservedDBInstanceId()) && Objects.equals(this.dbInstanceCount(), other.dbInstanceCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseReservedDbInstancesOfferingRequest").add("ReservedDBInstancesOfferingId", (Object)this.reservedDBInstancesOfferingId()).add("ReservedDBInstanceId", (Object)this.reservedDBInstanceId()).add("DBInstanceCount", (Object)this.dbInstanceCount()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedDBInstancesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstancesOfferingId()));
            }
            case "ReservedDBInstanceId": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstanceId()));
            }
            case "DBInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceCount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedDbInstancesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedDbInstancesOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String reservedDBInstancesOfferingId;
        private String reservedDBInstanceId;
        private Integer dbInstanceCount;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedDbInstancesOfferingRequest model) {
            super(model);
            this.reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.reservedDBInstanceId(model.reservedDBInstanceId);
            this.dbInstanceCount(model.dbInstanceCount);
            this.tags(model.tags);
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getReservedDBInstanceId() {
            return this.reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final Integer getDbInstanceCount() {
            return this.dbInstanceCount;
        }

        @Override
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final void setDbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedDbInstancesOfferingRequest build() {
            return new PurchaseReservedDbInstancesOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedDbInstancesOfferingRequest> {
        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder reservedDBInstanceId(String var1);

        public Builder dbInstanceCount(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

