/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DBInstanceListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbInstancesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbInstancesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbInstancesResponse.getter(DescribeDbInstancesResponse::marker)).setter(DescribeDbInstancesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBInstance>> DB_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBInstances").getter(DescribeDbInstancesResponse.getter(DescribeDbInstancesResponse::dbInstances)).setter(DescribeDbInstancesResponse.setter(Builder::dbInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstances").build(), ListTrait.builder().memberLocationName("DBInstance").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstance").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_INSTANCES_FIELD));
    private final String marker;
    private final List<DBInstance> dbInstances;

    private DescribeDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbInstances = builder.dbInstances;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasDbInstances() {
        return this.dbInstances != null && !(this.dbInstances instanceof SdkAutoConstructList);
    }

    public List<DBInstance> dbInstances() {
        return this.dbInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbInstances() ? this.dbInstances() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbInstancesResponse)) {
            return false;
        }
        DescribeDbInstancesResponse other = (DescribeDbInstancesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbInstances() == other.hasDbInstances() && Objects.equals(this.dbInstances(), other.dbInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbInstancesResponse").add("Marker", (Object)this.marker()).add("DBInstances", this.hasDbInstances() ? this.dbInstances() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBInstances": {
                return Optional.ofNullable(clazz.cast(this.dbInstances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbInstancesResponse, T> g) {
        return obj -> g.apply((DescribeDbInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBInstance> dbInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbInstancesResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbInstances(model.dbInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBInstance.Builder> getDbInstances() {
            if (this.dbInstances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbInstances != null ? (Collection)this.dbInstances.stream().map(DBInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbInstances(Collection<DBInstance> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copy(dbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(DBInstance ... dbInstances) {
            this.dbInstances(Arrays.asList(dbInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(Consumer<DBInstance.Builder> ... dbInstances) {
            this.dbInstances(Stream.of(dbInstances).map(c -> (DBInstance)((DBInstance.Builder)DBInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbInstances(Collection<DBInstance.BuilderImpl> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copyFromBuilder(dbInstances);
        }

        @Override
        public DescribeDbInstancesResponse build() {
            return new DescribeDbInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbInstancesResponse> {
        public Builder marker(String var1);

        public Builder dbInstances(Collection<DBInstance> var1);

        public Builder dbInstances(DBInstance ... var1);

        public Builder dbInstances(Consumer<DBInstance.Builder> ... var1);
    }
}

