/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.InstallationMedia;
import software.amazon.awssdk.services.rds.model.InstallationMediaListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstallationMediaResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeInstallationMediaResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeInstallationMediaResponse.getter(DescribeInstallationMediaResponse::marker)).setter(DescribeInstallationMediaResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<InstallationMedia>> INSTALLATION_MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstallationMedia").getter(DescribeInstallationMediaResponse.getter(DescribeInstallationMediaResponse::installationMedia)).setter(DescribeInstallationMediaResponse.setter(Builder::installationMedia)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallationMedia").build(), ListTrait.builder().memberLocationName("InstallationMedia").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstallationMedia::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallationMedia").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, INSTALLATION_MEDIA_FIELD));
    private final String marker;
    private final List<InstallationMedia> installationMedia;

    private DescribeInstallationMediaResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.installationMedia = builder.installationMedia;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasInstallationMedia() {
        return this.installationMedia != null && !(this.installationMedia instanceof SdkAutoConstructList);
    }

    public List<InstallationMedia> installationMedia() {
        return this.installationMedia;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstallationMedia() ? this.installationMedia() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstallationMediaResponse)) {
            return false;
        }
        DescribeInstallationMediaResponse other = (DescribeInstallationMediaResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasInstallationMedia() == other.hasInstallationMedia() && Objects.equals(this.installationMedia(), other.installationMedia());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstallationMediaResponse").add("Marker", (Object)this.marker()).add("InstallationMedia", this.hasInstallationMedia() ? this.installationMedia() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "InstallationMedia": {
                return Optional.ofNullable(clazz.cast(this.installationMedia()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstallationMediaResponse, T> g) {
        return obj -> g.apply((DescribeInstallationMediaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<InstallationMedia> installationMedia = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstallationMediaResponse model) {
            super(model);
            this.marker(model.marker);
            this.installationMedia(model.installationMedia);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<InstallationMedia.Builder> getInstallationMedia() {
            if (this.installationMedia instanceof SdkAutoConstructList) {
                return null;
            }
            return this.installationMedia != null ? (Collection)this.installationMedia.stream().map(InstallationMedia::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder installationMedia(Collection<InstallationMedia> installationMedia) {
            this.installationMedia = InstallationMediaListCopier.copy(installationMedia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installationMedia(InstallationMedia ... installationMedia) {
            this.installationMedia(Arrays.asList(installationMedia));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installationMedia(Consumer<InstallationMedia.Builder> ... installationMedia) {
            this.installationMedia(Stream.of(installationMedia).map(c -> (InstallationMedia)((InstallationMedia.Builder)InstallationMedia.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstallationMedia(Collection<InstallationMedia.BuilderImpl> installationMedia) {
            this.installationMedia = InstallationMediaListCopier.copyFromBuilder(installationMedia);
        }

        @Override
        public DescribeInstallationMediaResponse build() {
            return new DescribeInstallationMediaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstallationMediaResponse> {
        public Builder marker(String var1);

        public Builder installationMedia(Collection<InstallationMedia> var1);

        public Builder installationMedia(InstallationMedia ... var1);

        public Builder installationMedia(Consumer<InstallationMedia.Builder> ... var1);
    }
}

