/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.CustomAvailabilityZone;
import software.amazon.awssdk.services.rds.model.CustomAvailabilityZoneListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomAvailabilityZonesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeCustomAvailabilityZonesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCustomAvailabilityZonesResponse.getter(DescribeCustomAvailabilityZonesResponse::marker)).setter(DescribeCustomAvailabilityZonesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<CustomAvailabilityZone>> CUSTOM_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomAvailabilityZones").getter(DescribeCustomAvailabilityZonesResponse.getter(DescribeCustomAvailabilityZonesResponse::customAvailabilityZones)).setter(DescribeCustomAvailabilityZonesResponse.setter(Builder::customAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZones").build(), ListTrait.builder().memberLocationName("CustomAvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomAvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZone").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CUSTOM_AVAILABILITY_ZONES_FIELD));
    private final String marker;
    private final List<CustomAvailabilityZone> customAvailabilityZones;

    private DescribeCustomAvailabilityZonesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.customAvailabilityZones = builder.customAvailabilityZones;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasCustomAvailabilityZones() {
        return this.customAvailabilityZones != null && !(this.customAvailabilityZones instanceof SdkAutoConstructList);
    }

    public List<CustomAvailabilityZone> customAvailabilityZones() {
        return this.customAvailabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAvailabilityZones() ? this.customAvailabilityZones() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomAvailabilityZonesResponse)) {
            return false;
        }
        DescribeCustomAvailabilityZonesResponse other = (DescribeCustomAvailabilityZonesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasCustomAvailabilityZones() == other.hasCustomAvailabilityZones() && Objects.equals(this.customAvailabilityZones(), other.customAvailabilityZones());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCustomAvailabilityZonesResponse").add("Marker", (Object)this.marker()).add("CustomAvailabilityZones", this.hasCustomAvailabilityZones() ? this.customAvailabilityZones() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "CustomAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.customAvailabilityZones()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomAvailabilityZonesResponse, T> g) {
        return obj -> g.apply((DescribeCustomAvailabilityZonesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CustomAvailabilityZone> customAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomAvailabilityZonesResponse model) {
            super(model);
            this.marker(model.marker);
            this.customAvailabilityZones(model.customAvailabilityZones);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CustomAvailabilityZone.Builder> getCustomAvailabilityZones() {
            if (this.customAvailabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customAvailabilityZones != null ? (Collection)this.customAvailabilityZones.stream().map(CustomAvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customAvailabilityZones(Collection<CustomAvailabilityZone> customAvailabilityZones) {
            this.customAvailabilityZones = CustomAvailabilityZoneListCopier.copy(customAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAvailabilityZones(CustomAvailabilityZone ... customAvailabilityZones) {
            this.customAvailabilityZones(Arrays.asList(customAvailabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAvailabilityZones(Consumer<CustomAvailabilityZone.Builder> ... customAvailabilityZones) {
            this.customAvailabilityZones(Stream.of(customAvailabilityZones).map(c -> (CustomAvailabilityZone)((CustomAvailabilityZone.Builder)CustomAvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomAvailabilityZones(Collection<CustomAvailabilityZone.BuilderImpl> customAvailabilityZones) {
            this.customAvailabilityZones = CustomAvailabilityZoneListCopier.copyFromBuilder(customAvailabilityZones);
        }

        @Override
        public DescribeCustomAvailabilityZonesResponse build() {
            return new DescribeCustomAvailabilityZonesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomAvailabilityZonesResponse> {
        public Builder marker(String var1);

        public Builder customAvailabilityZones(Collection<CustomAvailabilityZone> var1);

        public Builder customAvailabilityZones(CustomAvailabilityZone ... var1);

        public Builder customAvailabilityZones(Consumer<CustomAvailabilityZone.Builder> ... var1);
    }
}

