/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceAction;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceActionDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcePendingMaintenanceActions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcePendingMaintenanceActions> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(ResourcePendingMaintenanceActions.getter(ResourcePendingMaintenanceActions::resourceIdentifier)).setter(ResourcePendingMaintenanceActions.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<List<PendingMaintenanceAction>> PENDING_MAINTENANCE_ACTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingMaintenanceActionDetails").getter(ResourcePendingMaintenanceActions.getter(ResourcePendingMaintenanceActions::pendingMaintenanceActionDetails)).setter(ResourcePendingMaintenanceActions.setter(Builder::pendingMaintenanceActionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenanceActionDetails").build(), ListTrait.builder().memberLocationName("PendingMaintenanceAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingMaintenanceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenanceAction").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, PENDING_MAINTENANCE_ACTION_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceIdentifier;
    private final List<PendingMaintenanceAction> pendingMaintenanceActionDetails;

    private ResourcePendingMaintenanceActions(BuilderImpl builder) {
        this.resourceIdentifier = builder.resourceIdentifier;
        this.pendingMaintenanceActionDetails = builder.pendingMaintenanceActionDetails;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public boolean hasPendingMaintenanceActionDetails() {
        return this.pendingMaintenanceActionDetails != null && !(this.pendingMaintenanceActionDetails instanceof SdkAutoConstructList);
    }

    public List<PendingMaintenanceAction> pendingMaintenanceActionDetails() {
        return this.pendingMaintenanceActionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingMaintenanceActionDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePendingMaintenanceActions)) {
            return false;
        }
        ResourcePendingMaintenanceActions other = (ResourcePendingMaintenanceActions)obj;
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.pendingMaintenanceActionDetails(), other.pendingMaintenanceActionDetails());
    }

    public String toString() {
        return ToString.builder((String)"ResourcePendingMaintenanceActions").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("PendingMaintenanceActionDetails", this.pendingMaintenanceActionDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "PendingMaintenanceActionDetails": {
                return Optional.ofNullable(clazz.cast(this.pendingMaintenanceActionDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePendingMaintenanceActions, T> g) {
        return obj -> g.apply((ResourcePendingMaintenanceActions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private List<PendingMaintenanceAction> pendingMaintenanceActionDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePendingMaintenanceActions model) {
            this.resourceIdentifier(model.resourceIdentifier);
            this.pendingMaintenanceActionDetails(model.pendingMaintenanceActionDetails);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public final Collection<PendingMaintenanceAction.Builder> getPendingMaintenanceActionDetails() {
            return this.pendingMaintenanceActionDetails != null ? (Collection)this.pendingMaintenanceActionDetails.stream().map(PendingMaintenanceAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier.copy(pendingMaintenanceActionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(PendingMaintenanceAction ... pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails(Arrays.asList(pendingMaintenanceActionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(Consumer<PendingMaintenanceAction.Builder> ... pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails(Stream.of(pendingMaintenanceActionDetails).map(c -> (PendingMaintenanceAction)((PendingMaintenanceAction.Builder)PendingMaintenanceAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingMaintenanceActionDetails(Collection<PendingMaintenanceAction.BuilderImpl> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier.copyFromBuilder(pendingMaintenanceActionDetails);
        }

        public ResourcePendingMaintenanceActions build() {
            return new ResourcePendingMaintenanceActions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcePendingMaintenanceActions> {
        public Builder resourceIdentifier(String var1);

        public Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> var1);

        public Builder pendingMaintenanceActionDetails(PendingMaintenanceAction ... var1);

        public Builder pendingMaintenanceActionDetails(Consumer<PendingMaintenanceAction.Builder> ... var1);
    }
}

