/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest;
import software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse;
import software.amazon.awssdk.services.rds.model.InstallationMedia;

public class DescribeInstallationMediaIterable
implements SdkIterable<DescribeInstallationMediaResponse> {
    private final RdsClient client;
    private final DescribeInstallationMediaRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstallationMediaIterable(RdsClient client, DescribeInstallationMediaRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstallationMediaResponseFetcher();
    }

    public Iterator<DescribeInstallationMediaResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstallationMedia> installationMedia() {
        Function<DescribeInstallationMediaResponse, Iterator> getIterator = response -> {
            if (response != null && response.installationMedia() != null) {
                return response.installationMedia().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstallationMediaResponseFetcher
    implements SyncPageFetcher<DescribeInstallationMediaResponse> {
        private DescribeInstallationMediaResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstallationMediaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeInstallationMediaResponse nextPage(DescribeInstallationMediaResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstallationMediaIterable.this.client.describeInstallationMedia(DescribeInstallationMediaIterable.this.firstRequest);
            }
            return DescribeInstallationMediaIterable.this.client.describeInstallationMedia((DescribeInstallationMediaRequest)((Object)DescribeInstallationMediaIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

