/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RestoreWindow;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBInstanceAutomatedBackup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBInstanceAutomatedBackup> {
    private static final SdkField<String> DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::dbInstanceArn)).setter(DBInstanceAutomatedBackup.setter(Builder::dbInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceArn").build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::dbiResourceId)).setter(DBInstanceAutomatedBackup.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::region)).setter(DBInstanceAutomatedBackup.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::dbInstanceIdentifier)).setter(DBInstanceAutomatedBackup.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<RestoreWindow> RESTORE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::restoreWindow)).setter(DBInstanceAutomatedBackup.setter(Builder::restoreWindow)).constructor(RestoreWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreWindow").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::allocatedStorage)).setter(DBInstanceAutomatedBackup.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::status)).setter(DBInstanceAutomatedBackup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::port)).setter(DBInstanceAutomatedBackup.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::availabilityZone)).setter(DBInstanceAutomatedBackup.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::vpcId)).setter(DBInstanceAutomatedBackup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::instanceCreateTime)).setter(DBInstanceAutomatedBackup.setter(Builder::instanceCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::masterUsername)).setter(DBInstanceAutomatedBackup.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::engine)).setter(DBInstanceAutomatedBackup.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::engineVersion)).setter(DBInstanceAutomatedBackup.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::licenseModel)).setter(DBInstanceAutomatedBackup.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::iops)).setter(DBInstanceAutomatedBackup.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::optionGroupName)).setter(DBInstanceAutomatedBackup.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::tdeCredentialArn)).setter(DBInstanceAutomatedBackup.setter(Builder::tdeCredentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::encrypted)).setter(DBInstanceAutomatedBackup.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::storageType)).setter(DBInstanceAutomatedBackup.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::kmsKeyId)).setter(DBInstanceAutomatedBackup.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::timezone)).setter(DBInstanceAutomatedBackup.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DBInstanceAutomatedBackup.getter(DBInstanceAutomatedBackup::iamDatabaseAuthenticationEnabled)).setter(DBInstanceAutomatedBackup.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_ARN_FIELD, DBI_RESOURCE_ID_FIELD, REGION_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, RESTORE_WINDOW_FIELD, ALLOCATED_STORAGE_FIELD, STATUS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, INSTANCE_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, TDE_CREDENTIAL_ARN_FIELD, ENCRYPTED_FIELD, STORAGE_TYPE_FIELD, KMS_KEY_ID_FIELD, TIMEZONE_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbInstanceArn;
    private final String dbiResourceId;
    private final String region;
    private final String dbInstanceIdentifier;
    private final RestoreWindow restoreWindow;
    private final Integer allocatedStorage;
    private final String status;
    private final Integer port;
    private final String availabilityZone;
    private final String vpcId;
    private final Instant instanceCreateTime;
    private final String masterUsername;
    private final String engine;
    private final String engineVersion;
    private final String licenseModel;
    private final Integer iops;
    private final String optionGroupName;
    private final String tdeCredentialArn;
    private final Boolean encrypted;
    private final String storageType;
    private final String kmsKeyId;
    private final String timezone;
    private final Boolean iamDatabaseAuthenticationEnabled;

    private DBInstanceAutomatedBackup(BuilderImpl builder) {
        this.dbInstanceArn = builder.dbInstanceArn;
        this.dbiResourceId = builder.dbiResourceId;
        this.region = builder.region;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.restoreWindow = builder.restoreWindow;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.encrypted = builder.encrypted;
        this.storageType = builder.storageType;
        this.kmsKeyId = builder.kmsKeyId;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
    }

    public String dbInstanceArn() {
        return this.dbInstanceArn;
    }

    public String dbiResourceId() {
        return this.dbiResourceId;
    }

    public String region() {
        return this.region;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public RestoreWindow restoreWindow() {
        return this.restoreWindow;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String status() {
        return this.status;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Instant instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String storageType() {
        return this.storageType;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String timezone() {
        return this.timezone;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstanceAutomatedBackup)) {
            return false;
        }
        DBInstanceAutomatedBackup other = (DBInstanceAutomatedBackup)obj;
        return Objects.equals(this.dbInstanceArn(), other.dbInstanceArn()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.restoreWindow(), other.restoreWindow()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.instanceCreateTime(), other.instanceCreateTime()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled());
    }

    public String toString() {
        return ToString.builder((String)"DBInstanceAutomatedBackup").add("DBInstanceArn", (Object)this.dbInstanceArn()).add("DbiResourceId", (Object)this.dbiResourceId()).add("Region", (Object)this.region()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("RestoreWindow", (Object)this.restoreWindow()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("Status", (Object)this.status()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcId", (Object)this.vpcId()).add("InstanceCreateTime", (Object)this.instanceCreateTime()).add("MasterUsername", (Object)this.masterUsername()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("LicenseModel", (Object)this.licenseModel()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("TdeCredentialArn", (Object)this.tdeCredentialArn()).add("Encrypted", (Object)this.encrypted()).add("StorageType", (Object)this.storageType()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Timezone", (Object)this.timezone()).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceArn()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "RestoreWindow": {
                return Optional.ofNullable(clazz.cast(this.restoreWindow()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "InstanceCreateTime": {
                return Optional.ofNullable(clazz.cast(this.instanceCreateTime()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "TdeCredentialArn": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialArn()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBInstanceAutomatedBackup, T> g) {
        return obj -> g.apply((DBInstanceAutomatedBackup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceArn;
        private String dbiResourceId;
        private String region;
        private String dbInstanceIdentifier;
        private RestoreWindow restoreWindow;
        private Integer allocatedStorage;
        private String status;
        private Integer port;
        private String availabilityZone;
        private String vpcId;
        private Instant instanceCreateTime;
        private String masterUsername;
        private String engine;
        private String engineVersion;
        private String licenseModel;
        private Integer iops;
        private String optionGroupName;
        private String tdeCredentialArn;
        private Boolean encrypted;
        private String storageType;
        private String kmsKeyId;
        private String timezone;
        private Boolean iamDatabaseAuthenticationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstanceAutomatedBackup model) {
            this.dbInstanceArn(model.dbInstanceArn);
            this.dbiResourceId(model.dbiResourceId);
            this.region(model.region);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.restoreWindow(model.restoreWindow);
            this.allocatedStorage(model.allocatedStorage);
            this.status(model.status);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.vpcId(model.vpcId);
            this.instanceCreateTime(model.instanceCreateTime);
            this.masterUsername(model.masterUsername);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.licenseModel(model.licenseModel);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.encrypted(model.encrypted);
            this.storageType(model.storageType);
            this.kmsKeyId(model.kmsKeyId);
            this.timezone(model.timezone);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
        }

        public final String getDbInstanceArn() {
            return this.dbInstanceArn;
        }

        @Override
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final void setDbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final RestoreWindow.Builder getRestoreWindow() {
            return this.restoreWindow != null ? this.restoreWindow.toBuilder() : null;
        }

        @Override
        public final Builder restoreWindow(RestoreWindow restoreWindow) {
            this.restoreWindow = restoreWindow;
            return this;
        }

        public final void setRestoreWindow(RestoreWindow.BuilderImpl restoreWindow) {
            this.restoreWindow = restoreWindow != null ? restoreWindow.build() : null;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Instant getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public DBInstanceAutomatedBackup build() {
            return new DBInstanceAutomatedBackup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBInstanceAutomatedBackup> {
        public Builder dbInstanceArn(String var1);

        public Builder dbiResourceId(String var1);

        public Builder region(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder restoreWindow(RestoreWindow var1);

        default public Builder restoreWindow(Consumer<RestoreWindow.Builder> restoreWindow) {
            return this.restoreWindow((RestoreWindow)((RestoreWindow.Builder)RestoreWindow.builder().applyMutation(restoreWindow)).build());
        }

        public Builder allocatedStorage(Integer var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder vpcId(String var1);

        public Builder instanceCreateTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder encrypted(Boolean var1);

        public Builder storageType(String var1);

        public Builder kmsKeyId(String var1);

        public Builder timezone(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);
    }
}

