/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxy;
import software.amazon.awssdk.services.rds.model.DBProxyListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbProxiesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbProxiesResponse> {
    private static final SdkField<List<DBProxy>> DB_PROXIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbProxiesResponse.getter(DescribeDbProxiesResponse::dbProxies)).setter(DescribeDbProxiesResponse.setter(Builder::dbProxies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBProxy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbProxiesResponse.getter(DescribeDbProxiesResponse::marker)).setter(DescribeDbProxiesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXIES_FIELD, MARKER_FIELD));
    private final List<DBProxy> dbProxies;
    private final String marker;

    private DescribeDbProxiesResponse(BuilderImpl builder) {
        super(builder);
        this.dbProxies = builder.dbProxies;
        this.marker = builder.marker;
    }

    public boolean hasDbProxies() {
        return this.dbProxies != null && !(this.dbProxies instanceof SdkAutoConstructList);
    }

    public List<DBProxy> dbProxies() {
        return this.dbProxies;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxies());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbProxiesResponse)) {
            return false;
        }
        DescribeDbProxiesResponse other = (DescribeDbProxiesResponse)((Object)obj);
        return Objects.equals(this.dbProxies(), other.dbProxies()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbProxiesResponse").add("DBProxies", this.dbProxies()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxies": {
                return Optional.ofNullable(clazz.cast(this.dbProxies()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbProxiesResponse, T> g) {
        return obj -> g.apply((DescribeDbProxiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBProxy> dbProxies = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbProxiesResponse model) {
            super(model);
            this.dbProxies(model.dbProxies);
            this.marker(model.marker);
        }

        public final Collection<DBProxy.Builder> getDbProxies() {
            return this.dbProxies != null ? (Collection)this.dbProxies.stream().map(DBProxy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbProxies(Collection<DBProxy> dbProxies) {
            this.dbProxies = DBProxyListCopier.copy(dbProxies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbProxies(DBProxy ... dbProxies) {
            this.dbProxies(Arrays.asList(dbProxies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbProxies(Consumer<DBProxy.Builder> ... dbProxies) {
            this.dbProxies(Stream.of(dbProxies).map(c -> (DBProxy)((DBProxy.Builder)DBProxy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbProxies(Collection<DBProxy.BuilderImpl> dbProxies) {
            this.dbProxies = DBProxyListCopier.copyFromBuilder(dbProxies);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDbProxiesResponse build() {
            return new DescribeDbProxiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbProxiesResponse> {
        public Builder dbProxies(Collection<DBProxy> var1);

        public Builder dbProxies(DBProxy ... var1);

        public Builder dbProxies(Consumer<DBProxy.Builder> ... var1);

        public Builder marker(String var1);
    }
}

