/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of a snapshot export to Amazon S3.
 * </p>
 * <p>
 * This data type is used as a response element in the <code>DescribeExportTasks</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExportTaskResponse extends RdsResponse implements
        ToCopyableBuilder<StartExportTaskResponse.Builder, StartExportTaskResponse> {
    private static final SdkField<String> EXPORT_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::exportTaskIdentifier)).setter(setter(Builder::exportTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<List<String>> EXPORT_ONLY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StartExportTaskResponse::exportOnly))
            .setter(setter(Builder::exportOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportOnly").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> SNAPSHOT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StartExportTaskResponse::snapshotTime)).setter(setter(Builder::snapshotTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTime").build()).build();

    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StartExportTaskResponse::taskStartTime)).setter(setter(Builder::taskStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStartTime").build()).build();

    private static final SdkField<Instant> TASK_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StartExportTaskResponse::taskEndTime)).setter(setter(Builder::taskEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskEndTime").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PERCENT_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StartExportTaskResponse::percentProgress)).setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()).build();

    private static final SdkField<Integer> TOTAL_EXTRACTED_DATA_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StartExportTaskResponse::totalExtractedDataInGB)).setter(setter(Builder::totalExtractedDataInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalExtractedDataInGB").build())
            .build();

    private static final SdkField<String> FAILURE_CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::failureCause)).setter(setter(Builder::failureCause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCause").build()).build();

    private static final SdkField<String> WARNING_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartExportTaskResponse::warningMessage)).setter(setter(Builder::warningMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_IDENTIFIER_FIELD,
            SOURCE_ARN_FIELD, EXPORT_ONLY_FIELD, SNAPSHOT_TIME_FIELD, TASK_START_TIME_FIELD, TASK_END_TIME_FIELD,
            S3_BUCKET_FIELD, S3_PREFIX_FIELD, IAM_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, STATUS_FIELD, PERCENT_PROGRESS_FIELD,
            TOTAL_EXTRACTED_DATA_IN_GB_FIELD, FAILURE_CAUSE_FIELD, WARNING_MESSAGE_FIELD));

    private final String exportTaskIdentifier;

    private final String sourceArn;

    private final List<String> exportOnly;

    private final Instant snapshotTime;

    private final Instant taskStartTime;

    private final Instant taskEndTime;

    private final String s3Bucket;

    private final String s3Prefix;

    private final String iamRoleArn;

    private final String kmsKeyId;

    private final String status;

    private final Integer percentProgress;

    private final Integer totalExtractedDataInGB;

    private final String failureCause;

    private final String warningMessage;

    private StartExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.exportTaskIdentifier = builder.exportTaskIdentifier;
        this.sourceArn = builder.sourceArn;
        this.exportOnly = builder.exportOnly;
        this.snapshotTime = builder.snapshotTime;
        this.taskStartTime = builder.taskStartTime;
        this.taskEndTime = builder.taskEndTime;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.iamRoleArn = builder.iamRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.status = builder.status;
        this.percentProgress = builder.percentProgress;
        this.totalExtractedDataInGB = builder.totalExtractedDataInGB;
        this.failureCause = builder.failureCause;
        this.warningMessage = builder.warningMessage;
    }

    /**
     * <p>
     * A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the
     * snapshot is exported to.
     * </p>
     * 
     * @return A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket
     *         where the snapshot is exported to.
     */
    public String exportTaskIdentifier() {
        return exportTaskIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * Returns true if the ExportOnly property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExportOnly() {
        return exportOnly != null && !(exportOnly instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data exported from the snapshot. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>database</code> - Export all the data from a specified database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS
     * for MySQL, RDS for MariaDB, and Aurora MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid
     * only for RDS for PostgreSQL and Aurora PostgreSQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is
     * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportOnly()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data exported from the snapshot. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>database</code> - Export all the data from a specified database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only
     *         for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format
     *         is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format
     *         is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     *         </p>
     *         </li>
     */
    public List<String> exportOnly() {
        return exportOnly;
    }

    /**
     * <p>
     * The time that the snapshot was created.
     * </p>
     * 
     * @return The time that the snapshot was created.
     */
    public Instant snapshotTime() {
        return snapshotTime;
    }

    /**
     * <p>
     * The time that the snapshot export task started.
     * </p>
     * 
     * @return The time that the snapshot export task started.
     */
    public Instant taskStartTime() {
        return taskStartTime;
    }

    /**
     * <p>
     * The time that the snapshot export task completed.
     * </p>
     * 
     * @return The time that the snapshot export task completed.
     */
    public Instant taskEndTime() {
        return taskEndTime;
    }

    /**
     * <p>
     * The Amazon S3 bucket that the snapshot is exported to.
     * </p>
     * 
     * @return The Amazon S3 bucket that the snapshot is exported to.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.
     * </p>
     * 
     * @return The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.
     */
    public String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.
     * </p>
     * 
     * @return The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The ID of the AWS KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key ID is
     * the Amazon Resource Name (ARN), the KMS key identifier, or the KMS key alias for the KMS encryption key. The IAM
     * role used for the snapshot export must have encryption and decryption permissions to use this KMS key.
     * </p>
     * 
     * @return The ID of the AWS KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS
     *         key ID is the Amazon Resource Name (ARN), the KMS key identifier, or the KMS key alias for the KMS
     *         encryption key. The IAM role used for the snapshot export must have encryption and decryption permissions
     *         to use this KMS key.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The progress status of the export task.
     * </p>
     * 
     * @return The progress status of the export task.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The progress of the snapshot export task as a percentage.
     * </p>
     * 
     * @return The progress of the snapshot export task as a percentage.
     */
    public Integer percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * The total amount of data exported, in gigabytes.
     * </p>
     * 
     * @return The total amount of data exported, in gigabytes.
     */
    public Integer totalExtractedDataInGB() {
        return totalExtractedDataInGB;
    }

    /**
     * <p>
     * The reason the export failed, if it failed.
     * </p>
     * 
     * @return The reason the export failed, if it failed.
     */
    public String failureCause() {
        return failureCause;
    }

    /**
     * <p>
     * A warning about the snapshot export task.
     * </p>
     * 
     * @return A warning about the snapshot export task.
     */
    public String warningMessage() {
        return warningMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportOnly());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(totalExtractedDataInGB());
        hashCode = 31 * hashCode + Objects.hashCode(failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(warningMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskResponse)) {
            return false;
        }
        StartExportTaskResponse other = (StartExportTaskResponse) obj;
        return Objects.equals(exportTaskIdentifier(), other.exportTaskIdentifier())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(exportOnly(), other.exportOnly())
                && Objects.equals(snapshotTime(), other.snapshotTime()) && Objects.equals(taskStartTime(), other.taskStartTime())
                && Objects.equals(taskEndTime(), other.taskEndTime()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3Prefix(), other.s3Prefix()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(status(), other.status())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(totalExtractedDataInGB(), other.totalExtractedDataInGB())
                && Objects.equals(failureCause(), other.failureCause())
                && Objects.equals(warningMessage(), other.warningMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartExportTaskResponse").add("ExportTaskIdentifier", exportTaskIdentifier())
                .add("SourceArn", sourceArn()).add("ExportOnly", exportOnly()).add("SnapshotTime", snapshotTime())
                .add("TaskStartTime", taskStartTime()).add("TaskEndTime", taskEndTime()).add("S3Bucket", s3Bucket())
                .add("S3Prefix", s3Prefix()).add("IamRoleArn", iamRoleArn()).add("KmsKeyId", kmsKeyId()).add("Status", status())
                .add("PercentProgress", percentProgress()).add("TotalExtractedDataInGB", totalExtractedDataInGB())
                .add("FailureCause", failureCause()).add("WarningMessage", warningMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTaskIdentifier":
            return Optional.ofNullable(clazz.cast(exportTaskIdentifier()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "ExportOnly":
            return Optional.ofNullable(clazz.cast(exportOnly()));
        case "SnapshotTime":
            return Optional.ofNullable(clazz.cast(snapshotTime()));
        case "TaskStartTime":
            return Optional.ofNullable(clazz.cast(taskStartTime()));
        case "TaskEndTime":
            return Optional.ofNullable(clazz.cast(taskEndTime()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PercentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "TotalExtractedDataInGB":
            return Optional.ofNullable(clazz.cast(totalExtractedDataInGB()));
        case "FailureCause":
            return Optional.ofNullable(clazz.cast(failureCause()));
        case "WarningMessage":
            return Optional.ofNullable(clazz.cast(warningMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskResponse, T> g) {
        return obj -> g.apply((StartExportTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartExportTaskResponse> {
        /**
         * <p>
         * A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where
         * the snapshot is exported to.
         * </p>
         * 
         * @param exportTaskIdentifier
         *        A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket
         *        where the snapshot is exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskIdentifier(String exportTaskIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The data exported from the snapshot. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>database</code> - Export all the data from a specified database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for
         * RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportOnly
         *        The data exported from the snapshot. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>database</code> - Export all the data from a specified database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid
         *        only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportOnly(Collection<String> exportOnly);

        /**
         * <p>
         * The data exported from the snapshot. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>database</code> - Export all the data from a specified database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for
         * RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is
         * valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportOnly
         *        The data exported from the snapshot. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>database</code> - Export all the data from a specified database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid
         *        only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This
         *        format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportOnly(String... exportOnly);

        /**
         * <p>
         * The time that the snapshot was created.
         * </p>
         * 
         * @param snapshotTime
         *        The time that the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTime(Instant snapshotTime);

        /**
         * <p>
         * The time that the snapshot export task started.
         * </p>
         * 
         * @param taskStartTime
         *        The time that the snapshot export task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartTime(Instant taskStartTime);

        /**
         * <p>
         * The time that the snapshot export task completed.
         * </p>
         * 
         * @param taskEndTime
         *        The time that the snapshot export task completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskEndTime(Instant taskEndTime);

        /**
         * <p>
         * The Amazon S3 bucket that the snapshot is exported to.
         * </p>
         * 
         * @param s3Bucket
         *        The Amazon S3 bucket that the snapshot is exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.
         * </p>
         * 
         * @param s3Prefix
         *        The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.
         * </p>
         * 
         * @param iamRoleArn
         *        The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The ID of the AWS KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key
         * ID is the Amazon Resource Name (ARN), the KMS key identifier, or the KMS key alias for the KMS encryption
         * key. The IAM role used for the snapshot export must have encryption and decryption permissions to use this
         * KMS key.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the AWS KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The
         *        KMS key ID is the Amazon Resource Name (ARN), the KMS key identifier, or the KMS key alias for the KMS
         *        encryption key. The IAM role used for the snapshot export must have encryption and decryption
         *        permissions to use this KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The progress status of the export task.
         * </p>
         * 
         * @param status
         *        The progress status of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The progress of the snapshot export task as a percentage.
         * </p>
         * 
         * @param percentProgress
         *        The progress of the snapshot export task as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(Integer percentProgress);

        /**
         * <p>
         * The total amount of data exported, in gigabytes.
         * </p>
         * 
         * @param totalExtractedDataInGB
         *        The total amount of data exported, in gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalExtractedDataInGB(Integer totalExtractedDataInGB);

        /**
         * <p>
         * The reason the export failed, if it failed.
         * </p>
         * 
         * @param failureCause
         *        The reason the export failed, if it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCause(String failureCause);

        /**
         * <p>
         * A warning about the snapshot export task.
         * </p>
         * 
         * @param warningMessage
         *        A warning about the snapshot export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningMessage(String warningMessage);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String exportTaskIdentifier;

        private String sourceArn;

        private List<String> exportOnly = DefaultSdkAutoConstructList.getInstance();

        private Instant snapshotTime;

        private Instant taskStartTime;

        private Instant taskEndTime;

        private String s3Bucket;

        private String s3Prefix;

        private String iamRoleArn;

        private String kmsKeyId;

        private String status;

        private Integer percentProgress;

        private Integer totalExtractedDataInGB;

        private String failureCause;

        private String warningMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskResponse model) {
            super(model);
            exportTaskIdentifier(model.exportTaskIdentifier);
            sourceArn(model.sourceArn);
            exportOnly(model.exportOnly);
            snapshotTime(model.snapshotTime);
            taskStartTime(model.taskStartTime);
            taskEndTime(model.taskEndTime);
            s3Bucket(model.s3Bucket);
            s3Prefix(model.s3Prefix);
            iamRoleArn(model.iamRoleArn);
            kmsKeyId(model.kmsKeyId);
            status(model.status);
            percentProgress(model.percentProgress);
            totalExtractedDataInGB(model.totalExtractedDataInGB);
            failureCause(model.failureCause);
            warningMessage(model.warningMessage);
        }

        public final String getExportTaskIdentifier() {
            return exportTaskIdentifier;
        }

        @Override
        public final Builder exportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
            return this;
        }

        public final void setExportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final Collection<String> getExportOnly() {
            return exportOnly;
        }

        @Override
        public final Builder exportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportOnly(String... exportOnly) {
            exportOnly(Arrays.asList(exportOnly));
            return this;
        }

        public final void setExportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
        }

        public final Instant getSnapshotTime() {
            return snapshotTime;
        }

        @Override
        public final Builder snapshotTime(Instant snapshotTime) {
            this.snapshotTime = snapshotTime;
            return this;
        }

        public final void setSnapshotTime(Instant snapshotTime) {
            this.snapshotTime = snapshotTime;
        }

        public final Instant getTaskStartTime() {
            return taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final Instant getTaskEndTime() {
            return taskEndTime;
        }

        @Override
        public final Builder taskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
            return this;
        }

        public final void setTaskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPercentProgress() {
            return percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final Integer getTotalExtractedDataInGB() {
            return totalExtractedDataInGB;
        }

        @Override
        public final Builder totalExtractedDataInGB(Integer totalExtractedDataInGB) {
            this.totalExtractedDataInGB = totalExtractedDataInGB;
            return this;
        }

        public final void setTotalExtractedDataInGB(Integer totalExtractedDataInGB) {
            this.totalExtractedDataInGB = totalExtractedDataInGB;
        }

        public final String getFailureCause() {
            return failureCause;
        }

        @Override
        public final Builder failureCause(String failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final void setFailureCause(String failureCause) {
            this.failureCause = failureCause;
        }

        public final String getWarningMessage() {
            return warningMessage;
        }

        @Override
        public final Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public final void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public StartExportTaskResponse build() {
            return new StartExportTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
