/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Shows the scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
 * Serverless</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingConfigurationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingConfigurationInfo.Builder, ScalingConfigurationInfo> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScalingConfigurationInfo::minCapacity)).setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScalingConfigurationInfo::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Boolean> AUTO_PAUSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ScalingConfigurationInfo::autoPause)).setter(setter(Builder::autoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPause").build()).build();

    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScalingConfigurationInfo::secondsUntilAutoPause)).setter(setter(Builder::secondsUntilAutoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build())
            .build();

    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScalingConfigurationInfo::timeoutAction)).setter(setter(Builder::timeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD, AUTO_PAUSE_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD, TIMEOUT_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minCapacity;

    private final Integer maxCapacity;

    private final Boolean autoPause;

    private final Integer secondsUntilAutoPause;

    private final String timeoutAction;

    private ScalingConfigurationInfo(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.autoPause = builder.autoPause;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
        this.timeoutAction = builder.timeoutAction;
    }

    /**
     * <p>
     * The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * 
     * @return The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.
     */
    public Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * 
     * @return The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     */
    public Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * A value that indicates whether automatic pause is allowed for the Aurora DB cluster in <code>serverless</code> DB
     * engine mode.
     * </p>
     * <p>
     * When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.
     * </p>
     * 
     * @return A value that indicates whether automatic pause is allowed for the Aurora DB cluster in
     *         <code>serverless</code> DB engine mode.</p>
     *         <p>
     *         When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.
     */
    public Boolean autoPause() {
        return autoPause;
    }

    /**
     * <p>
     * The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is paused.
     * A DB cluster can be paused only when it's idle (it has no connections).
     * </p>
     * 
     * @return The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is
     *         paused. A DB cluster can be paused only when it's idle (it has no connections).
     */
    public Integer secondsUntilAutoPause() {
        return secondsUntilAutoPause;
    }

    /**
     * <p>
     * The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
     * <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
     * </p>
     * 
     * @return The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
     *         <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
     */
    public String timeoutAction() {
        return timeoutAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(autoPause());
        hashCode = 31 * hashCode + Objects.hashCode(secondsUntilAutoPause());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfigurationInfo)) {
            return false;
        }
        ScalingConfigurationInfo other = (ScalingConfigurationInfo) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(autoPause(), other.autoPause())
                && Objects.equals(secondsUntilAutoPause(), other.secondsUntilAutoPause())
                && Objects.equals(timeoutAction(), other.timeoutAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScalingConfigurationInfo").add("MinCapacity", minCapacity()).add("MaxCapacity", maxCapacity())
                .add("AutoPause", autoPause()).add("SecondsUntilAutoPause", secondsUntilAutoPause())
                .add("TimeoutAction", timeoutAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "AutoPause":
            return Optional.ofNullable(clazz.cast(autoPause()));
        case "SecondsUntilAutoPause":
            return Optional.ofNullable(clazz.cast(secondsUntilAutoPause()));
        case "TimeoutAction":
            return Optional.ofNullable(clazz.cast(timeoutAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfigurationInfo, T> g) {
        return obj -> g.apply((ScalingConfigurationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingConfigurationInfo> {
        /**
         * <p>
         * The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * 
         * @param minCapacity
         *        The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * A value that indicates whether automatic pause is allowed for the Aurora DB cluster in
         * <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.
         * </p>
         * 
         * @param autoPause
         *        A value that indicates whether automatic pause is allowed for the Aurora DB cluster in
         *        <code>serverless</code> DB engine mode.</p>
         *        <p>
         *        When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically
         *        resumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoPause(Boolean autoPause);

        /**
         * <p>
         * The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is
         * paused. A DB cluster can be paused only when it's idle (it has no connections).
         * </p>
         * 
         * @param secondsUntilAutoPause
         *        The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode
         *        is paused. A DB cluster can be paused only when it's idle (it has no connections).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsUntilAutoPause(Integer secondsUntilAutoPause);

        /**
         * <p>
         * The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
         * <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
         * </p>
         * 
         * @param timeoutAction
         *        The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
         *        <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutAction(String timeoutAction);
    }

    static final class BuilderImpl implements Builder {
        private Integer minCapacity;

        private Integer maxCapacity;

        private Boolean autoPause;

        private Integer secondsUntilAutoPause;

        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfigurationInfo model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
            autoPause(model.autoPause);
            secondsUntilAutoPause(model.secondsUntilAutoPause);
            timeoutAction(model.timeoutAction);
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Boolean getAutoPause() {
            return autoPause;
        }

        @Override
        public final Builder autoPause(Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        public final void setAutoPause(Boolean autoPause) {
            this.autoPause = autoPause;
        }

        public final Integer getSecondsUntilAutoPause() {
            return secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        public final String getTimeoutAction() {
            return timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public ScalingConfigurationInfo build() {
            return new ScalingConfigurationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
