/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the scaling configuration of an Aurora Serverless DB cluster.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
 * Serverless</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingConfiguration.Builder, ScalingConfiguration> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScalingConfiguration::minCapacity)).setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScalingConfiguration::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Boolean> AUTO_PAUSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ScalingConfiguration::autoPause)).setter(setter(Builder::autoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPause").build()).build();

    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScalingConfiguration::secondsUntilAutoPause)).setter(setter(Builder::secondsUntilAutoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build())
            .build();

    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScalingConfiguration::timeoutAction)).setter(setter(Builder::timeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD, AUTO_PAUSE_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD, TIMEOUT_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minCapacity;

    private final Integer maxCapacity;

    private final Boolean autoPause;

    private final Integer secondsUntilAutoPause;

    private final String timeoutAction;

    private ScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.autoPause = builder.autoPause;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
        this.timeoutAction = builder.timeoutAction;
    }

    /**
     * <p>
     * The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * <p>
     * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
     * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
     * </p>
     * <p>
     * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>,
     * <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     * </p>
     * <p>
     * The minimum capacity must be less than or equal to the maximum capacity.
     * </p>
     * 
     * @return The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
     *         <p>
     *         For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
     *         <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>
     *         .
     *         </p>
     *         <p>
     *         For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
     *         <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     *         </p>
     *         <p>
     *         The minimum capacity must be less than or equal to the maximum capacity.
     */
    public Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * <p>
     * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
     * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
     * </p>
     * <p>
     * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>,
     * <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     * </p>
     * <p>
     * The maximum capacity must be greater than or equal to the minimum capacity.
     * </p>
     * 
     * @return The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
     *         <p>
     *         For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
     *         <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>
     *         .
     *         </p>
     *         <p>
     *         For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
     *         <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     *         </p>
     *         <p>
     *         The maximum capacity must be greater than or equal to the minimum capacity.
     */
    public Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in
     * <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
     * </p>
     * <note>
     * <p>
     * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this
     * case, the DB cluster is restored when there is a request to connect to it.
     * </p>
     * </note>
     * 
     * @return A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in
     *         <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no
     *         connections).</p> <note>
     *         <p>
     *         If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In
     *         this case, the DB cluster is restored when there is a request to connect to it.
     *         </p>
     */
    public Boolean autoPause() {
        return autoPause;
    }

    /**
     * <p>
     * The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.
     * </p>
     * 
     * @return The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.
     */
    public Integer secondsUntilAutoPause() {
        return secondsUntilAutoPause;
    }

    /**
     * <p>
     * The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
     * <code>RollbackCapacityChange</code>.
     * </p>
     * <p>
     * <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
     * </p>
     * <p>
     * <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found in
     * the timeout period.
     * </p>
     * <important>
     * <p>
     * If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from finding a
     * scaling point might be dropped.
     * </p>
     * </important>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     * > Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
     *         <code>RollbackCapacityChange</code>.</p>
     *         <p>
     *         <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
     *         </p>
     *         <p>
     *         <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't
     *         found in the timeout period.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from
     *         finding a scaling point might be dropped.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     *         > Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public String timeoutAction() {
        return timeoutAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(autoPause());
        hashCode = 31 * hashCode + Objects.hashCode(secondsUntilAutoPause());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfiguration)) {
            return false;
        }
        ScalingConfiguration other = (ScalingConfiguration) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(autoPause(), other.autoPause())
                && Objects.equals(secondsUntilAutoPause(), other.secondsUntilAutoPause())
                && Objects.equals(timeoutAction(), other.timeoutAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScalingConfiguration").add("MinCapacity", minCapacity()).add("MaxCapacity", maxCapacity())
                .add("AutoPause", autoPause()).add("SecondsUntilAutoPause", secondsUntilAutoPause())
                .add("TimeoutAction", timeoutAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "AutoPause":
            return Optional.ofNullable(clazz.cast(autoPause()));
        case "SecondsUntilAutoPause":
            return Optional.ofNullable(clazz.cast(secondsUntilAutoPause()));
        case "TimeoutAction":
            return Optional.ofNullable(clazz.cast(timeoutAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfiguration, T> g) {
        return obj -> g.apply((ScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingConfiguration> {
        /**
         * <p>
         * The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
         * </p>
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         * </p>
         * <p>
         * The minimum capacity must be less than or equal to the maximum capacity.
         * </p>
         * 
         * @param minCapacity
         *        The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
         *        <p>
         *        For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
         *        <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and
         *        <code>256</code>.
         *        </p>
         *        <p>
         *        For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         *        <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         *        </p>
         *        <p>
         *        The minimum capacity must be less than or equal to the maximum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
         * </p>
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         * </p>
         * <p>
         * The maximum capacity must be greater than or equal to the minimum capacity.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
         *        <p>
         *        For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
         *        <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and
         *        <code>256</code>.
         *        </p>
         *        <p>
         *        For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         *        <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         *        </p>
         *        <p>
         *        The maximum capacity must be greater than or equal to the minimum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in
         * <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no
         * connections).
         * </p>
         * <note>
         * <p>
         * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In
         * this case, the DB cluster is restored when there is a request to connect to it.
         * </p>
         * </note>
         * 
         * @param autoPause
         *        A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in
         *        <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no
         *        connections).</p> <note>
         *        <p>
         *        If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot.
         *        In this case, the DB cluster is restored when there is a request to connect to it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoPause(Boolean autoPause);

        /**
         * <p>
         * The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.
         * </p>
         * 
         * @param secondsUntilAutoPause
         *        The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsUntilAutoPause(Integer secondsUntilAutoPause);

        /**
         * <p>
         * The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
         * <code>RollbackCapacityChange</code>.
         * </p>
         * <p>
         * <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
         * </p>
         * <p>
         * <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found
         * in the timeout period.
         * </p>
         * <important>
         * <p>
         * If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from finding
         * a scaling point might be dropped.
         * </p>
         * </important>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
         * > Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param timeoutAction
         *        The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
         *        <code>RollbackCapacityChange</code>.</p>
         *        <p>
         *        <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
         *        </p>
         *        <p>
         *        <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't
         *        found in the timeout period.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from
         *        finding a scaling point might be dropped.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
         *        > Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutAction(String timeoutAction);
    }

    static final class BuilderImpl implements Builder {
        private Integer minCapacity;

        private Integer maxCapacity;

        private Boolean autoPause;

        private Integer secondsUntilAutoPause;

        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfiguration model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
            autoPause(model.autoPause);
            secondsUntilAutoPause(model.secondsUntilAutoPause);
            timeoutAction(model.timeoutAction);
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Boolean getAutoPause() {
            return autoPause;
        }

        @Override
        public final Builder autoPause(Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        public final void setAutoPause(Boolean autoPause) {
            this.autoPause = autoPause;
        }

        public final Integer getSecondsUntilAutoPause() {
            return secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        public final String getTimeoutAction() {
            return timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public ScalingConfiguration build() {
            return new ScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
