/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the pending maintenance actions for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePendingMaintenanceActions implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcePendingMaintenanceActions.Builder, ResourcePendingMaintenanceActions> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourcePendingMaintenanceActions::resourceIdentifier)).setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<List<PendingMaintenanceAction>> PENDING_MAINTENANCE_ACTION_DETAILS_FIELD = SdkField
            .<List<PendingMaintenanceAction>> builder(MarshallingType.LIST)
            .getter(getter(ResourcePendingMaintenanceActions::pendingMaintenanceActionDetails))
            .setter(setter(Builder::pendingMaintenanceActionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenanceActionDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PendingMaintenanceAction")
                            .memberFieldInfo(
                                    SdkField.<PendingMaintenanceAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingMaintenanceAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PendingMaintenanceAction").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            PENDING_MAINTENANCE_ACTION_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceIdentifier;

    private final List<PendingMaintenanceAction> pendingMaintenanceActionDetails;

    private ResourcePendingMaintenanceActions(BuilderImpl builder) {
        this.resourceIdentifier = builder.resourceIdentifier;
        this.pendingMaintenanceActionDetails = builder.pendingMaintenanceActionDetails;
    }

    /**
     * <p>
     * The ARN of the resource that has pending maintenance actions.
     * </p>
     * 
     * @return The ARN of the resource that has pending maintenance actions.
     */
    public String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * Returns true if the PendingMaintenanceActionDetails property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasPendingMaintenanceActionDetails() {
        return pendingMaintenanceActionDetails != null && !(pendingMaintenanceActionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that provides details about the pending maintenance actions for the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPendingMaintenanceActionDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that provides details about the pending maintenance actions for the resource.
     */
    public List<PendingMaintenanceAction> pendingMaintenanceActionDetails() {
        return pendingMaintenanceActionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(pendingMaintenanceActionDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePendingMaintenanceActions)) {
            return false;
        }
        ResourcePendingMaintenanceActions other = (ResourcePendingMaintenanceActions) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(pendingMaintenanceActionDetails(), other.pendingMaintenanceActionDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourcePendingMaintenanceActions").add("ResourceIdentifier", resourceIdentifier())
                .add("PendingMaintenanceActionDetails", pendingMaintenanceActionDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "PendingMaintenanceActionDetails":
            return Optional.ofNullable(clazz.cast(pendingMaintenanceActionDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePendingMaintenanceActions, T> g) {
        return obj -> g.apply((ResourcePendingMaintenanceActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePendingMaintenanceActions> {
        /**
         * <p>
         * The ARN of the resource that has pending maintenance actions.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ARN of the resource that has pending maintenance actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * A list that provides details about the pending maintenance actions for the resource.
         * </p>
         * 
         * @param pendingMaintenanceActionDetails
         *        A list that provides details about the pending maintenance actions for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> pendingMaintenanceActionDetails);

        /**
         * <p>
         * A list that provides details about the pending maintenance actions for the resource.
         * </p>
         * 
         * @param pendingMaintenanceActionDetails
         *        A list that provides details about the pending maintenance actions for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenanceActionDetails(PendingMaintenanceAction... pendingMaintenanceActionDetails);

        /**
         * <p>
         * A list that provides details about the pending maintenance actions for the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PendingMaintenanceAction>.Builder} avoiding
         * the need to create one manually via {@link List<PendingMaintenanceAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PendingMaintenanceAction>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #pendingMaintenanceActionDetails(List<PendingMaintenanceAction>)}.
         * 
         * @param pendingMaintenanceActionDetails
         *        a consumer that will call methods on {@link List<PendingMaintenanceAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingMaintenanceActionDetails(List<PendingMaintenanceAction>)
         */
        Builder pendingMaintenanceActionDetails(Consumer<PendingMaintenanceAction.Builder>... pendingMaintenanceActionDetails);
    }

    static final class BuilderImpl implements Builder {
        private String resourceIdentifier;

        private List<PendingMaintenanceAction> pendingMaintenanceActionDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePendingMaintenanceActions model) {
            resourceIdentifier(model.resourceIdentifier);
            pendingMaintenanceActionDetails(model.pendingMaintenanceActionDetails);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public final Collection<PendingMaintenanceAction.Builder> getPendingMaintenanceActionDetails() {
            return pendingMaintenanceActionDetails != null ? pendingMaintenanceActionDetails.stream()
                    .map(PendingMaintenanceAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier.copy(pendingMaintenanceActionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(PendingMaintenanceAction... pendingMaintenanceActionDetails) {
            pendingMaintenanceActionDetails(Arrays.asList(pendingMaintenanceActionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(
                Consumer<PendingMaintenanceAction.Builder>... pendingMaintenanceActionDetails) {
            pendingMaintenanceActionDetails(Stream.of(pendingMaintenanceActionDetails)
                    .map(c -> PendingMaintenanceAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingMaintenanceActionDetails(
                Collection<PendingMaintenanceAction.BuilderImpl> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier
                    .copyFromBuilder(pendingMaintenanceActionDetails);
        }

        @Override
        public ResourcePendingMaintenanceActions build() {
            return new ResourcePendingMaintenanceActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
