/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterDbProxyTargetsRequest extends RdsRequest implements
        ToCopyableBuilder<RegisterDbProxyTargetsRequest.Builder, RegisterDbProxyTargetsRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterDbProxyTargetsRequest::dbProxyName)).setter(setter(Builder::dbProxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()).build();

    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterDbProxyTargetsRequest::targetGroupName)).setter(setter(Builder::targetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()).build();

    private static final SdkField<List<String>> DB_INSTANCE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RegisterDbProxyTargetsRequest::dbInstanceIdentifiers))
            .setter(setter(Builder::dbInstanceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DB_CLUSTER_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RegisterDbProxyTargetsRequest::dbClusterIdentifiers))
            .setter(setter(Builder::dbClusterIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD,
            TARGET_GROUP_NAME_FIELD, DB_INSTANCE_IDENTIFIERS_FIELD, DB_CLUSTER_IDENTIFIERS_FIELD));

    private final String dbProxyName;

    private final String targetGroupName;

    private final List<String> dbInstanceIdentifiers;

    private final List<String> dbClusterIdentifiers;

    private RegisterDbProxyTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.targetGroupName = builder.targetGroupName;
        this.dbInstanceIdentifiers = builder.dbInstanceIdentifiers;
        this.dbClusterIdentifiers = builder.dbClusterIdentifiers;
    }

    /**
     * <p>
     * The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.
     * </p>
     * 
     * @return The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.
     */
    public String dbProxyName() {
        return dbProxyName;
    }

    /**
     * <p>
     * The identifier of the <code>DBProxyTargetGroup</code>.
     * </p>
     * 
     * @return The identifier of the <code>DBProxyTargetGroup</code>.
     */
    public String targetGroupName() {
        return targetGroupName;
    }

    /**
     * Returns true if the DBInstanceIdentifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDbInstanceIdentifiers() {
        return dbInstanceIdentifiers != null && !(dbInstanceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more DB instance identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbInstanceIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more DB instance identifiers.
     */
    public List<String> dbInstanceIdentifiers() {
        return dbInstanceIdentifiers;
    }

    /**
     * Returns true if the DBClusterIdentifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDbClusterIdentifiers() {
        return dbClusterIdentifiers != null && !(dbClusterIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more DB cluster identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbClusterIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more DB cluster identifiers.
     */
    public List<String> dbClusterIdentifiers() {
        return dbClusterIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifiers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDbProxyTargetsRequest)) {
            return false;
        }
        RegisterDbProxyTargetsRequest other = (RegisterDbProxyTargetsRequest) obj;
        return Objects.equals(dbProxyName(), other.dbProxyName()) && Objects.equals(targetGroupName(), other.targetGroupName())
                && Objects.equals(dbInstanceIdentifiers(), other.dbInstanceIdentifiers())
                && Objects.equals(dbClusterIdentifiers(), other.dbClusterIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterDbProxyTargetsRequest").add("DBProxyName", dbProxyName())
                .add("TargetGroupName", targetGroupName()).add("DBInstanceIdentifiers", dbInstanceIdentifiers())
                .add("DBClusterIdentifiers", dbClusterIdentifiers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyName":
            return Optional.ofNullable(clazz.cast(dbProxyName()));
        case "TargetGroupName":
            return Optional.ofNullable(clazz.cast(targetGroupName()));
        case "DBInstanceIdentifiers":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifiers()));
        case "DBClusterIdentifiers":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterDbProxyTargetsRequest, T> g) {
        return obj -> g.apply((RegisterDbProxyTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterDbProxyTargetsRequest> {
        /**
         * <p>
         * The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.
         * </p>
         * 
         * @param dbProxyName
         *        The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyName(String dbProxyName);

        /**
         * <p>
         * The identifier of the <code>DBProxyTargetGroup</code>.
         * </p>
         * 
         * @param targetGroupName
         *        The identifier of the <code>DBProxyTargetGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupName(String targetGroupName);

        /**
         * <p>
         * One or more DB instance identifiers.
         * </p>
         * 
         * @param dbInstanceIdentifiers
         *        One or more DB instance identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifiers(Collection<String> dbInstanceIdentifiers);

        /**
         * <p>
         * One or more DB instance identifiers.
         * </p>
         * 
         * @param dbInstanceIdentifiers
         *        One or more DB instance identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifiers(String... dbInstanceIdentifiers);

        /**
         * <p>
         * One or more DB cluster identifiers.
         * </p>
         * 
         * @param dbClusterIdentifiers
         *        One or more DB cluster identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifiers(Collection<String> dbClusterIdentifiers);

        /**
         * <p>
         * One or more DB cluster identifiers.
         * </p>
         * 
         * @param dbClusterIdentifiers
         *        One or more DB cluster identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifiers(String... dbClusterIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbProxyName;

        private String targetGroupName;

        private List<String> dbInstanceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> dbClusterIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDbProxyTargetsRequest model) {
            super(model);
            dbProxyName(model.dbProxyName);
            targetGroupName(model.targetGroupName);
            dbInstanceIdentifiers(model.dbInstanceIdentifiers);
            dbClusterIdentifiers(model.dbClusterIdentifiers);
        }

        public final String getDbProxyName() {
            return dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        public final String getTargetGroupName() {
            return targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        public final Collection<String> getDbInstanceIdentifiers() {
            return dbInstanceIdentifiers;
        }

        @Override
        public final Builder dbInstanceIdentifiers(Collection<String> dbInstanceIdentifiers) {
            this.dbInstanceIdentifiers = StringListCopier.copy(dbInstanceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceIdentifiers(String... dbInstanceIdentifiers) {
            dbInstanceIdentifiers(Arrays.asList(dbInstanceIdentifiers));
            return this;
        }

        public final void setDbInstanceIdentifiers(Collection<String> dbInstanceIdentifiers) {
            this.dbInstanceIdentifiers = StringListCopier.copy(dbInstanceIdentifiers);
        }

        public final Collection<String> getDbClusterIdentifiers() {
            return dbClusterIdentifiers;
        }

        @Override
        public final Builder dbClusterIdentifiers(Collection<String> dbClusterIdentifiers) {
            this.dbClusterIdentifiers = StringListCopier.copy(dbClusterIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterIdentifiers(String... dbClusterIdentifiers) {
            dbClusterIdentifiers(Arrays.asList(dbClusterIdentifiers));
            return this;
        }

        public final void setDbClusterIdentifiers(Collection<String> dbClusterIdentifiers) {
            this.dbClusterIdentifiers = StringListCopier.copy(dbClusterIdentifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterDbProxyTargetsRequest build() {
            return new RegisterDbProxyTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
