/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedDbInstancesOfferingRequest extends RdsRequest implements
        ToCopyableBuilder<PurchaseReservedDbInstancesOfferingRequest.Builder, PurchaseReservedDbInstancesOfferingRequest> {
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseReservedDbInstancesOfferingRequest::reservedDBInstancesOfferingId))
            .setter(setter(Builder::reservedDBInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId")
                    .build()).build();

    private static final SdkField<String> RESERVED_DB_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseReservedDbInstancesOfferingRequest::reservedDBInstanceId))
            .setter(setter(Builder::reservedDBInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceId").build())
            .build();

    private static final SdkField<Integer> DB_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PurchaseReservedDbInstancesOfferingRequest::dbInstanceCount)).setter(setter(Builder::dbInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceCount").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(PurchaseReservedDbInstancesOfferingRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, RESERVED_DB_INSTANCE_ID_FIELD, DB_INSTANCE_COUNT_FIELD, TAGS_FIELD));

    private final String reservedDBInstancesOfferingId;

    private final String reservedDBInstanceId;

    private final Integer dbInstanceCount;

    private final List<Tag> tags;

    private PurchaseReservedDbInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Reserved DB instance offering to purchase.
     * </p>
     * <p>
     * Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
     * </p>
     * 
     * @return The ID of the Reserved DB instance offering to purchase.</p>
     *         <p>
     *         Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
     */
    public String reservedDBInstancesOfferingId() {
        return reservedDBInstancesOfferingId;
    }

    /**
     * <p>
     * Customer-specified identifier to track this reservation.
     * </p>
     * <p>
     * Example: myreservationID
     * </p>
     * 
     * @return Customer-specified identifier to track this reservation.</p>
     *         <p>
     *         Example: myreservationID
     */
    public String reservedDBInstanceId() {
        return reservedDBInstanceId;
    }

    /**
     * <p>
     * The number of instances to reserve.
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * 
     * @return The number of instances to reserve.</p>
     *         <p>
     *         Default: <code>1</code>
     */
    public Integer dbInstanceCount() {
        return dbInstanceCount;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedDbInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedDbInstancesOfferingRequest other = (PurchaseReservedDbInstancesOfferingRequest) obj;
        return Objects.equals(reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId())
                && Objects.equals(reservedDBInstanceId(), other.reservedDBInstanceId())
                && Objects.equals(dbInstanceCount(), other.dbInstanceCount()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PurchaseReservedDbInstancesOfferingRequest")
                .add("ReservedDBInstancesOfferingId", reservedDBInstancesOfferingId())
                .add("ReservedDBInstanceId", reservedDBInstanceId()).add("DBInstanceCount", dbInstanceCount())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedDBInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedDBInstancesOfferingId()));
        case "ReservedDBInstanceId":
            return Optional.ofNullable(clazz.cast(reservedDBInstanceId()));
        case "DBInstanceCount":
            return Optional.ofNullable(clazz.cast(dbInstanceCount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedDbInstancesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedDbInstancesOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedDbInstancesOfferingRequest> {
        /**
         * <p>
         * The ID of the Reserved DB instance offering to purchase.
         * </p>
         * <p>
         * Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
         * </p>
         * 
         * @param reservedDBInstancesOfferingId
         *        The ID of the Reserved DB instance offering to purchase.</p>
         *        <p>
         *        Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId);

        /**
         * <p>
         * Customer-specified identifier to track this reservation.
         * </p>
         * <p>
         * Example: myreservationID
         * </p>
         * 
         * @param reservedDBInstanceId
         *        Customer-specified identifier to track this reservation.</p>
         *        <p>
         *        Example: myreservationID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstanceId(String reservedDBInstanceId);

        /**
         * <p>
         * The number of instances to reserve.
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * 
         * @param dbInstanceCount
         *        The number of instances to reserve.</p>
         *        <p>
         *        Default: <code>1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceCount(Integer dbInstanceCount);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String reservedDBInstancesOfferingId;

        private String reservedDBInstanceId;

        private Integer dbInstanceCount;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedDbInstancesOfferingRequest model) {
            super(model);
            reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            reservedDBInstanceId(model.reservedDBInstanceId);
            dbInstanceCount(model.dbInstanceCount);
            tags(model.tags);
        }

        public final String getReservedDBInstancesOfferingId() {
            return reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getReservedDBInstanceId() {
            return reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final Integer getDbInstanceCount() {
            return dbInstanceCount;
        }

        @Override
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final void setDbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedDbInstancesOfferingRequest build() {
            return new PurchaseReservedDbInstancesOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
