/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Option settings are the actual settings being applied or configured for that option. It is used when you modify an
 * option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called
 * SQLNET.ENCRYPTION_SERVER that can have several different values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionSetting implements SdkPojo, Serializable, ToCopyableBuilder<OptionSetting.Builder, OptionSetting> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSetting::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSetting::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSetting::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSetting::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> APPLY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSetting::applyType)).setter(setter(Builder::applyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyType").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSetting::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()).build();

    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSetting::allowedValues)).setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()).build();

    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(OptionSetting::isModifiable)).setter(setter(Builder::isModifiable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()).build();

    private static final SdkField<Boolean> IS_COLLECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(OptionSetting::isCollection)).setter(setter(Builder::isCollection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsCollection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, APPLY_TYPE_FIELD, DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD, IS_MODIFIABLE_FIELD,
            IS_COLLECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private final String defaultValue;

    private final String description;

    private final String applyType;

    private final String dataType;

    private final String allowedValues;

    private final Boolean isModifiable;

    private final Boolean isCollection;

    private OptionSetting(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.applyType = builder.applyType;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.isCollection = builder.isCollection;
    }

    /**
     * <p>
     * The name of the option that has settings that you can set.
     * </p>
     * 
     * @return The name of the option that has settings that you can set.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current value of the option setting.
     * </p>
     * 
     * @return The current value of the option setting.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The default value of the option setting.
     * </p>
     * 
     * @return The default value of the option setting.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The description of the option setting.
     * </p>
     * 
     * @return The description of the option setting.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The DB engine specific parameter type.
     * </p>
     * 
     * @return The DB engine specific parameter type.
     */
    public String applyType() {
        return applyType;
    }

    /**
     * <p>
     * The data type of the option setting.
     * </p>
     * 
     * @return The data type of the option setting.
     */
    public String dataType() {
        return dataType;
    }

    /**
     * <p>
     * The allowed values of the option setting.
     * </p>
     * 
     * @return The allowed values of the option setting.
     */
    public String allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * A Boolean value that, when true, indicates the option setting can be modified from the default.
     * </p>
     * 
     * @return A Boolean value that, when true, indicates the option setting can be modified from the default.
     */
    public Boolean isModifiable() {
        return isModifiable;
    }

    /**
     * <p>
     * Indicates if the option setting is part of a collection.
     * </p>
     * 
     * @return Indicates if the option setting is part of a collection.
     */
    public Boolean isCollection() {
        return isCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(applyType());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(isCollection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionSetting)) {
            return false;
        }
        OptionSetting other = (OptionSetting) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(description(), other.description())
                && Objects.equals(applyType(), other.applyType()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(allowedValues(), other.allowedValues()) && Objects.equals(isModifiable(), other.isModifiable())
                && Objects.equals(isCollection(), other.isCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OptionSetting").add("Name", name()).add("Value", value()).add("DefaultValue", defaultValue())
                .add("Description", description()).add("ApplyType", applyType()).add("DataType", dataType())
                .add("AllowedValues", allowedValues()).add("IsModifiable", isModifiable()).add("IsCollection", isCollection())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ApplyType":
            return Optional.ofNullable(clazz.cast(applyType()));
        case "DataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "IsModifiable":
            return Optional.ofNullable(clazz.cast(isModifiable()));
        case "IsCollection":
            return Optional.ofNullable(clazz.cast(isCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionSetting, T> g) {
        return obj -> g.apply((OptionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionSetting> {
        /**
         * <p>
         * The name of the option that has settings that you can set.
         * </p>
         * 
         * @param name
         *        The name of the option that has settings that you can set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current value of the option setting.
         * </p>
         * 
         * @param value
         *        The current value of the option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The default value of the option setting.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The description of the option setting.
         * </p>
         * 
         * @param description
         *        The description of the option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The DB engine specific parameter type.
         * </p>
         * 
         * @param applyType
         *        The DB engine specific parameter type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyType(String applyType);

        /**
         * <p>
         * The data type of the option setting.
         * </p>
         * 
         * @param dataType
         *        The data type of the option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The allowed values of the option setting.
         * </p>
         * 
         * @param allowedValues
         *        The allowed values of the option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String allowedValues);

        /**
         * <p>
         * A Boolean value that, when true, indicates the option setting can be modified from the default.
         * </p>
         * 
         * @param isModifiable
         *        A Boolean value that, when true, indicates the option setting can be modified from the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isModifiable(Boolean isModifiable);

        /**
         * <p>
         * Indicates if the option setting is part of a collection.
         * </p>
         * 
         * @param isCollection
         *        Indicates if the option setting is part of a collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCollection(Boolean isCollection);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private String defaultValue;

        private String description;

        private String applyType;

        private String dataType;

        private String allowedValues;

        private Boolean isModifiable;

        private Boolean isCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionSetting model) {
            name(model.name);
            value(model.value);
            defaultValue(model.defaultValue);
            description(model.description);
            applyType(model.applyType);
            dataType(model.dataType);
            allowedValues(model.allowedValues);
            isModifiable(model.isModifiable);
            isCollection(model.isCollection);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getApplyType() {
            return applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final Boolean getIsModifiable() {
            return isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final Boolean getIsCollection() {
            return isCollection;
        }

        @Override
        public final Builder isCollection(Boolean isCollection) {
            this.isCollection = isCollection;
            return this;
        }

        public final void setIsCollection(Boolean isCollection) {
            this.isCollection = isCollection;
        }

        @Override
        public OptionSetting build() {
            return new OptionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
