/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbClusterRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbClusterRequest.Builder, ModifyDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::dbClusterIdentifier)).setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> NEW_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::newDBClusterIdentifier)).setter(setter(Builder::newDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyDbClusterRequest::applyImmediately)).setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyDbClusterRequest::backupRetentionPeriod)).setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyDbClusterRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyDbClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::masterUserPassword)).setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::optionGroupName)).setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::preferredBackupWindow)).setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyDbClusterRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ModifyDbClusterRequest::backtrackWindow)).setter(setter(Builder::backtrackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()).build();

    private static final SdkField<CloudwatchLogsExportConfiguration> CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD = SdkField
            .<CloudwatchLogsExportConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyDbClusterRequest::cloudwatchLogsExportConfiguration))
            .setter(setter(Builder::cloudwatchLogsExportConfiguration))
            .constructor(CloudwatchLogsExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsExportConfiguration")
                    .build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(ModifyDbClusterRequest::allowMajorVersionUpgrade))
            .setter(setter(Builder::allowMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::dbInstanceParameterGroupName))
            .setter(setter(Builder::dbInstanceParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceParameterGroupName")
                    .build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDbClusterRequest::domainIAMRoleName)).setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyDbClusterRequest::scalingConfiguration)).setter(setter(Builder::scalingConfiguration))
            .constructor(ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyDbClusterRequest::deletionProtection)).setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Boolean> ENABLE_HTTP_ENDPOINT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyDbClusterRequest::enableHttpEndpoint)).setter(setter(Builder::enableHttpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHttpEndpoint").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyDbClusterRequest::copyTagsToSnapshot)).setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            NEW_DB_CLUSTER_IDENTIFIER_FIELD, APPLY_IMMEDIATELY_FIELD, BACKUP_RETENTION_PERIOD_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, PORT_FIELD, MASTER_USER_PASSWORD_FIELD,
            OPTION_GROUP_NAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD, CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD,
            ENGINE_VERSION_FIELD, ALLOW_MAJOR_VERSION_UPGRADE_FIELD, DB_INSTANCE_PARAMETER_GROUP_NAME_FIELD, DOMAIN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD, SCALING_CONFIGURATION_FIELD, DELETION_PROTECTION_FIELD, ENABLE_HTTP_ENDPOINT_FIELD,
            COPY_TAGS_TO_SNAPSHOT_FIELD));

    private final String dbClusterIdentifier;

    private final String newDBClusterIdentifier;

    private final Boolean applyImmediately;

    private final Integer backupRetentionPeriod;

    private final String dbClusterParameterGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final Integer port;

    private final String masterUserPassword;

    private final String optionGroupName;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Long backtrackWindow;

    private final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

    private final String engineVersion;

    private final Boolean allowMajorVersionUpgrade;

    private final String dbInstanceParameterGroupName;

    private final String domain;

    private final String domainIAMRoleName;

    private final ScalingConfiguration scalingConfiguration;

    private final Boolean deletionProtection;

    private final Boolean enableHttpEndpoint;

    private final Boolean copyTagsToSnapshot;

    private ModifyDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.newDBClusterIdentifier = builder.newDBClusterIdentifier;
        this.applyImmediately = builder.applyImmediately;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.port = builder.port;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.cloudwatchLogsExportConfiguration = builder.cloudwatchLogsExportConfiguration;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.dbInstanceParameterGroupName = builder.dbInstanceParameterGroupName;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.deletionProtection = builder.deletionProtection;
        this.enableHttpEndpoint = builder.enableHttpEndpoint;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
    }

    /**
     * <p>
     * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints: This identifier must match the identifier of an existing DB cluster.
     * </p>
     * 
     * @return The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints: This identifier must match the identifier of an existing DB cluster.
     */
    public String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase
     * string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster2</code>
     * </p>
     * 
     * @return The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
     *         lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster2</code>
     */
    public String newDBClusterIdentifier() {
        return newDBClusterIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether the modifications in this request and any pending modifications are asynchronously
     * applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB
     * cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.
     * </p>
     * <p>
     * The <code>ApplyImmediately</code> parameter only affects the <code>EnableIAMDatabaseAuthentication</code>,
     * <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values. If the
     * <code>ApplyImmediately</code> parameter is disabled, then changes to the
     * <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and
     * <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes are
     * applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.
     * </p>
     * <p>
     * By default, this parameter is disabled.
     * </p>
     * 
     * @return A value that indicates whether the modifications in this request and any pending modifications are
     *         asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
     *         setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during
     *         the next maintenance window.</p>
     *         <p>
     *         The <code>ApplyImmediately</code> parameter only affects the <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values. If the
     *         <code>ApplyImmediately</code> parameter is disabled, then changes to the
     *         <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and
     *         <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other
     *         changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.
     *         </p>
     *         <p>
     *         By default, this parameter is disabled.
     */
    public Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained. You must specify a minimum value of 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a value from 1 to 35
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days for which automated backups are retained. You must specify a minimum value of 1.</p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a value from 1 to 35
     *         </p>
     *         </li>
     */
    public Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to use for the DB cluster.
     * </p>
     * 
     * @return The name of the DB cluster parameter group to use for the DB cluster.
     */
    public String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the DB cluster will belong to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VPC security groups that the DB cluster will belong to.
     */
    public List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The port number on which the DB cluster accepts connections.
     * </p>
     * <p>
     * Constraints: Value must be <code>1150-65535</code>
     * </p>
     * <p>
     * Default: The same port as the original DB cluster.
     * </p>
     * 
     * @return The port number on which the DB cluster accepts connections.</p>
     *         <p>
     *         Constraints: Value must be <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default: The same port as the original DB cluster.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The new password for the master database user. This password can contain any printable ASCII character except
     * "/", """, or "@".
     * </p>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * </p>
     * 
     * @return The new password for the master database user. This password can contain any printable ASCII character
     *         except "/", """, or "@".</p>
     *         <p>
     *         Constraints: Must contain from 8 to 41 characters.
     */
    public String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * A value that indicates that the DB cluster should be associated with the specified option group. Changing this
     * parameter doesn't result in an outage except in the following case, and the change is applied during the next
     * maintenance window unless the <code>ApplyImmediately</code> is enabled for this request. If the parameter change
     * results in an option group that enables OEM, this change can cause a brief (sub-second) period during which new
     * connections are rejected but existing connections are not interrupted.
     * </p>
     * <p>
     * Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once
     * it is associated with a DB cluster.
     * </p>
     * 
     * @return A value that indicates that the DB cluster should be associated with the specified option group. Changing
     *         this parameter doesn't result in an outage except in the following case, and the change is applied during
     *         the next maintenance window unless the <code>ApplyImmediately</code> is enabled for this request. If the
     *         parameter change results in an option group that enables OEM, this change can cause a brief (sub-second)
     *         period during which new connections are rejected but existing connections are not interrupted. </p>
     *         <p>
     *         Permanent options can't be removed from an option group. The option group can't be removed from a DB
     *         cluster once it is associated with a DB cluster.
     */
    public String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, using the
     * <code>BackupRetentionPeriod</code> parameter.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the
     * time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, using
     *         the <code>BackupRetentionPeriod</code> parameter. </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To
     *         see the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     *         > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week. To see the time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * <p>
     * Constraints: Minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *         occurring on a random day of the week. To see the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     *         > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         <p>
     *         Constraints: Minimum 30-minute window.
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database
     * accounts. By default, mapping is disabled.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * 
     * @return A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to
     *         database accounts. By default, mapping is disabled.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
     *         Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>
     */
    public Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
     *         <p>
     *         Default: 0
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *         </p>
     *         </li>
     */
    public Long backtrackWindow() {
        return backtrackWindow;
    }

    /**
     * <p>
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     * cluster.
     * </p>
     * 
     * @return The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     *         cluster.
     */
    public CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration() {
        return cloudwatchLogsExportConfiguration;
    }

    /**
     * <p>
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
     * outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the
     * following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use
     * the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * 
     * @return The version number of the database engine to which you want to upgrade. Changing this parameter results
     *         in an outage. The change is applied during the next maintenance window unless
     *         <code>ApplyImmediately</code> is enabled.</p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora),
     *         use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible
     *         Aurora), use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for <code>aurora-postgresql</code>, use the following
     *         command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * A value that indicates whether major version upgrades are allowed.
     * </p>
     * <p>
     * Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code>
     * parameter that is a different major version than the DB cluster's current version.
     * </p>
     * 
     * @return A value that indicates whether major version upgrades are allowed.</p>
     *         <p>
     *         Constraints: You must allow major version upgrades when specifying a value for the
     *         <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current
     *         version.
     */
    public Boolean allowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    /**
     * <p>
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     * </p>
     * <note>
     * <p>
     * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster
     * isn't rebooted automatically. Also, parameter changes aren't applied during the next maintenance window but
     * instead are applied immediately.
     * </p>
     * </note>
     * <p>
     * Default: The existing name setting
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB parameter group must be in the same DB parameter group family as this DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the
     * <code>AllowMajorVersionUpgrade</code> parameter.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB parameter group to apply to all instances of the DB cluster. </p> <note>
     *         <p>
     *         When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB
     *         cluster isn't rebooted automatically. Also, parameter changes aren't applied during the next maintenance
     *         window but instead are applied immediately.
     *         </p>
     *         </note>
     *         <p>
     *         Default: The existing name setting
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The DB parameter group must be in the same DB parameter group family as this DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the
     *         <code>AllowMajorVersionUpgrade</code> parameter.
     *         </p>
     *         </li>
     */
    public String dbInstanceParameterGroupName() {
        return dbInstanceParameterGroupName;
    }

    /**
     * <p>
     * The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the cluster from
     * its current domain. The domain must be created prior to this operation.
     * </p>
     * 
     * @return The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the
     *         cluster from its current domain. The domain must be created prior to this operation.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     * 
     * @return Specify the name of the IAM role to be used when making API calls to the Directory Service.
     */
    public String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
     * <code>serverless</code> DB engine mode.
     * </p>
     * 
     * @return The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
     *         <code>serverless</code> DB engine mode.
     */
    public ScalingConfiguration scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * <p>
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when
     * deletion protection is enabled. By default, deletion protection is disabled.
     * </p>
     * 
     * @return A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
     *         deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    public Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the
     * HTTP endpoint is disabled.
     * </p>
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora
     * Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora
     * Serverless</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By
     *         default, the HTTP endpoint is disabled.</p>
     *         <p>
     *         When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the
     *         Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query
     *         editor.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for
     *         Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public Boolean enableHttpEndpoint() {
        return enableHttpEndpoint;
    }

    /**
     * <p>
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default
     * is not to copy them.
     * </p>
     * 
     * @return A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The
     *         default is not to copy them.
     */
    public Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogsExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(enableHttpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterRequest)) {
            return false;
        }
        ModifyDbClusterRequest other = (ModifyDbClusterRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(newDBClusterIdentifier(), other.newDBClusterIdentifier())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(port(), other.port())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(backtrackWindow(), other.backtrackWindow())
                && Objects.equals(cloudwatchLogsExportConfiguration(), other.cloudwatchLogsExportConfiguration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade())
                && Objects.equals(dbInstanceParameterGroupName(), other.dbInstanceParameterGroupName())
                && Objects.equals(domain(), other.domain()) && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(enableHttpEndpoint(), other.enableHttpEndpoint())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyDbClusterRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("NewDBClusterIdentifier", newDBClusterIdentifier()).add("ApplyImmediately", applyImmediately())
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("VpcSecurityGroupIds", vpcSecurityGroupIds()).add("Port", port())
                .add("MasterUserPassword", masterUserPassword()).add("OptionGroupName", optionGroupName())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("BacktrackWindow", backtrackWindow())
                .add("CloudwatchLogsExportConfiguration", cloudwatchLogsExportConfiguration())
                .add("EngineVersion", engineVersion()).add("AllowMajorVersionUpgrade", allowMajorVersionUpgrade())
                .add("DBInstanceParameterGroupName", dbInstanceParameterGroupName()).add("Domain", domain())
                .add("DomainIAMRoleName", domainIAMRoleName()).add("ScalingConfiguration", scalingConfiguration())
                .add("DeletionProtection", deletionProtection()).add("EnableHttpEndpoint", enableHttpEndpoint())
                .add("CopyTagsToSnapshot", copyTagsToSnapshot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "NewDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(newDBClusterIdentifier()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "BacktrackWindow":
            return Optional.ofNullable(clazz.cast(backtrackWindow()));
        case "CloudwatchLogsExportConfiguration":
            return Optional.ofNullable(clazz.cast(cloudwatchLogsExportConfiguration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AllowMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpgrade()));
        case "DBInstanceParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbInstanceParameterGroupName()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "EnableHttpEndpoint":
            return Optional.ofNullable(clazz.cast(enableHttpEndpoint()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbClusterRequest> {
        /**
         * <p>
         * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints: This identifier must match the identifier of an existing DB cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
         *        <p>
         *        Constraints: This identifier must match the identifier of an existing DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
         * lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster2</code>
         * </p>
         * 
         * @param newDBClusterIdentifier
         *        The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
         *        lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBClusterIdentifier(String newDBClusterIdentifier);

        /**
         * <p>
         * A value that indicates whether the modifications in this request and any pending modifications are
         * asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting
         * for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next
         * maintenance window.
         * </p>
         * <p>
         * The <code>ApplyImmediately</code> parameter only affects the <code>EnableIAMDatabaseAuthentication</code>,
         * <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values. If the
         * <code>ApplyImmediately</code> parameter is disabled, then changes to the
         * <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and
         * <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes
         * are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.
         * </p>
         * <p>
         * By default, this parameter is disabled.
         * </p>
         * 
         * @param applyImmediately
         *        A value that indicates whether the modifications in this request and any pending modifications are
         *        asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
         *        setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied
         *        during the next maintenance window.</p>
         *        <p>
         *        The <code>ApplyImmediately</code> parameter only affects the
         *        <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and
         *        <code>NewDBClusterIdentifier</code> values. If the <code>ApplyImmediately</code> parameter is
         *        disabled, then changes to the <code>EnableIAMDatabaseAuthentication</code>,
         *        <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values are applied during the
         *        next maintenance window. All other changes are applied immediately, regardless of the value of the
         *        <code>ApplyImmediately</code> parameter.
         *        </p>
         *        <p>
         *        By default, this parameter is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The number of days for which automated backups are retained. You must specify a minimum value of 1.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a value from 1 to 35
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained. You must specify a minimum value of
         *        1.</p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a value from 1 to 35
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The name of the DB cluster parameter group to use for the DB cluster.
         * </p>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to use for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * A list of VPC security groups that the DB cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the DB cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups that the DB cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the DB cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The port number on which the DB cluster accepts connections.
         * </p>
         * <p>
         * Constraints: Value must be <code>1150-65535</code>
         * </p>
         * <p>
         * Default: The same port as the original DB cluster.
         * </p>
         * 
         * @param port
         *        The port number on which the DB cluster accepts connections.</p>
         *        <p>
         *        Constraints: Value must be <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default: The same port as the original DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The new password for the master database user. This password can contain any printable ASCII character except
         * "/", """, or "@".
         * </p>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * </p>
         * 
         * @param masterUserPassword
         *        The new password for the master database user. This password can contain any printable ASCII character
         *        except "/", """, or "@".</p>
         *        <p>
         *        Constraints: Must contain from 8 to 41 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * A value that indicates that the DB cluster should be associated with the specified option group. Changing
         * this parameter doesn't result in an outage except in the following case, and the change is applied during the
         * next maintenance window unless the <code>ApplyImmediately</code> is enabled for this request. If the
         * parameter change results in an option group that enables OEM, this change can cause a brief (sub-second)
         * period during which new connections are rejected but existing connections are not interrupted.
         * </p>
         * <p>
         * Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster
         * once it is associated with a DB cluster.
         * </p>
         * 
         * @param optionGroupName
         *        A value that indicates that the DB cluster should be associated with the specified option group.
         *        Changing this parameter doesn't result in an outage except in the following case, and the change is
         *        applied during the next maintenance window unless the <code>ApplyImmediately</code> is enabled for
         *        this request. If the parameter change results in an option group that enables OEM, this change can
         *        cause a brief (sub-second) period during which new connections are rejected but existing connections
         *        are not interrupted. </p>
         *        <p>
         *        Permanent options can't be removed from an option group. The option group can't be removed from a DB
         *        cluster once it is associated with a DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, using the
         * <code>BackupRetentionPeriod</code> parameter.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see
         * the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled,
         *        using the <code>BackupRetentionPeriod</code> parameter. </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
         *        To see the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         *        > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         * occurring on a random day of the week. To see the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * <p>
         * Constraints: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         *        occurring on a random day of the week. To see the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         *        > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        <p>
         *        Constraints: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping is disabled.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts
         *        to database accounts. By default, mapping is disabled.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         * </p>
         * </li>
         * </ul>
         * 
         * @param backtrackWindow
         *        The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
         *        <p>
         *        Default: 0
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackWindow(Long backtrackWindow);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * cluster.
         * </p>
         * 
         * @param cloudwatchLogsExportConfiguration
         *        The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific
         *        DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudwatchLogsExportConfiguration.Builder}
         * avoiding the need to create one manually via {@link CloudwatchLogsExportConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchLogsExportConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)}.
         * 
         * @param cloudwatchLogsExportConfiguration
         *        a consumer that will call methods on {@link CloudwatchLogsExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)
         */
        default Builder cloudwatchLogsExportConfiguration(
                Consumer<CloudwatchLogsExportConfiguration.Builder> cloudwatchLogsExportConfiguration) {
            return cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration.builder()
                    .applyMutation(cloudwatchLogsExportConfiguration).build());
        }

        /**
         * <p>
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
         * outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is
         * enabled.
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use
         * the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora),
         * use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to which you want to upgrade. Changing this parameter
         *        results in an outage. The change is applied during the next maintenance window unless
         *        <code>ApplyImmediately</code> is enabled.</p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible
         *        Aurora), use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible
         *        Aurora), use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for <code>aurora-postgresql</code>, use the following
         *        command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * A value that indicates whether major version upgrades are allowed.
         * </p>
         * <p>
         * Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code>
         * parameter that is a different major version than the DB cluster's current version.
         * </p>
         * 
         * @param allowMajorVersionUpgrade
         *        A value that indicates whether major version upgrades are allowed.</p>
         *        <p>
         *        Constraints: You must allow major version upgrades when specifying a value for the
         *        <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade);

        /**
         * <p>
         * The name of the DB parameter group to apply to all instances of the DB cluster.
         * </p>
         * <note>
         * <p>
         * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB
         * cluster isn't rebooted automatically. Also, parameter changes aren't applied during the next maintenance
         * window but instead are applied immediately.
         * </p>
         * </note>
         * <p>
         * Default: The existing name setting
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The DB parameter group must be in the same DB parameter group family as this DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the
         * <code>AllowMajorVersionUpgrade</code> parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceParameterGroupName
         *        The name of the DB parameter group to apply to all instances of the DB cluster. </p> <note>
         *        <p>
         *        When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB
         *        cluster isn't rebooted automatically. Also, parameter changes aren't applied during the next
         *        maintenance window but instead are applied immediately.
         *        </p>
         *        </note>
         *        <p>
         *        Default: The existing name setting
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The DB parameter group must be in the same DB parameter group family as this DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>DBInstanceParameterGroupName</code> parameter is only valid in combination with the
         *        <code>AllowMajorVersionUpgrade</code> parameter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceParameterGroupName(String dbInstanceParameterGroupName);

        /**
         * <p>
         * The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the cluster
         * from its current domain. The domain must be created prior to this operation.
         * </p>
         * 
         * @param domain
         *        The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the
         *        cluster from its current domain. The domain must be created prior to this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * </p>
         * 
         * @param domainIAMRoleName
         *        Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
         * <code>serverless</code> DB engine mode.
         * </p>
         * 
         * @param scalingConfiguration
         *        The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
         *        <code>serverless</code> DB engine mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfiguration scalingConfiguration);

        /**
         * <p>
         * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
         * <code>serverless</code> DB engine mode.
         * </p>
         * This is a convenience that creates an instance of the {@link ScalingConfiguration.Builder} avoiding the need
         * to create one manually via {@link ScalingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScalingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfiguration(ScalingConfiguration)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfiguration)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfiguration.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted
         * when deletion protection is enabled. By default, deletion protection is disabled.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be
         *        deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default,
         * the HTTP endpoint is disabled.
         * </p>
         * <p>
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the
         * Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query
         * editor.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for
         * Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param enableHttpEndpoint
         *        A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By
         *        default, the HTTP endpoint is disabled.</p>
         *        <p>
         *        When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on
         *        the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with
         *        the query editor.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API
         *        for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableHttpEndpoint(Boolean enableHttpEndpoint);

        /**
         * <p>
         * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The
         * default is not to copy them.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         *        The default is not to copy them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String newDBClusterIdentifier;

        private Boolean applyImmediately;

        private Integer backupRetentionPeriod;

        private String dbClusterParameterGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Integer port;

        private String masterUserPassword;

        private String optionGroupName;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean enableIAMDatabaseAuthentication;

        private Long backtrackWindow;

        private CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

        private String engineVersion;

        private Boolean allowMajorVersionUpgrade;

        private String dbInstanceParameterGroupName;

        private String domain;

        private String domainIAMRoleName;

        private ScalingConfiguration scalingConfiguration;

        private Boolean deletionProtection;

        private Boolean enableHttpEndpoint;

        private Boolean copyTagsToSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            newDBClusterIdentifier(model.newDBClusterIdentifier);
            applyImmediately(model.applyImmediately);
            backupRetentionPeriod(model.backupRetentionPeriod);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            port(model.port);
            masterUserPassword(model.masterUserPassword);
            optionGroupName(model.optionGroupName);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            backtrackWindow(model.backtrackWindow);
            cloudwatchLogsExportConfiguration(model.cloudwatchLogsExportConfiguration);
            engineVersion(model.engineVersion);
            allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            dbInstanceParameterGroupName(model.dbInstanceParameterGroupName);
            domain(model.domain);
            domainIAMRoleName(model.domainIAMRoleName);
            scalingConfiguration(model.scalingConfiguration);
            deletionProtection(model.deletionProtection);
            enableHttpEndpoint(model.enableHttpEndpoint);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getNewDBClusterIdentifier() {
            return newDBClusterIdentifier;
        }

        @Override
        public final Builder newDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
            return this;
        }

        public final void setNewDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Long getBacktrackWindow() {
            return backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        public final CloudwatchLogsExportConfiguration.Builder getCloudwatchLogsExportConfiguration() {
            return cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration;
            return this;
        }

        public final void setCloudwatchLogsExportConfiguration(
                CloudwatchLogsExportConfiguration.BuilderImpl cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration
                    .build() : null;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        public final String getDbInstanceParameterGroupName() {
            return dbInstanceParameterGroupName;
        }

        @Override
        public final Builder dbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
            return this;
        }

        public final void setDbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final Boolean getEnableHttpEndpoint() {
            return enableHttpEndpoint;
        }

        @Override
        public final Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        public final void setEnableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterRequest build() {
            return new ModifyDbClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
