/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCertificatesResponse extends RdsResponse implements
        ToCopyableBuilder<ModifyCertificatesResponse.Builder, ModifyCertificatesResponse> {
    private static final SdkField<Certificate> CERTIFICATE_FIELD = SdkField.<Certificate> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyCertificatesResponse::certificate)).setter(setter(Builder::certificate))
            .constructor(Certificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD));

    private final Certificate certificate;

    private ModifyCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
    }

    /**
     * Returns the value of the Certificate property for this object.
     * 
     * @return The value of the Certificate property for this object.
     */
    public Certificate certificate() {
        return certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCertificatesResponse)) {
            return false;
        }
        ModifyCertificatesResponse other = (ModifyCertificatesResponse) obj;
        return Objects.equals(certificate(), other.certificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyCertificatesResponse").add("Certificate", certificate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCertificatesResponse, T> g) {
        return obj -> g.apply((ModifyCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCertificatesResponse> {
        /**
         * Sets the value of the Certificate property for this object.
         *
         * @param certificate
         *        The new value for the Certificate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(Certificate certificate);

        /**
         * Sets the value of the Certificate property for this object.
         *
         * This is a convenience that creates an instance of the {@link Certificate.Builder} avoiding the need to create
         * one manually via {@link Certificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link Certificate.Builder#build()} is called immediately and its result
         * is passed to {@link #certificate(Certificate)}.
         * 
         * @param certificate
         *        a consumer that will call methods on {@link Certificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificate(Certificate)
         */
        default Builder certificate(Consumer<Certificate.Builder> certificate) {
            return certificate(Certificate.builder().applyMutation(certificate).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private Certificate certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCertificatesResponse model) {
            super(model);
            certificate(model.certificate);
        }

        public final Certificate.Builder getCertificate() {
            return certificate != null ? certificate.toBuilder() : null;
        }

        @Override
        public final Builder certificate(Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(Certificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public ModifyCertificatesResponse build() {
            return new ModifyCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
