/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportInstallationMediaRequest extends RdsRequest implements
        ToCopyableBuilder<ImportInstallationMediaRequest.Builder, ImportInstallationMediaRequest> {
    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportInstallationMediaRequest::customAvailabilityZoneId))
            .setter(setter(Builder::customAvailabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneId").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportInstallationMediaRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportInstallationMediaRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> ENGINE_INSTALLATION_MEDIA_PATH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportInstallationMediaRequest::engineInstallationMediaPath))
            .setter(setter(Builder::engineInstallationMediaPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineInstallationMediaPath")
                    .build()).build();

    private static final SdkField<String> OS_INSTALLATION_MEDIA_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportInstallationMediaRequest::osInstallationMediaPath))
            .setter(setter(Builder::osInstallationMediaPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSInstallationMediaPath").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_AVAILABILITY_ZONE_ID_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, ENGINE_INSTALLATION_MEDIA_PATH_FIELD,
            OS_INSTALLATION_MEDIA_PATH_FIELD));

    private final String customAvailabilityZoneId;

    private final String engine;

    private final String engineVersion;

    private final String engineInstallationMediaPath;

    private final String osInstallationMediaPath;

    private ImportInstallationMediaRequest(BuilderImpl builder) {
        super(builder);
        this.customAvailabilityZoneId = builder.customAvailabilityZoneId;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineInstallationMediaPath = builder.engineInstallationMediaPath;
        this.osInstallationMediaPath = builder.osInstallationMediaPath;
    }

    /**
     * <p>
     * The identifier of the custom Availability Zone (AZ) to import the installation media to.
     * </p>
     * 
     * @return The identifier of the custom Availability Zone (AZ) to import the installation media to.
     */
    public String customAvailabilityZoneId() {
        return customAvailabilityZoneId;
    }

    /**
     * <p>
     * The name of the database engine to be used for this instance.
     * </p>
     * <p>
     * The list only includes supported DB engines that require an on-premises customer provided license.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sqlserver-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ex</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-web</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the database engine to be used for this instance. </p>
     *         <p>
     *         The list only includes supported DB engines that require an on-premises customer provided license.
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sqlserver-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ex</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-web</code>
     *         </p>
     *         </li>
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the database engine to use.
     * </p>
     * <p>
     * For a list of valid engine versions, call <a>DescribeDBEngineVersions</a>.
     * </p>
     * <p>
     * The following are the database engines and links to information about the major and minor versions. The list only
     * includes DB engines that require an on-premises customer provided license.
     * </p>
     * <p>
     * <b>Microsoft SQL Server</b>
     * </p>
     * <p>
     * See <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport"
     * >Version and Feature Support on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The version number of the database engine to use.</p>
     *         <p>
     *         For a list of valid engine versions, call <a>DescribeDBEngineVersions</a>.
     *         </p>
     *         <p>
     *         The following are the database engines and links to information about the major and minor versions. The
     *         list only includes DB engines that require an on-premises customer provided license.
     *         </p>
     *         <p>
     *         <b>Microsoft SQL Server</b>
     *         </p>
     *         <p>
     *         See <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport"
     *         >Version and Feature Support on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The path to the installation medium for the specified DB engine.
     * </p>
     * <p>
     * Example: <code>SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso</code>
     * </p>
     * 
     * @return The path to the installation medium for the specified DB engine.</p>
     *         <p>
     *         Example: <code>SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso</code>
     */
    public String engineInstallationMediaPath() {
        return engineInstallationMediaPath;
    }

    /**
     * <p>
     * The path to the installation medium for the operating system associated with the specified DB engine.
     * </p>
     * <p>
     * Example: <code>WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso</code>
     * </p>
     * 
     * @return The path to the installation medium for the operating system associated with the specified DB engine.</p>
     *         <p>
     *         Example: <code>WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso</code>
     */
    public String osInstallationMediaPath() {
        return osInstallationMediaPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineInstallationMediaPath());
        hashCode = 31 * hashCode + Objects.hashCode(osInstallationMediaPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstallationMediaRequest)) {
            return false;
        }
        ImportInstallationMediaRequest other = (ImportInstallationMediaRequest) obj;
        return Objects.equals(customAvailabilityZoneId(), other.customAvailabilityZoneId())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(engineInstallationMediaPath(), other.engineInstallationMediaPath())
                && Objects.equals(osInstallationMediaPath(), other.osInstallationMediaPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportInstallationMediaRequest").add("CustomAvailabilityZoneId", customAvailabilityZoneId())
                .add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("EngineInstallationMediaPath", engineInstallationMediaPath())
                .add("OSInstallationMediaPath", osInstallationMediaPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(customAvailabilityZoneId()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EngineInstallationMediaPath":
            return Optional.ofNullable(clazz.cast(engineInstallationMediaPath()));
        case "OSInstallationMediaPath":
            return Optional.ofNullable(clazz.cast(osInstallationMediaPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportInstallationMediaRequest, T> g) {
        return obj -> g.apply((ImportInstallationMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportInstallationMediaRequest> {
        /**
         * <p>
         * The identifier of the custom Availability Zone (AZ) to import the installation media to.
         * </p>
         * 
         * @param customAvailabilityZoneId
         *        The identifier of the custom Availability Zone (AZ) to import the installation media to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZoneId(String customAvailabilityZoneId);

        /**
         * <p>
         * The name of the database engine to be used for this instance.
         * </p>
         * <p>
         * The list only includes supported DB engines that require an on-premises customer provided license.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sqlserver-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ex</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-web</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The name of the database engine to be used for this instance. </p>
         *        <p>
         *        The list only includes supported DB engines that require an on-premises customer provided license.
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sqlserver-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ex</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-web</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the database engine to use.
         * </p>
         * <p>
         * For a list of valid engine versions, call <a>DescribeDBEngineVersions</a>.
         * </p>
         * <p>
         * The following are the database engines and links to information about the major and minor versions. The list
         * only includes DB engines that require an on-premises customer provided license.
         * </p>
         * <p>
         * <b>Microsoft SQL Server</b>
         * </p>
         * <p>
         * See <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport"
         * >Version and Feature Support on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to use.</p>
         *        <p>
         *        For a list of valid engine versions, call <a>DescribeDBEngineVersions</a>.
         *        </p>
         *        <p>
         *        The following are the database engines and links to information about the major and minor versions.
         *        The list only includes DB engines that require an on-premises customer provided license.
         *        </p>
         *        <p>
         *        <b>Microsoft SQL Server</b>
         *        </p>
         *        <p>
         *        See <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport"
         *        >Version and Feature Support on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The path to the installation medium for the specified DB engine.
         * </p>
         * <p>
         * Example: <code>SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso</code>
         * </p>
         * 
         * @param engineInstallationMediaPath
         *        The path to the installation medium for the specified DB engine.</p>
         *        <p>
         *        Example: <code>SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineInstallationMediaPath(String engineInstallationMediaPath);

        /**
         * <p>
         * The path to the installation medium for the operating system associated with the specified DB engine.
         * </p>
         * <p>
         * Example: <code>WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso</code>
         * </p>
         * 
         * @param osInstallationMediaPath
         *        The path to the installation medium for the operating system associated with the specified DB
         *        engine.</p>
         *        <p>
         *        Example: <code>WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osInstallationMediaPath(String osInstallationMediaPath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String customAvailabilityZoneId;

        private String engine;

        private String engineVersion;

        private String engineInstallationMediaPath;

        private String osInstallationMediaPath;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstallationMediaRequest model) {
            super(model);
            customAvailabilityZoneId(model.customAvailabilityZoneId);
            engine(model.engine);
            engineVersion(model.engineVersion);
            engineInstallationMediaPath(model.engineInstallationMediaPath);
            osInstallationMediaPath(model.osInstallationMediaPath);
        }

        public final String getCustomAvailabilityZoneId() {
            return customAvailabilityZoneId;
        }

        @Override
        public final Builder customAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
            return this;
        }

        public final void setCustomAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getEngineInstallationMediaPath() {
            return engineInstallationMediaPath;
        }

        @Override
        public final Builder engineInstallationMediaPath(String engineInstallationMediaPath) {
            this.engineInstallationMediaPath = engineInstallationMediaPath;
            return this;
        }

        public final void setEngineInstallationMediaPath(String engineInstallationMediaPath) {
            this.engineInstallationMediaPath = engineInstallationMediaPath;
        }

        public final String getOsInstallationMediaPath() {
            return osInstallationMediaPath;
        }

        @Override
        public final Builder osInstallationMediaPath(String osInstallationMediaPath) {
            this.osInstallationMediaPath = osInstallationMediaPath;
            return this;
        }

        public final void setOsInstallationMediaPath(String osInstallationMediaPath) {
            this.osInstallationMediaPath = osInstallationMediaPath;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportInstallationMediaRequest build() {
            return new ImportInstallationMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
