/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPRange implements SdkPojo, Serializable, ToCopyableBuilder<IPRange.Builder, IPRange> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IPRange::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CIDRIP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IPRange::cidrip)).setter(setter(Builder::cidrip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CIDRIP").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CIDRIP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String cidrip;

    private IPRange(BuilderImpl builder) {
        this.status = builder.status;
        this.cidrip = builder.cidrip;
    }

    /**
     * <p>
     * Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".
     * </p>
     * 
     * @return Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and
     *         "revoked".
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Specifies the IP range.
     * </p>
     * 
     * @return Specifies the IP range.
     */
    public String cidrip() {
        return cidrip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(cidrip());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPRange)) {
            return false;
        }
        IPRange other = (IPRange) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(cidrip(), other.cidrip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IPRange").add("Status", status()).add("CIDRIP", cidrip()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CIDRIP":
            return Optional.ofNullable(clazz.cast(cidrip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPRange, T> g) {
        return obj -> g.apply((IPRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPRange> {
        /**
         * <p>
         * Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".
         * </p>
         * 
         * @param status
         *        Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and
         *        "revoked".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the IP range.
         * </p>
         * 
         * @param cidrip
         *        Specifies the IP range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrip(String cidrip);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String cidrip;

        private BuilderImpl() {
        }

        private BuilderImpl(IPRange model) {
            status(model.status);
            cidrip(model.cidrip);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCidrip() {
            return cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final void setCidrip(String cidrip) {
            this.cidrip = cidrip;
        }

        @Override
        public IPRange build() {
            return new IPRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
