/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data structure with information about any primary and secondary clusters associated with an Aurora global database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalClusterMember implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalClusterMember.Builder, GlobalClusterMember> {
    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlobalClusterMember::dbClusterArn)).setter(setter(Builder::dbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()).build();

    private static final SdkField<List<String>> READERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GlobalClusterMember::readers))
            .setter(setter(Builder::readers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Readers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_WRITER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GlobalClusterMember::isWriter)).setter(setter(Builder::isWriter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsWriter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ARN_FIELD,
            READERS_FIELD, IS_WRITER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbClusterArn;

    private final List<String> readers;

    private final Boolean isWriter;

    private GlobalClusterMember(BuilderImpl builder) {
        this.dbClusterArn = builder.dbClusterArn;
        this.readers = builder.readers;
        this.isWriter = builder.isWriter;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for each Aurora cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for each Aurora cluster.
     */
    public String dbClusterArn() {
        return dbClusterArn;
    }

    /**
     * Returns true if the Readers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReaders() {
        return readers != null && !(readers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global
     *         database.
     */
    public List<String> readers() {
        return readers;
    }

    /**
     * <p>
     * Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora
     * global database with which it is associated.
     * </p>
     * 
     * @return Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the
     *         Aurora global database with which it is associated.
     */
    public Boolean isWriter() {
        return isWriter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(readers());
        hashCode = 31 * hashCode + Objects.hashCode(isWriter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalClusterMember)) {
            return false;
        }
        GlobalClusterMember other = (GlobalClusterMember) obj;
        return Objects.equals(dbClusterArn(), other.dbClusterArn()) && Objects.equals(readers(), other.readers())
                && Objects.equals(isWriter(), other.isWriter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GlobalClusterMember").add("DBClusterArn", dbClusterArn()).add("Readers", readers())
                .add("IsWriter", isWriter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterArn":
            return Optional.ofNullable(clazz.cast(dbClusterArn()));
        case "Readers":
            return Optional.ofNullable(clazz.cast(readers()));
        case "IsWriter":
            return Optional.ofNullable(clazz.cast(isWriter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalClusterMember, T> g) {
        return obj -> g.apply((GlobalClusterMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalClusterMember> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for each Aurora cluster.
         * </p>
         * 
         * @param dbClusterArn
         *        The Amazon Resource Name (ARN) for each Aurora cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterArn(String dbClusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global
         * database.
         * </p>
         * 
         * @param readers
         *        The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global
         *        database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readers(Collection<String> readers);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global
         * database.
         * </p>
         * 
         * @param readers
         *        The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global
         *        database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readers(String... readers);

        /**
         * <p>
         * Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the
         * Aurora global database with which it is associated.
         * </p>
         * 
         * @param isWriter
         *        Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for
         *        the Aurora global database with which it is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isWriter(Boolean isWriter);
    }

    static final class BuilderImpl implements Builder {
        private String dbClusterArn;

        private List<String> readers = DefaultSdkAutoConstructList.getInstance();

        private Boolean isWriter;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalClusterMember model) {
            dbClusterArn(model.dbClusterArn);
            readers(model.readers);
            isWriter(model.isWriter);
        }

        public final String getDbClusterArn() {
            return dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        public final Collection<String> getReaders() {
            return readers;
        }

        @Override
        public final Builder readers(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readers(String... readers) {
            readers(Arrays.asList(readers));
            return this;
        }

        public final void setReaders(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
        }

        public final Boolean getIsWriter() {
            return isWriter;
        }

        @Override
        public final Builder isWriter(Boolean isWriter) {
            this.isWriter = isWriter;
            return this;
        }

        public final void setIsWriter(Boolean isWriter) {
            this.isWriter = isWriter;
        }

        @Override
        public GlobalClusterMember build() {
            return new GlobalClusterMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
