/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EC2SecurityGroupListCopier {
    static List<EC2SecurityGroup> copy(Collection<EC2SecurityGroup> ec2SecurityGroupListParam) {
        if (ec2SecurityGroupListParam == null || ec2SecurityGroupListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<EC2SecurityGroup> ec2SecurityGroupListParamCopy = new ArrayList<>(ec2SecurityGroupListParam);
        return Collections.unmodifiableList(ec2SecurityGroupListParamCopy);
    }

    static List<EC2SecurityGroup> copyFromBuilder(Collection<? extends EC2SecurityGroup.Builder> ec2SecurityGroupListParam) {
        if (ec2SecurityGroupListParam == null) {
            return null;
        }
        return copy(ec2SecurityGroupListParam.stream().map(EC2SecurityGroup.Builder::build).collect(toList()));
    }
}
